/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types.semtype;

import io.ballerina.runtime.api.types.semtype.Atom;
import io.ballerina.runtime.api.types.semtype.Bdd;
import io.ballerina.runtime.api.types.semtype.BddAllOrNothing;
import io.ballerina.runtime.api.types.semtype.BddNode;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Conjunction;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.Env;
import io.ballerina.runtime.api.types.semtype.Pair;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.types.semtype.SubType;
import io.ballerina.runtime.internal.types.semtype.BIntSubType;
import io.ballerina.runtime.internal.types.semtype.DelegatedSubType;
import io.ballerina.runtime.internal.types.semtype.FixedLengthArray;
import io.ballerina.runtime.internal.types.semtype.ListAtomicType;
import io.ballerina.runtime.internal.types.semtype.SubTypeData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;

public class BListSubType
extends SubType
implements DelegatedSubType {
    public final Bdd inner;

    private BListSubType(Bdd inner) {
        super(inner.isAll(), inner.isNothing());
        this.inner = inner;
    }

    public static BListSubType createDelegate(SubType inner) {
        if (inner instanceof Bdd) {
            Bdd bdd = (Bdd)inner;
            return new BListSubType(bdd);
        }
        if (inner.isAll() || inner.isNothing()) {
            throw new IllegalStateException("unimplemented");
        }
        if (inner instanceof BListSubType) {
            BListSubType bList = (BListSubType)inner;
            return new BListSubType(bList.inner);
        }
        throw new IllegalArgumentException("Unexpected inner type");
    }

    @Override
    public SubType union(SubType other) {
        if (!(other instanceof BListSubType)) {
            throw new IllegalArgumentException("union of different subtypes");
        }
        BListSubType otherList = (BListSubType)other;
        return BListSubType.createDelegate(this.inner.union(otherList.inner));
    }

    @Override
    public SubType intersect(SubType other) {
        if (!(other instanceof BListSubType)) {
            throw new IllegalArgumentException("intersect of different subtypes");
        }
        BListSubType otherList = (BListSubType)other;
        return BListSubType.createDelegate(this.inner.intersect(otherList.inner));
    }

    @Override
    public SubType complement() {
        return BListSubType.createDelegate(this.inner.complement());
    }

    @Override
    public SubType diff(SubType other) {
        if (!(other instanceof BListSubType)) {
            throw new IllegalArgumentException("diff of different subtypes");
        }
        BListSubType otherList = (BListSubType)other;
        return BListSubType.createDelegate(this.inner.diff(otherList.inner));
    }

    @Override
    public boolean isEmpty(Context cx) {
        return cx.memoSubtypeIsEmpty(cx.listMemo, (context, bdd) -> Bdd.bddEvery(context, bdd, BListSubType::listFormulaIsEmpty), this.inner);
    }

    static boolean listFormulaIsEmpty(Context cx, Conjunction pos, Conjunction neg) {
        SemType rest;
        FixedLengthArray members;
        if (pos == null) {
            ListAtomicType atom = Builder.getListAtomicInner();
            members = atom.members();
            rest = atom.rest();
        } else {
            ListAtomicType lt = cx.listAtomType(pos.atom());
            members = lt.members();
            rest = lt.rest();
            Conjunction p = pos.next();
            if (p != null || neg != null) {
                members = members.shallowCopy();
            }
            while (p != null) {
                Atom d = p.atom();
                p = p.next();
                lt = cx.listAtomType(d);
                Pair<FixedLengthArray, SemType> intersected = BListSubType.listIntersectWith(cx.env, members, rest, lt.members(), lt.rest());
                if (intersected == null) {
                    return true;
                }
                members = intersected.first();
                rest = intersected.second();
            }
            if (BListSubType.fixedArrayAnyEmpty(cx, members)) {
                return true;
            }
        }
        Integer[] indices = BListSubType.listSamples(cx, members, rest, neg);
        Pair<SemType[], Integer> sampleTypes = BListSubType.listSampleTypes(cx, members, rest, indices);
        return !BListSubType.listInhabited(cx, indices, sampleTypes.first(), sampleTypes.second(), neg);
    }

    private static boolean listInhabited(Context cx, Integer[] indices, SemType[] memberTypes, int nRequired, Conjunction neg) {
        if (neg == null) {
            return true;
        }
        ListAtomicType nt = cx.listAtomType(neg.atom());
        if (nRequired > 0 && Core.isNever(BListSubType.listMemberAtInnerVal(nt.members(), nt.rest(), indices[nRequired - 1]))) {
            return BListSubType.listInhabited(cx, indices, memberTypes, nRequired, neg.next());
        }
        int negLen = nt.members().fixedLength();
        if (negLen > 0) {
            int index;
            int i;
            int len = memberTypes.length;
            for (i = 0; i < len && (index = indices[i].intValue()) < negLen; ++i) {
                SemType negMemberType = BListSubType.listMemberAt(nt.members(), nt.rest(), index);
                SemType common = Core.intersect(memberTypes[i], negMemberType);
                if (!Core.isEmpty(cx, common)) continue;
                return BListSubType.listInhabited(cx, indices, memberTypes, nRequired, neg.next());
            }
            if (len < indices.length && indices[len] < negLen) {
                return BListSubType.listInhabited(cx, indices, memberTypes, nRequired, neg.next());
            }
            for (i = nRequired; i < memberTypes.length && indices[i] < negLen; ++i) {
                SemType[] t = Arrays.copyOfRange(memberTypes, 0, i);
                if (!BListSubType.listInhabited(cx, indices, t, nRequired, neg.next())) continue;
                return true;
            }
        }
        for (int i = 0; i < memberTypes.length; ++i) {
            SemType d = Core.diff(memberTypes[i], BListSubType.listMemberAt(nt.members(), nt.rest(), indices[i]));
            if (Core.isEmpty(cx, d)) continue;
            SemType[] t = (SemType[])memberTypes.clone();
            t[i] = d;
            if (!BListSubType.listInhabited(cx, indices, t, Integer.max(nRequired, i + 1), neg.next())) continue;
            return true;
        }
        return false;
    }

    public static Pair<SemType[], Integer> listSampleTypes(Context cx, FixedLengthArray members, SemType rest, Integer[] indices) {
        int index;
        SemType t;
        ArrayList<SemType> memberTypes = new ArrayList<SemType>(indices.length);
        int nRequired = 0;
        for (int i = 0; i < indices.length && !Core.isEmpty(cx, t = Core.getCellContainingInnerVal(cx.env, BListSubType.listMemberAt(members, rest, index = indices[i].intValue()))); ++i) {
            memberTypes.add(t);
            if (index >= members.fixedLength()) continue;
            nRequired = i + 1;
        }
        SemType[] buffer = new SemType[memberTypes.size()];
        return Pair.from(memberTypes.toArray(buffer), nRequired);
    }

    public static Integer[] listSamples(Context cx, FixedLengthArray members, SemType rest, Conjunction neg) {
        int maxInitialLength = members.initial().length;
        ArrayList<Integer> fixedLengths = new ArrayList<Integer>();
        fixedLengths.add(members.fixedLength());
        int nNeg = 0;
        for (Conjunction tem = neg; tem != null; tem = tem.next()) {
            ListAtomicType lt = cx.listAtomType(tem.atom());
            FixedLengthArray m = lt.members();
            maxInitialLength = Integer.max(maxInitialLength, m.initial().length);
            if (m.fixedLength() > maxInitialLength) {
                fixedLengths.add(m.fixedLength());
            }
            ++nNeg;
        }
        Collections.sort(fixedLengths);
        ArrayList<Integer> boundaries = new ArrayList<Integer>(fixedLengths.size());
        for (int i = 1; i <= maxInitialLength; ++i) {
            boundaries.add(i);
        }
        Iterator i = fixedLengths.iterator();
        while (i.hasNext()) {
            int n = (Integer)i.next();
            if (!boundaries.isEmpty() && n <= (Integer)boundaries.get(boundaries.size() - 1)) continue;
            boundaries.add(n);
        }
        ArrayList<Integer> indices = new ArrayList<Integer>(boundaries.size());
        int lastBoundary = 0;
        if (nNeg == 0) {
            nNeg = 1;
        }
        Iterator iterator = boundaries.iterator();
        while (iterator.hasNext()) {
            int b = (Integer)iterator.next();
            int segmentLength = b - lastBoundary;
            int nSamples = Integer.min(segmentLength, nNeg);
            for (int i2 = b - nSamples; i2 < b; ++i2) {
                indices.add(i2);
            }
            lastBoundary = b;
        }
        for (int i3 = 0; i3 < nNeg && lastBoundary <= Integer.MAX_VALUE - i3; ++i3) {
            indices.add(lastBoundary + i3);
        }
        Integer[] arr = new Integer[indices.size()];
        return indices.toArray(arr);
    }

    public static boolean fixedArrayAnyEmpty(Context cx, FixedLengthArray array) {
        for (SemType t : array.initial()) {
            if (!Core.isEmpty(cx, t)) continue;
            return true;
        }
        return false;
    }

    public static Pair<FixedLengthArray, SemType> listIntersectWith(Env env, FixedLengthArray members1, SemType rest1, FixedLengthArray members2, SemType rest2) {
        if (BListSubType.listLengthsDisjoint(members1, rest1, members2, rest2)) {
            return null;
        }
        int max = Integer.max(members1.fixedLength(), members2.fixedLength());
        SemType[] initial = new SemType[max];
        for (int i = 0; i < max; ++i) {
            initial[i] = Core.intersectCellMemberSemTypes(env, BListSubType.listMemberAt(members1, rest1, i), BListSubType.listMemberAt(members2, rest2, i));
        }
        return Pair.from(FixedLengthArray.from(initial, Integer.max(members1.fixedLength(), members2.fixedLength())), Core.intersectCellMemberSemTypes(env, rest1, rest2));
    }

    private static boolean listLengthsDisjoint(FixedLengthArray members1, SemType rest1, FixedLengthArray members2, SemType rest2) {
        int len2;
        int len1 = members1.fixedLength();
        if (len1 < (len2 = members2.fixedLength())) {
            return Core.isNever(Core.cellInnerVal(rest1));
        }
        if (len2 < len1) {
            return Core.isNever(Core.cellInnerVal(rest2));
        }
        return false;
    }

    private static SemType listMemberAt(FixedLengthArray fixedArray, SemType rest, int index) {
        if (index < fixedArray.fixedLength()) {
            return BListSubType.fixedArrayGet(fixedArray, index);
        }
        return rest;
    }

    private static SemType fixedArrayGet(FixedLengthArray members, int index) {
        int memberLen = members.initial().length;
        int i = Integer.min(index, memberLen - 1);
        return members.initial()[i];
    }

    public static SemType listMemberAtInnerVal(FixedLengthArray fixedArray, SemType rest, int index) {
        return Core.cellInnerVal(BListSubType.listMemberAt(fixedArray, rest, index));
    }

    public static SemType bddListMemberTypeInnerVal(Context cx, Bdd b, SubTypeData key, SemType accum) {
        if (b instanceof BddAllOrNothing) {
            BddAllOrNothing allOrNothing = (BddAllOrNothing)b;
            return allOrNothing.isAll() ? accum : Builder.getNeverType();
        }
        BddNode bddNode = (BddNode)b;
        return Core.union(BListSubType.bddListMemberTypeInnerVal(cx, bddNode.left(), key, Core.intersect(BListSubType.listAtomicMemberTypeInnerVal(cx.listAtomType(bddNode.atom()), key), accum)), Core.union(BListSubType.bddListMemberTypeInnerVal(cx, bddNode.middle(), key, accum), BListSubType.bddListMemberTypeInnerVal(cx, bddNode.right(), key, accum)));
    }

    private static SemType listAtomicMemberTypeInnerVal(ListAtomicType atomic, SubTypeData key) {
        return Core.diff(BListSubType.listAtomicMemberTypeInner(atomic, key), Builder.getUndefType());
    }

    private static SemType listAtomicMemberTypeInner(ListAtomicType atomic, SubTypeData key) {
        return BListSubType.listAtomicMemberTypeAtInner(atomic.members(), atomic.rest(), key);
    }

    static SemType listAtomicMemberTypeAtInner(FixedLengthArray fixedArray, SemType rest, SubTypeData key) {
        if (key instanceof BIntSubType.IntSubTypeData) {
            BIntSubType.IntSubTypeData intSubtype = (BIntSubType.IntSubTypeData)key;
            SemType m = Builder.getNeverType();
            int initLen = fixedArray.initial().length;
            int fixedLen = fixedArray.fixedLength();
            if (fixedLen != 0) {
                for (int i = 0; i < initLen; ++i) {
                    if (!BIntSubType.intSubtypeContains(key, i)) continue;
                    m = Core.union(m, Core.cellInner(BListSubType.fixedArrayGet(fixedArray, i)));
                }
                if (intSubtype.isRangeOverlap(new BIntSubType.Range(initLen, fixedLen - 1))) {
                    m = Core.union(m, Core.cellInner(BListSubType.fixedArrayGet(fixedArray, fixedLen - 1)));
                }
            }
            if (fixedLen == 0 || intSubtype.max() > (long)(fixedLen - 1)) {
                m = Core.union(m, Core.cellInner(rest));
            }
            return m;
        }
        SemType m = Core.cellInner(rest);
        if (fixedArray.fixedLength() > 0) {
            for (SemType ty : fixedArray.initial()) {
                m = Core.union(m, Core.cellInner(ty));
            }
        }
        return m;
    }

    @Override
    public SubTypeData data() {
        return this.inner();
    }

    @Override
    public Bdd inner() {
        return this.inner;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BListSubType)) {
            return false;
        }
        BListSubType that = (BListSubType)o;
        return Objects.equals(this.inner, that.inner);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.inner);
    }
}

