/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types.semtype;

import io.ballerina.runtime.api.types.semtype.BasicTypeCode;
import io.ballerina.runtime.api.types.semtype.Bdd;
import io.ballerina.runtime.api.types.semtype.BddAllOrNothing;
import io.ballerina.runtime.api.types.semtype.BddNode;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.internal.types.semtype.AllOrNothing;
import io.ballerina.runtime.internal.types.semtype.BStringSubType;
import io.ballerina.runtime.internal.types.semtype.MappingAtomicType;
import io.ballerina.runtime.internal.types.semtype.SubTypeData;
import java.util.ArrayList;
import java.util.List;

public final class BMappingProj {
    private BMappingProj() {
    }

    public static SemType mappingMemberTypeInnerVal(Context cx, SemType t, SemType k) {
        return Core.diff(BMappingProj.mappingMemberTypeInner(cx, t, k), Builder.getUndefType());
    }

    public static SemType mappingMemberTypeInner(Context cx, SemType t, SemType k) {
        if (t.some() == 0) {
            return (t.all() & Builder.getMappingType().all()) != 0 ? Builder.getValType() : Builder.getUndefType();
        }
        SubTypeData keyData = Core.stringSubtype(k);
        if (Core.isNothingSubtype(keyData)) {
            return Builder.getUndefType();
        }
        return BMappingProj.bddMappingMemberTypeInner(cx, (Bdd)Core.getComplexSubtypeData(t, BasicTypeCode.BT_MAPPING), keyData, Builder.getInnerType());
    }

    static SemType bddMappingMemberTypeInner(Context cx, Bdd b, SubTypeData key, SemType accum) {
        if (b instanceof BddAllOrNothing) {
            BddAllOrNothing allOrNothing = (BddAllOrNothing)b;
            return allOrNothing.isAll() ? accum : Builder.getNeverType();
        }
        BddNode bdd = (BddNode)b;
        return Core.union(BMappingProj.bddMappingMemberTypeInner(cx, bdd.left(), key, Core.intersect(BMappingProj.mappingAtomicMemberTypeInner(cx.mappingAtomType(bdd.atom()), key), accum)), Core.union(BMappingProj.bddMappingMemberTypeInner(cx, bdd.middle(), key, accum), BMappingProj.bddMappingMemberTypeInner(cx, bdd.right(), key, accum)));
    }

    static SemType mappingAtomicMemberTypeInner(MappingAtomicType atomic, SubTypeData key) {
        SemType memberType = null;
        for (SemType ty : BMappingProj.mappingAtomicApplicableMemberTypesInner(atomic, key)) {
            if (memberType == null) {
                memberType = ty;
                continue;
            }
            memberType = Core.union(memberType, ty);
        }
        return memberType == null ? Builder.getUndefType() : memberType;
    }

    static List<SemType> mappingAtomicApplicableMemberTypesInner(MappingAtomicType atomic, SubTypeData key) {
        ArrayList<SemType> types = new ArrayList<SemType>(atomic.types().length);
        for (SemType t : atomic.types()) {
            types.add(Core.cellInner(t));
        }
        ArrayList<SemType> memberTypes = new ArrayList<SemType>();
        SemType rest = Core.cellInner(atomic.rest());
        if (BMappingProj.isAllSubtype(key)) {
            memberTypes.addAll(types);
            memberTypes.add(rest);
        } else {
            BStringSubType.StringSubtypeListCoverage coverage = ((BStringSubType.StringSubTypeData)key).stringSubtypeListCoverage(atomic.names());
            for (int index : coverage.indices()) {
                memberTypes.add((SemType)types.get(index));
            }
            if (!coverage.isSubType()) {
                memberTypes.add(rest);
            }
        }
        return memberTypes;
    }

    static boolean isAllSubtype(SubTypeData d) {
        return d == AllOrNothing.ALL;
    }
}

