/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types.semtype;

import io.ballerina.runtime.api.types.semtype.BasicTypeCode;
import io.ballerina.runtime.api.types.semtype.Bdd;
import io.ballerina.runtime.api.types.semtype.BddNode;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.RecAtom;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.types.semtype.SubType;
import io.ballerina.runtime.internal.types.semtype.AllOrNothing;
import io.ballerina.runtime.internal.types.semtype.BErrorSubType;
import io.ballerina.runtime.internal.types.semtype.SubTypeData;

public final class ErrorUtils {
    private ErrorUtils() {
    }

    public static SemType errorDetail(SemType detail) {
        SubTypeData data = Core.subTypeData(detail, BasicTypeCode.BT_MAPPING);
        if (data == AllOrNothing.ALL) {
            return Builder.getErrorType();
        }
        if (data == AllOrNothing.NOTHING) {
            return Builder.getNeverType();
        }
        assert (data instanceof Bdd);
        SubType sd = ((Bdd)data).intersect(Builder.getBddSubtypeRo());
        if (sd.equals(Builder.getBddSubtypeRo())) {
            return Builder.getErrorType();
        }
        return Builder.basicSubType(BasicTypeCode.BT_ERROR, BErrorSubType.createDelegate(sd));
    }

    public static SemType errorDistinct(int distinctId) {
        assert (distinctId >= 0);
        BddNode bdd = BddNode.bddAtom(RecAtom.createDistinctRecAtom(-distinctId - 1));
        return Builder.basicSubType(BasicTypeCode.BT_ERROR, BErrorSubType.createDelegate(bdd));
    }
}

