/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types.semtype;

import io.ballerina.runtime.api.types.semtype.AtomicType;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.Env;
import io.ballerina.runtime.api.types.semtype.FieldPair;
import io.ballerina.runtime.api.types.semtype.FieldPairs;
import io.ballerina.runtime.api.types.semtype.SemType;
import java.util.ArrayList;

public record MappingAtomicType(String[] names, SemType[] types, SemType rest) implements AtomicType
{
    public MappingAtomicType {
        assert (names.length == types.length);
    }

    public MappingAtomicType intersectMapping(Env env, MappingAtomicType other) {
        int expectedSize = Integer.min(this.types().length, other.types().length);
        ArrayList<String> names = new ArrayList<String>(expectedSize);
        ArrayList<SemType> types = new ArrayList<SemType>(expectedSize);
        for (FieldPair fieldPair : new FieldPairs(this, other)) {
            names.add(fieldPair.name());
            SemType t = Core.intersectCellMemberSemTypes(env, fieldPair.type1(), fieldPair.type2());
            if (Core.isNever(Core.cellInner(fieldPair.type1()))) {
                return null;
            }
            types.add(t);
        }
        SemType rest = Core.intersectCellMemberSemTypes(env, this.rest(), other.rest());
        return new MappingAtomicType((String[])names.toArray(String[]::new), (SemType[])types.toArray(SemType[]::new), rest);
    }
}

