/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.types.semtype.ShapeAnalyzer;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BFunctionPointer;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BMapInitialValueEntry;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BRefValue;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.api.values.BValue;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import io.ballerina.runtime.internal.json.JsonGenerator;
import io.ballerina.runtime.internal.json.JsonInternalUtils;
import io.ballerina.runtime.internal.scheduling.Scheduler;
import io.ballerina.runtime.internal.types.BField;
import io.ballerina.runtime.internal.types.BRecordType;
import io.ballerina.runtime.internal.types.BTupleType;
import io.ballerina.runtime.internal.types.BUnionType;
import io.ballerina.runtime.internal.types.TypeWithShape;
import io.ballerina.runtime.internal.types.semtype.MappingDefinition;
import io.ballerina.runtime.internal.utils.CycleUtils;
import io.ballerina.runtime.internal.utils.IteratorUtils;
import io.ballerina.runtime.internal.utils.MapUtils;
import io.ballerina.runtime.internal.utils.StringUtils;
import io.ballerina.runtime.internal.utils.ValueUtils;
import io.ballerina.runtime.internal.values.BmpStringValue;
import io.ballerina.runtime.internal.values.CollectionValue;
import io.ballerina.runtime.internal.values.IteratorValue;
import io.ballerina.runtime.internal.values.MapValue;
import io.ballerina.runtime.internal.values.MappingInitialValueEntry;
import io.ballerina.runtime.internal.values.ReadOnlyUtils;
import io.ballerina.runtime.internal.values.RecursiveValue;
import io.ballerina.runtime.internal.values.RefValue;
import io.ballerina.runtime.internal.values.TupleValueImpl;
import io.ballerina.runtime.internal.values.TypedescValue;
import io.ballerina.runtime.internal.values.ValuePair;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public class MapValueImpl<K, V>
extends LinkedHashMap<K, V>
implements RefValue,
CollectionValue,
MapValue<K, V>,
BMap<K, V>,
RecursiveValue<MappingDefinition> {
    private static final BasicTypeBitSet BASIC_TYPE = Builder.getMappingType();
    private BTypedesc typedesc;
    private Type type;
    private Type referredType;
    private final Map<String, Object> nativeData = new HashMap<String, Object>();
    private Type iteratorNextReturnType;
    private SemType shape;
    private final ThreadLocal<MappingDefinition> readonlyAttachedDefinition = new ThreadLocal();

    public MapValueImpl(TypedescValue typedesc) {
        this(typedesc.getDescribingType());
        if (!this.type.isReadOnly()) {
            this.typedesc = typedesc;
        }
    }

    public MapValueImpl(Type type) {
        this.type = type;
        this.referredType = TypeUtils.getImpliedType(type);
    }

    public MapValueImpl(Type type, BMapInitialValueEntry[] initialValues) {
        this.type = type;
        this.referredType = TypeUtils.getImpliedType(type);
        this.populateInitialValues(initialValues);
    }

    public MapValueImpl() {
        this.referredType = this.type = PredefinedTypes.TYPE_MAP;
    }

    @Override
    public Long getIntValue(BString key) {
        Object value = this.get(key);
        if (value instanceof Integer) {
            Integer i = (Integer)value;
            return i.longValue();
        }
        return (Long)value;
    }

    public long getUnboxedIntValue(BString key) {
        return this.getIntValue(key);
    }

    public double getUnboxedFloatValue(BString key) {
        return this.getFloatValue(key);
    }

    public boolean getUnboxedBooleanValue(BString key) {
        return this.getBooleanValue(key);
    }

    @Override
    public Double getFloatValue(BString key) {
        return (Double)this.get(key);
    }

    @Override
    public BString getStringValue(BString key) {
        return (BString)this.get(key);
    }

    @Override
    public Boolean getBooleanValue(BString key) {
        return (Boolean)this.get(key);
    }

    @Override
    public BMap<?, ?> getMapValue(BString key) {
        return (BMap)this.get(key);
    }

    @Override
    public BObject getObjectValue(BString key) {
        return (BObject)this.get(key);
    }

    @Override
    public BArray getArrayValue(BString key) {
        return (BArray)this.get(key);
    }

    @Override
    public long getDefaultableIntValue(BString key) {
        if (this.get(key) != null) {
            return this.getIntValue(key);
        }
        return 0L;
    }

    @Override
    public V getOrThrow(Object key) {
        if (!this.containsKey(key)) {
            throw ErrorCreator.createError(ErrorReasons.MAP_KEY_NOT_FOUND_ERROR, ErrorHelper.getErrorDetails(ErrorCodes.KEY_NOT_FOUND_ERROR, key));
        }
        return this.get(key);
    }

    @Override
    public V fillAndGet(Object key) {
        if (this.containsKey(key)) {
            return this.get(key);
        }
        Type expectedType = null;
        if (this.referredType.getTag() == 24) {
            BRecordType recordType = (BRecordType)this.referredType;
            Map<String, Field> fields = recordType.getFields();
            if (fields.containsKey(key.toString())) {
                expectedType = ((BField)fields.get(key.toString())).getFieldType();
            } else {
                if (recordType.sealed) {
                    throw ErrorCreator.createError(ErrorReasons.MAP_KEY_NOT_FOUND_ERROR, ErrorHelper.getErrorDetails(ErrorCodes.KEY_NOT_FOUND_ERROR, key));
                }
                expectedType = recordType.restFieldType;
            }
        } else {
            expectedType = ((MapType)this.referredType).getConstrainedType();
        }
        if (!TypeChecker.hasFillerValue(expectedType)) {
            throw ErrorCreator.createError(ErrorReasons.MAP_KEY_NOT_FOUND_ERROR, ErrorHelper.getErrorDetails(ErrorCodes.KEY_NOT_FOUND_ERROR, key));
        }
        Object value = expectedType.getZeroValue();
        this.put(key, value);
        return value;
    }

    @Override
    public Object merge(BMap<?, ?> v2, boolean checkMergeability) {
        BError errorIfUnmergeable;
        if (checkMergeability && (errorIfUnmergeable = JsonInternalUtils.getErrorIfUnmergeable(this, v2, new ArrayList<JsonInternalUtils.ObjectPair>())) != null) {
            return errorIfUnmergeable;
        }
        MapValueImpl m1 = this;
        MapValue m2 = (MapValue)v2;
        for (Map.Entry entry : m2.entrySet()) {
            BString key = (BString)entry.getKey();
            if (!m1.containsKey(key)) {
                m1.put(key, entry.getValue());
                continue;
            }
            m1.put(key, JsonInternalUtils.mergeJson(m1.get(key), entry.getValue(), false));
        }
        return this;
    }

    @Override
    public V put(K key, V value) {
        if (!this.type.isReadOnly()) {
            return this.putValue(key, value);
        }
        String errMessage = switch (TypeUtils.getImpliedType(this.getType()).getTag()) {
            case 24 -> "Invalid update of record field: ";
            case 27 -> "Invalid map insertion: ";
            default -> "";
        };
        throw ErrorCreator.createError(ErrorReasons.getModulePrefixedReason("lang.map", "InvalidUpdate"), io.ballerina.runtime.api.utils.StringUtils.fromString(errMessage).concat(ErrorHelper.getErrorMessage(ErrorCodes.INVALID_READONLY_VALUE_UPDATE, new Object[0])));
    }

    public V putForcefully(K key, V value) {
        return this.putValue(key, value);
    }

    public void setTypeForcefully(Type type) {
        this.type = type;
        this.referredType = TypeUtils.getImpliedType(type);
    }

    protected void populateInitialValues(BMapInitialValueEntry[] initialValues) {
        HashMap<String, BFunctionPointer> defaultValues = new HashMap<String, BFunctionPointer>();
        if (this.referredType.getTag() == 24) {
            defaultValues.putAll(((BRecordType)this.referredType).getDefaultValues());
        }
        for (BMapInitialValueEntry initialValue : initialValues) {
            if (initialValue.isKeyValueEntry()) {
                MappingInitialValueEntry.KeyValueEntry keyValueEntry = (MappingInitialValueEntry.KeyValueEntry)initialValue;
                Object mapKey = keyValueEntry.key;
                defaultValues.remove(mapKey.toString());
                this.populateInitialValue(mapKey, keyValueEntry.value);
                continue;
            }
            MapValueImpl values = (MapValueImpl)((MappingInitialValueEntry.SpreadFieldEntry)initialValue).values;
            for (Map.Entry entry : values.entrySet()) {
                Object entryKey = entry.getKey();
                defaultValues.remove(entryKey.toString());
                this.populateInitialValue(entryKey, entry.getValue());
            }
        }
        for (Map.Entry entry : defaultValues.entrySet()) {
            String key = (String)entry.getKey();
            this.populateInitialValue(new BmpStringValue(key), ((BFunctionPointer)entry.getValue()).call(Scheduler.getStrand().scheduler.runtime, new Object[0]));
        }
    }

    @Override
    public void populateInitialValue(K key, V value) {
        if (this.referredType.getTag() == 27) {
            MapUtils.handleInherentTypeViolatingMapUpdate(value, (MapType)this.referredType);
            this.putValue(key, value);
        } else {
            BString fieldName = (BString)key;
            if (MapUtils.handleInherentTypeViolatingRecordUpdate(this, fieldName, value, (BRecordType)this.referredType, true)) {
                this.putValue(key, value);
            }
        }
    }

    @Override
    public void clear() {
        this.validateFreezeStatus();
        super.clear();
    }

    protected void validateFreezeStatus() {
        if (!this.type.isReadOnly()) {
            return;
        }
        ReadOnlyUtils.handleInvalidUpdate("lang.map");
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(key);
    }

    @Override
    public boolean equals(Object o, Set<ValuePair> visitedValues) {
        ValuePair compValuePair = new ValuePair(this, o);
        for (ValuePair valuePair : visitedValues) {
            if (!valuePair.equals(compValuePair)) continue;
            return true;
        }
        visitedValues.add(compValuePair);
        if (!(o instanceof MapValueImpl)) {
            return false;
        }
        MapValueImpl mapValue = (MapValueImpl)o;
        if (this.entrySet().size() != mapValue.entrySet().size()) {
            return false;
        }
        if (!this.keySet().containsAll(mapValue.keySet())) {
            return false;
        }
        for (Map.Entry lhsMapEntry : this.entrySet()) {
            if (TypeChecker.isEqual(lhsMapEntry.getValue(), mapValue.get(lhsMapEntry.getKey()), visitedValues)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public V remove(Object key) {
        this.validateFreezeStatus();
        return super.remove(key);
    }

    @Override
    public K[] getKeys() {
        Set keys = super.keySet();
        BString[] keyArr = new BString[keys.size()];
        int i = 0;
        for (Object key : keys) {
            keyArr[i] = (BString)key;
            ++i;
        }
        return keyArr;
    }

    @Override
    public Collection<V> values() {
        return super.values();
    }

    @Override
    public int size() {
        return super.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public String toString() {
        return this.stringValue(null);
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        if (this.isFrozen()) {
            return this;
        }
        if (refs.containsKey(this)) {
            return refs.get(this);
        }
        MapValueImpl newMap = new MapValueImpl(this.type);
        refs.put(this, newMap);
        for (Map.Entry entry : this.entrySet()) {
            Object value = entry.getValue();
            value = value instanceof BRefValue ? ((BRefValue)value).copy(refs) : value;
            newMap.put(entry.getKey(), value);
        }
        return newMap;
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        MapValueImpl copy = (MapValueImpl)this.copy(refs);
        if (!copy.isFrozen()) {
            copy.freezeDirect();
        }
        return copy;
    }

    @Override
    public String stringValue(BLink parent) {
        StringJoiner sj = new StringJoiner(",");
        block3: for (Map.Entry kvEntry : this.entrySet()) {
            Object key = kvEntry.getKey();
            Object value = kvEntry.getValue();
            if (value == null) {
                sj.add("\"" + String.valueOf(key) + "\":null");
                continue;
            }
            Type type = TypeChecker.getType(value);
            CycleUtils.Node mapParent = new CycleUtils.Node(this, parent);
            switch (type.getTag()) {
                case 5: 
                case 16: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 38: 
                case 40: {
                    sj.add("\"" + String.valueOf(key) + "\":" + ((BValue)value).informalStringValue(mapParent));
                    continue block3;
                }
            }
            sj.add("\"" + String.valueOf(key) + "\":" + StringUtils.getStringVal(value, mapParent));
        }
        return "{" + sj.toString() + "}";
    }

    @Override
    public String expressionStringValue(BLink parent) {
        CycleUtils.Node node = new CycleUtils.Node(this, parent);
        StringJoiner sj = new StringJoiner(",");
        for (Map.Entry kvEntry : this.entrySet()) {
            Object key = kvEntry.getKey();
            Object value = kvEntry.getValue();
            CycleUtils.Node mapParent = new CycleUtils.Node(this, node);
            sj.add("\"" + String.valueOf(key) + "\":" + StringUtils.getExpressionStringVal(value, mapParent));
        }
        return "{" + sj.toString() + "}";
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void freezeDirect() {
        if (this.isFrozen()) {
            return;
        }
        this.type = ReadOnlyUtils.setImmutableTypeAndGetEffectiveType(this.type);
        this.referredType = ReadOnlyUtils.setImmutableTypeAndGetEffectiveType(this.referredType);
        this.values().forEach((? super T val) -> {
            if (val instanceof BRefValue) {
                BRefValue bRefValue = (BRefValue)val;
                bRefValue.freezeDirect();
            }
        });
        this.typedesc = null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String getJSONString() {
        try (ByteArrayOutputStream byteOut = new ByteArrayOutputStream();){
            String string;
            try (JsonGenerator gen = new JsonGenerator(byteOut);){
                gen.serialize(this);
                gen.flush();
                string = byteOut.toString();
            }
            return string;
        }
        catch (IOException e) {
            throw ErrorCreator.createError(io.ballerina.runtime.api.utils.StringUtils.fromString("Error in converting JSON to a string: " + e.getMessage()), e);
        }
    }

    @Override
    public IteratorValue<Object> getIterator() {
        return new MapIterator(new LinkedHashSet(this.entrySet()).iterator());
    }

    @Override
    public MappingDefinition getReadonlyShapeDefinition() {
        return this.readonlyAttachedDefinition.get();
    }

    @Override
    public void setReadonlyShapeDefinition(MappingDefinition definition) {
        this.readonlyAttachedDefinition.set(definition);
    }

    @Override
    public void resetReadonlyShapeDefinition() {
        this.readonlyAttachedDefinition.remove();
    }

    @Override
    public void addNativeData(String key, Object data) {
        this.nativeData.put(key, data);
    }

    @Override
    public Object getNativeData(String key) {
        return this.nativeData.get(key);
    }

    @Override
    public BTypedesc getTypedesc() {
        if (this.typedesc == null) {
            this.typedesc = ValueUtils.getTypedescValue(this.type, this);
        }
        return this.typedesc;
    }

    public Map<String, Object> getNativeDataMap() {
        return this.nativeData;
    }

    private void initializeIteratorNextReturnType() {
        Type type;
        if (this.referredType.getTag() == PredefinedTypes.TYPE_MAP.getTag()) {
            MapType mapType = (MapType)this.referredType;
            type = mapType.getConstrainedType();
        } else {
            BRecordType recordType = (BRecordType)this.referredType;
            LinkedHashSet types = recordType.getFields().values().stream().map(Field::getFieldType).collect(Collectors.toCollection(LinkedHashSet::new));
            if (recordType.restFieldType != null) {
                types.add(recordType.restFieldType);
            }
            type = types.size() == 1 ? (Type)types.iterator().next() : new BUnionType(new ArrayList<Type>(types));
        }
        this.iteratorNextReturnType = IteratorUtils.createIteratorNextReturnType(type);
    }

    @Override
    public Type getIteratorNextReturnType() {
        if (this.iteratorNextReturnType == null) {
            this.initializeIteratorNextReturnType();
        }
        return this.iteratorNextReturnType;
    }

    protected V putValue(K key, V value) {
        return super.put(key, value);
    }

    @Override
    public void cacheShape(SemType semType) {
        this.shape = semType;
    }

    @Override
    public SemType shapeOf() {
        return this.shape;
    }

    @Override
    public Optional<SemType> inherentTypeOf(Context cx) {
        TypeWithShape typeWithShape = (TypeWithShape)((Object)this.type);
        return typeWithShape.inherentTypeOf(cx, ShapeAnalyzer::inherentTypeOf, this);
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE;
    }

    static class MapIterator<K, V>
    implements IteratorValue<Object> {
        Iterator<Map.Entry<K, V>> iterator;

        MapIterator(Iterator<Map.Entry<K, V>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public Object next() {
            Map.Entry<K, V> next = this.iterator.next();
            V value = next.getValue();
            LinkedList<Type> types = new LinkedList<Type>();
            types.add(PredefinedTypes.TYPE_STRING);
            types.add(TypeChecker.getType(value));
            BTupleType tupleType = new BTupleType(types);
            TupleValueImpl tuple = new TupleValueImpl(tupleType);
            tuple.add(0L, next.getKey());
            tuple.add(1L, value);
            return tuple;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }
    }
}

