/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.constants.RuntimeConstants;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.XmlNodeType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.runtime.api.values.BXmlSequence;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.runtime.internal.types.BArrayType;
import io.ballerina.runtime.internal.types.BUnionType;
import io.ballerina.runtime.internal.utils.CycleUtils;
import io.ballerina.runtime.internal.utils.IteratorUtils;
import io.ballerina.runtime.internal.values.ArrayValueImpl;
import io.ballerina.runtime.internal.values.IteratorValue;
import io.ballerina.runtime.internal.values.MapValue;
import io.ballerina.runtime.internal.values.ReadOnlyUtils;
import io.ballerina.runtime.internal.values.ValuePair;
import io.ballerina.runtime.internal.values.XmlItem;
import io.ballerina.runtime.internal.values.XmlText;
import io.ballerina.runtime.internal.values.XmlValue;
import io.ballerina.runtime.internal.xml.XmlFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class XmlSequence
extends XmlValue
implements BXmlSequence {
    List<BXml> children;

    public XmlSequence() {
        this.children = new ArrayList<BXml>();
        this.type = PredefinedTypes.TYPE_XML_NEVER;
    }

    public XmlSequence(List<BXml> values) {
        if (values.isEmpty()) {
            this.children = values;
            return;
        }
        this.setSequenceMembersConcatenatingAdjacentTextItems(values);
    }

    public XmlSequence(BXml child) {
        this.children = new ArrayList<BXml>();
        if (!child.isEmpty()) {
            this.children.add(child);
        }
    }

    @Override
    public List<BXml> getChildrenList() {
        return this.children;
    }

    @Override
    public XmlNodeType getNodeType() {
        return XmlNodeType.SEQUENCE;
    }

    @Override
    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    @Override
    public boolean isSingleton() {
        return this.children.size() == 1 && this.children.get(0).isSingleton();
    }

    @Override
    public String getItemType() {
        if (this.isSingleton()) {
            return this.children.get(0).getItemType();
        }
        return XmlNodeType.SEQUENCE.value();
    }

    @Override
    public String getElementName() {
        if (this.isSingleton()) {
            return this.children.get(0).getElementName();
        }
        return RuntimeConstants.STRING_EMPTY_VALUE.getValue();
    }

    @Override
    public String getTextValue() {
        StringBuilder seqTextBuilder = new StringBuilder();
        for (BXml x : this.children) {
            if (x.getNodeType() != XmlNodeType.ELEMENT && x.getNodeType() != XmlNodeType.TEXT) continue;
            seqTextBuilder.append(x.getTextValue());
        }
        return seqTextBuilder.toString();
    }

    @Override
    public BString getAttribute(String localName, String namespace) {
        if (this.isSingleton()) {
            return this.children.get(0).getAttribute(localName, namespace);
        }
        return RuntimeConstants.BSTRING_NULL_VALUE;
    }

    @Override
    public BString getAttribute(String localName, String namespace, String prefix) {
        if (this.isSingleton()) {
            return this.children.get(0).getAttribute(localName, namespace, prefix);
        }
        return RuntimeConstants.BSTRING_NULL_VALUE;
    }

    @Override
    public void setAttribute(String localName, String namespace, String prefix, String value) {
        if (this.isFrozen()) {
            ReadOnlyUtils.handleInvalidUpdate("lang.xml");
        }
        if (this.isSingleton()) {
            this.children.get(0).setAttribute(localName, namespace, prefix, value);
        }
    }

    @Override
    public MapValue<BString, BString> getAttributesMap() {
        if (this.isSingleton()) {
            return (MapValue)this.children.get(0).getAttributesMap();
        }
        return null;
    }

    @Override
    @Deprecated
    public void setAttributes(BMap<BString, BString> attributes) {
        if (this.isFrozen()) {
            ReadOnlyUtils.handleInvalidUpdate("lang.xml");
        }
        if (this.isSingleton()) {
            this.children.get(0).setAttributes(attributes);
        }
    }

    @Override
    public XmlValue elements() {
        ArrayList<BXml> elementsSeq = new ArrayList<BXml>();
        for (BXml child : this.children) {
            if (child.getNodeType() != XmlNodeType.ELEMENT) continue;
            elementsSeq.add(child);
        }
        return new XmlSequence(elementsSeq);
    }

    @Override
    public XmlValue elements(String qname) {
        ArrayList<BXml> elementsSeq = new ArrayList<BXml>();
        String qnameStr = this.getQname(qname).toString();
        for (BXml child : this.children) {
            if (child.getNodeType() != XmlNodeType.ELEMENT || !child.getElementName().equals(qnameStr)) continue;
            elementsSeq.add(child);
        }
        return new XmlSequence(elementsSeq);
    }

    @Override
    public XmlValue children() {
        if (this.children.size() == 1) {
            return (XmlValue)this.children.get(0).children();
        }
        return new XmlSequence(new ArrayList<BXml>(this.children));
    }

    @Override
    public XmlValue children(String qname) {
        ArrayList<BXml> selected = new ArrayList<BXml>();
        if (this.children.size() == 1) {
            BXml bxml = this.children.get(0);
            return (XmlValue)bxml.children(qname);
        }
        for (BXml elem : this.children) {
            XmlSequence elements = (XmlSequence)elem.children().elements(qname);
            List<BXml> childrenList = elements.getChildrenList();
            if (childrenList.size() == 1) {
                selected.add(childrenList.get(0));
                continue;
            }
            if (childrenList.size() <= 1) continue;
            selected.addAll(childrenList);
        }
        if (selected.size() == 1) {
            return (XmlValue)selected.get(0);
        }
        return new XmlSequence(selected);
    }

    @Override
    public void setChildren(BXml seq) {
        if (this.isFrozen()) {
            ReadOnlyUtils.handleInvalidUpdate("lang.xml");
        }
        if (this.children.size() != 1) {
            throw ErrorCreator.createError(StringUtils.fromString("not an " + String.valueOf((Object)XmlNodeType.ELEMENT)));
        }
        this.children.get(0).setChildren(seq);
    }

    @Override
    @Deprecated
    public void addChildren(BXml xmlItem) {
        this.children.add(xmlItem);
        boolean isSameType = true;
        Type tempExprType = this.children.get(0).getType();
        for (int i = 1; i < this.children.size(); ++i) {
            if (tempExprType == this.children.get(i).getType()) continue;
            isSameType = false;
            break;
        }
        if (isSameType) {
            this.type = this.getSequenceType(tempExprType);
            return;
        }
        this.type = PredefinedTypes.TYPE_XML;
    }

    @Override
    public XmlValue strip() {
        ArrayList<BXml> elementsSeq = new ArrayList<BXml>();
        boolean prevChildWasATextNode = false;
        Object prevConsecutiveText = null;
        for (BXml x : this.children) {
            XmlValue item = (XmlValue)x;
            if (item.getNodeType() == XmlNodeType.TEXT) {
                prevConsecutiveText = prevChildWasATextNode ? (String)prevConsecutiveText + x.getTextValue() : x.getTextValue();
                prevChildWasATextNode = true;
                continue;
            }
            if (item.getNodeType() != XmlNodeType.ELEMENT) continue;
            if (prevChildWasATextNode && !((String)prevConsecutiveText).trim().isEmpty()) {
                elementsSeq.add(new XmlText((String)prevConsecutiveText));
                prevConsecutiveText = null;
            }
            prevChildWasATextNode = false;
            elementsSeq.add(x);
        }
        if (prevChildWasATextNode && !((String)prevConsecutiveText).trim().isEmpty()) {
            elementsSeq.add(new XmlText((String)prevConsecutiveText));
        }
        return new XmlSequence(elementsSeq);
    }

    public int hashCode() {
        return Objects.hash(this.children);
    }

    @Override
    public XmlValue slice(long startIndex, long endIndex) {
        if (startIndex > (long)this.children.size() || endIndex > (long)this.children.size() || startIndex < -1L || endIndex < -1L) {
            throw ErrorCreator.createError(StringUtils.fromString("index out of range: [" + startIndex + "," + endIndex + "]"));
        }
        if (startIndex == -1L) {
            startIndex = 0L;
        }
        if (endIndex == -1L) {
            endIndex = this.children.size();
        }
        if (startIndex == endIndex) {
            return new XmlSequence();
        }
        if (startIndex > endIndex) {
            throw ErrorCreator.createError(StringUtils.fromString("invalid indices: " + startIndex + " < " + endIndex));
        }
        int j = 0;
        ArrayList<BXml> elementsSeq = new ArrayList<BXml>();
        int i = (int)startIndex;
        while ((long)i < endIndex) {
            elementsSeq.add(j++, this.children.get(i));
            ++i;
        }
        return new XmlSequence(elementsSeq);
    }

    @Override
    public XmlValue descendants(List<String> qnames) {
        ArrayList<BXml> descendants = new ArrayList<BXml>();
        for (BXml child : this.children) {
            if (child.getNodeType() != XmlNodeType.ELEMENT) continue;
            XmlItem element = (XmlItem)child;
            String name = element.getQName().toString();
            if (qnames.contains(name)) {
                descendants.add(element);
            }
            this.addDescendants(descendants, element, qnames);
        }
        return new XmlSequence(descendants);
    }

    @Override
    public XmlValue descendants() {
        ArrayList<BXml> descendants = new ArrayList<BXml>();
        if (this.children.size() == 1) {
            XmlItem element = (XmlItem)this.children.get(0);
            this.addDescendants(descendants, element);
        }
        return new XmlSequence(descendants);
    }

    @Override
    public Object value() {
        BArrayType bArrayType = new BArrayType(PredefinedTypes.TYPE_XML);
        return new ArrayValueImpl(this.children.toArray(), bArrayType);
    }

    public String toString() {
        try {
            return this.stringValue(null);
        }
        catch (Throwable t) {
            XmlSequence.handleXmlException("failed to get xml as string: ", t);
            return RuntimeConstants.STRING_NULL_VALUE;
        }
    }

    @Override
    public String stringValue(BLink parent) {
        try {
            StringBuilder sb = new StringBuilder();
            for (BXml child : this.children) {
                sb.append(child.stringValue(new CycleUtils.Node(this, parent)));
            }
            return sb.toString();
        }
        catch (Throwable t) {
            XmlSequence.handleXmlException("failed to get xml as string: ", t);
            return RuntimeConstants.STRING_NULL_VALUE;
        }
    }

    @Override
    public String informalStringValue(BLink parent) {
        return "`" + this.stringValue(parent) + "`";
    }

    @Override
    public String expressionStringValue(BLink parent) {
        return "xml`" + this.toString() + "`";
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        if (this.isFrozen()) {
            return this;
        }
        if (refs.containsKey(this)) {
            return refs.get(this);
        }
        ArrayList<BXml> copiedChildrenList = new ArrayList<BXml>(this.children.size());
        XmlSequence copiedSeq = new XmlSequence(copiedChildrenList);
        refs.put(this, copiedSeq);
        for (BXml child : this.children) {
            copiedChildrenList.add((XmlValue)child.copy(refs));
        }
        return copiedSeq;
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        XmlSequence copy = (XmlSequence)this.copy(refs);
        if (!copy.isFrozen()) {
            copy.freezeDirect();
        }
        return copy;
    }

    @Override
    public XmlValue getItem(int index) {
        try {
            if (index >= this.children.size()) {
                return new XmlSequence();
            }
            return (XmlValue)this.children.get(index);
        }
        catch (Exception e) {
            throw ErrorHelper.getRuntimeException(ErrorCodes.XML_SEQUENCE_INDEX_OUT_OF_RANGE, this.children.size(), index);
        }
    }

    @Override
    public int size() {
        return this.children.size();
    }

    @Override
    public void build() {
        for (BXml child : this.children) {
            child.build();
        }
    }

    @Override
    protected void setAttributesOnInitialization(BMap<BString, BString> attributes) {
        if (this.isSingleton()) {
            ((XmlValue)this.children.get(0)).setAttributesOnInitialization(attributes);
        }
    }

    @Override
    protected void setAttributeOnInitialization(String localName, String namespace, String prefix, String value) {
        ((XmlValue)this.children.get(0)).setAttributeOnInitialization(localName, namespace, prefix, value);
    }

    @Override
    public void removeAttribute(String qname) {
        if (this.isFrozen()) {
            ReadOnlyUtils.handleInvalidUpdate("lang.xml");
        }
        if (this.children.size() != 1) {
            throw ErrorCreator.createError(StringUtils.fromString("not an " + String.valueOf((Object)XmlNodeType.ELEMENT)));
        }
        this.children.get(0).removeAttribute(qname);
    }

    @Override
    @Deprecated
    public void removeChildren(String qname) {
        if (this.isFrozen()) {
            ReadOnlyUtils.handleInvalidUpdate("lang.xml");
        }
        if (this.children.size() != 1) {
            throw ErrorCreator.createError(StringUtils.fromString("not an " + String.valueOf((Object)XmlNodeType.ELEMENT)));
        }
        this.children.get(0).removeChildren(qname);
    }

    @Override
    public void freezeDirect() {
        this.type = ReadOnlyUtils.setImmutableTypeAndGetEffectiveType(this.type);
        for (BXml elem : this.children) {
            elem.freezeDirect();
        }
        this.typedesc = null;
    }

    @Override
    public boolean isFrozen() {
        if (this.type.isReadOnly()) {
            return true;
        }
        for (BXml child : this.children) {
            if (child.isFrozen()) continue;
            return false;
        }
        this.freezeDirect();
        return true;
    }

    @Override
    public IteratorValue<BXml> getIterator() {
        return new IteratorValue<BXml>(){
            final Iterator<BXml> iterator;
            {
                this.iterator = XmlSequence.this.children.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public BXml next() {
                return this.iterator.next();
            }
        };
    }

    private void setSequenceMembersConcatenatingAdjacentTextItems(List<BXml> values) {
        ArrayList<BXml> members = new ArrayList<BXml>();
        boolean isPreviousValueText = false;
        StringBuilder text = new StringBuilder();
        for (BXml value : values) {
            if (value.getNodeType() == XmlNodeType.TEXT) {
                isPreviousValueText = true;
                text.append(value.getTextValue());
                continue;
            }
            if (isPreviousValueText) {
                members.add(XmlFactory.createXMLText(StringUtils.fromString(text.toString())));
                isPreviousValueText = false;
                text.setLength(0);
            }
            members.add(value);
        }
        if (!text.isEmpty()) {
            members.add(XmlFactory.createXMLText(StringUtils.fromString(text.toString())));
        }
        this.children = members;
    }

    private Type getSequenceType(Type tempExprType) {
        return switch (tempExprType.getTag()) {
            case 18 -> PredefinedTypes.TYPE_XML_ELEMENT_SEQUENCE;
            case 20 -> PredefinedTypes.TYPE_XML_COMMENT_SEQUENCE;
            case 19 -> PredefinedTypes.TYPE_XML_PI_SEQUENCE;
            default -> PredefinedTypes.TYPE_XML_TEXT_SEQUENCE;
        };
    }

    private void initializeIteratorNextReturnType() {
        Type childrenType;
        if (this.children.size() == 1) {
            childrenType = this.children.get(0).getType();
        } else {
            HashSet<Type> types = new HashSet<Type>();
            for (BXml child : this.children) {
                types.add(child.getType());
            }
            childrenType = new BUnionType(new ArrayList<Type>(types));
        }
        this.iteratorNextReturnType = IteratorUtils.createIteratorNextReturnType(childrenType);
    }

    @Override
    public Type getIteratorNextReturnType() {
        if (this.iteratorNextReturnType == null) {
            this.initializeIteratorNextReturnType();
        }
        return this.iteratorNextReturnType;
    }

    @Override
    public boolean equals(Object o, Set<ValuePair> visitedValues) {
        if (o instanceof XmlSequence) {
            XmlSequence rhsXMLSequence = (XmlSequence)o;
            return XmlSequence.isXMLSequenceChildrenEqual(this.getChildrenList(), rhsXMLSequence.getChildrenList());
        }
        if (this.isSingleton() && o instanceof XmlValue) {
            return TypeChecker.isEqual(this.getChildrenList().get(0), o);
        }
        return this.getChildrenList().isEmpty() && TypeUtils.getType(o) == PredefinedTypes.TYPE_XML_NEVER;
    }

    private static boolean isXMLSequenceChildrenEqual(List<BXml> lhsList, List<BXml> rhsList) {
        if (lhsList.size() != rhsList.size()) {
            return false;
        }
        for (int i = 0; i < lhsList.size(); ++i) {
            if (TypeChecker.isEqual(lhsList.get(i), rhsList.get(i))) continue;
            return false;
        }
        return true;
    }
}

