/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.observability.metrics;

import java.util.Objects;

public final class Tag
implements Comparable<Tag> {
    private final String key;
    private final String value;
    private final int hashCode;

    public Tag(String key, String value) {
        this.key = Objects.requireNonNull(key);
        this.value = Objects.requireNonNull(value);
        this.hashCode = Objects.hash(key, value);
    }

    public static Tag of(String key, String value) {
        return new Tag(key, value);
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public int compareTo(Tag o) {
        return this.key.compareTo(o.key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tag tag = (Tag)o;
        return Objects.equals(this.key, tag.key) && Objects.equals(this.value, tag.value);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "Tag{key='" + this.key + "', value='" + this.value + "'}";
    }
}

