/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.profiler.ui;

import io.ballerina.runtime.profiler.runtime.ProfilerRuntimeException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public final class FileUtils {
    private static final int MAX_WAIT_TIME_FOR_FILE = 600;

    private FileUtils() {
    }

    static String readFileAsString(String file) throws IOException {
        Path path = Path.of(file, new String[0]);
        int count = 0;
        while (!Files.exists(path, new LinkOption[0])) {
            if (count++ > 600) {
                throw new ProfilerRuntimeException("File not found: " + file);
            }
            FileUtils.waitForFile();
        }
        return Files.readString(path);
    }

    private static void waitForFile() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

