/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.profiler.ui;

import io.ballerina.runtime.profiler.ui.FileUtils;
import io.ballerina.runtime.profiler.ui.FrontEnd;
import io.ballerina.runtime.profiler.util.Constants;
import io.ballerina.runtime.profiler.util.ProfilerException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;

public class HttpServer {
    public void initializeHTMLExport() throws IOException {
        String profilerOutputDir = System.getProperty("user.dir");
        Constants.OUT_STREAM.printf("      Output: \u001b[1;38;2;255;255;0m%s" + File.separator + "ProfilerReport.html\u001b[0m%n", profilerOutputDir);
        Path resourcePath = Path.of(System.getenv("ballerina.home"), new String[0]).resolve("resources").resolve("profiler");
        try {
            HttpServer.copyFolder(resourcePath, Path.of(profilerOutputDir, new String[0]));
        }
        catch (IOException e) {
            throw new ProfilerException("Error occurred while copying the resources", e);
        }
        String content = FileUtils.readFileAsString("performance_report.json");
        FrontEnd frontEnd = new FrontEnd();
        String htmlData = frontEnd.getSiteData(content);
        try (FileWriter writer = new FileWriter("ProfilerReport.html", StandardCharsets.UTF_8);){
            writer.write(htmlData);
        }
        catch (IOException e) {
            Constants.OUT_STREAM.printf("%s%n", e);
        }
    }

    private static void copyFolder(final Path source, final Path target) throws IOException {
        EnumSet<FileVisitOption> options = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        Files.walkFileTree(source, options, Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path targetDir = target.resolve(source.relativize(dir));
                Files.createDirectories(targetDir, new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.toString().endsWith(".html")) {
                    return FileVisitResult.CONTINUE;
                }
                Path targetFile = target.resolve(source.relativize(file));
                Files.copy(file, targetFile, StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

