/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.profiler.ui;

import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.internal.json.JsonInternalUtils;
import io.ballerina.runtime.internal.types.BArrayType;
import io.ballerina.runtime.internal.values.BmpStringValue;
import io.ballerina.runtime.profiler.ui.FileUtils;
import io.ballerina.runtime.profiler.util.Constants;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JsonParser {
    private static final String VALUE_KEY = "value";

    public void initializeCPUParser(String cpuFilePath) {
        try {
            String jsonInput = FileUtils.readFileAsString(cpuFilePath);
            List<StackTraceItem> input = this.populateStackTraceItems(jsonInput);
            Data output = new Data("Root", input.get((int)0).time, new ArrayList<Data>());
            for (StackTraceItem stackTraceItem : input) {
                this.analyseStackTraceItems(stackTraceItem, output);
            }
            this.writeToValueJson(output);
        }
        catch (Exception throwable) {
            Constants.OUT_STREAM.println(String.valueOf(throwable) + "%n");
        }
    }

    private int getTotalTime(Data node) {
        int totalTime = 0;
        List<Data> children = node.children;
        if (children != null) {
            for (int i = 0; i < children.size(); ++i) {
                if (children.get((int)i).value == -1) continue;
                totalTime += children.get((int)i).value;
            }
        }
        return totalTime;
    }

    private void writePerformanceJson(String parsedJson) {
        parsedJson = "var data = " + (String)parsedJson;
        try (FileWriter myWriter = new FileWriter("performance_report.json", StandardCharsets.UTF_8);){
            myWriter.write((String)parsedJson);
            myWriter.flush();
        }
        catch (IOException e) {
            Constants.OUT_STREAM.printf("An error occurred.%n", new Object[0]);
        }
    }

    private void analyseStackTraceItems(StackTraceItem stackTraceItem, Data output) {
        Data current = output;
        for (int i = 1; i < stackTraceItem.stackTrace.size(); ++i) {
            current = this.populateChildNodes(stackTraceItem, current, stackTraceItem.stackTrace.get(i));
        }
    }

    private void writeToValueJson(Data output) {
        int totalTime;
        output.value = totalTime = this.getTotalTime(output);
        this.writePerformanceJson(output.toString());
    }

    private Data populateChildNodes(StackTraceItem stackTraceItem, Data current, String stackTrace) {
        for (Data child : current.children) {
            if (!child.name.equals(stackTrace)) continue;
            child.value = Math.max(child.value, stackTraceItem.time);
            return child;
        }
        Data newChild = new Data(stackTrace, stackTraceItem.time, new ArrayList<Data>());
        current.children.add(newChild);
        return newChild;
    }

    private List<StackTraceItem> populateStackTraceItems(String jsonInput) {
        Object jsonObj = io.ballerina.runtime.internal.json.JsonParser.parse(jsonInput, (Type)PredefinedTypes.TYPE_JSON);
        BArray arr = (BArray)jsonObj;
        ArrayList<StackTraceItem> stackTraceItems = new ArrayList<StackTraceItem>();
        int i = 0;
        while ((long)i < arr.getLength()) {
            Map arrItem = (Map)arr.get(i);
            stackTraceItems.add(new StackTraceItem(Integer.parseInt(arrItem.get(new BmpStringValue("time")).toString()), List.of(JsonInternalUtils.convertJSONToBArray(arrItem.get(new BmpStringValue("stackTrace")), new BArrayType(PredefinedTypes.TYPE_STRING)).getStringArray())));
            ++i;
        }
        return stackTraceItems;
    }

    private static class Data {
        String name;
        int value;
        List<Data> children;

        Data(String name, int value, List<Data> children) {
            this.name = name;
            this.value = value;
            this.children = children;
        }

        public String toString() {
            StringBuilder text = new StringBuilder();
            text.append("{").append("\"name\":\"").append(this.name).append("\",\"value\":").append(this.value).append(",\"children\":[");
            for (Data child : this.children) {
                text.append(child.toString()).append(",");
            }
            if (!this.children.isEmpty()) {
                text.deleteCharAt(text.length() - 1);
            }
            text.append("]}");
            return text.toString();
        }
    }

    private static class StackTraceItem {
        int time;
        List<String> stackTrace;

        public StackTraceItem(int time, List<String> stackTrace) {
            this.time = time;
            this.stackTrace = new ArrayList<String>(stackTrace);
        }
    }
}

