/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.internal;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.XmlNodeType;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.runtime.api.values.BXmlQName;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import org.ballerinalang.langlib.internal.IsElement;

public final class GetAttribute {
    private GetAttribute() {
    }

    public static Object getAttribute(BXml xmlVal, BString attrName, boolean optionalFiledAccess) {
        if (xmlVal.getNodeType() == XmlNodeType.SEQUENCE && xmlVal.isEmpty()) {
            if (!optionalFiledAccess) {
                return ErrorCreator.createError((BString)ErrorReasons.XML_OPERATION_ERROR, (BMap)ErrorHelper.getErrorDetails((ErrorCodes)ErrorCodes.EMPTY_XML_SEQUENCE_HAS_NO_ATTRIBUTES, (Object[])new Object[0]));
            }
            return null;
        }
        if (!IsElement.isElement(xmlVal)) {
            return ErrorCreator.createError((BString)ErrorReasons.XML_OPERATION_ERROR, (BMap)ErrorHelper.getErrorDetails((ErrorCodes)ErrorCodes.INVALID_XML_ATTRIBUTE_ERROR, (Object[])new Object[]{xmlVal.getNodeType().value()}));
        }
        BXmlQName qname = ValueCreator.createXmlQName((BString)attrName);
        BString attrVal = xmlVal.getAttribute(qname.getLocalName(), qname.getUri());
        if (attrVal == null && !optionalFiledAccess) {
            return ErrorCreator.createError((BString)ErrorReasons.XML_OPERATION_ERROR, (BMap)ErrorHelper.getErrorDetails((ErrorCodes)ErrorCodes.ATTRIBUTE_NOT_FOUND_ERROR, (Object[])new Object[]{attrName}));
        }
        return attrVal;
    }
}

