/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker;

import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.SemanticVersion;
import io.ballerina.projects.Settings;
import io.ballerina.projects.environment.Environment;
import io.ballerina.projects.environment.EnvironmentBuilder;
import io.ballerina.projects.environment.PackageResolver;
import io.ballerina.projects.environment.ResolutionOptions;
import io.ballerina.projects.environment.ResolutionRequest;
import io.ballerina.projects.environment.ResolutionResponse;
import io.ballerina.projects.internal.model.Proxy;
import io.ballerina.projects.util.ProjectUtils;
import io.ballerina.semver.checker.exception.SemverToolException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.ballerinalang.central.client.CentralAPIClient;
import org.ballerinalang.central.client.exceptions.CentralClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.ballerinalang.util.RepoUtils;

class BallerinaPackageResolver {
    private final PrintStream outStream;
    private final PrintStream errStream;
    private CentralAPIClient centralClient;
    private static final Logger LOGGER = LoggerFactory.getLogger(BallerinaPackageResolver.class);

    BallerinaPackageResolver(PrintStream outStream, PrintStream errStream) {
        this.outStream = outStream;
        this.errStream = errStream;
        this.initializeCentralClient();
    }

    SemanticVersion resolveClosestCompatibleCentralVersion(String orgName, String pkgName, SemanticVersion localVersion) throws SemverToolException {
        try {
            ArrayList publishedVersions = new ArrayList();
            String supportedPlatform = Arrays.stream(JvmTarget.values()).map(target -> target.code()).collect(Collectors.joining(","));
            publishedVersions.addAll(this.centralClient.getPackageVersions(orgName, pkgName, supportedPlatform, RepoUtils.getBallerinaVersion()));
            if (publishedVersions.isEmpty()) {
                throw new SemverToolException(String.format("couldn't find any published packages in Ballerina central under the org '%s' with name '%s'", orgName, pkgName));
            }
            List<SemanticVersion> availableVersions = publishedVersions.stream().map(SemanticVersion::from).toList();
            Optional<SemanticVersion> compatibleVersion = this.selectCompatibleVersion(availableVersions, localVersion);
            if (compatibleVersion.isEmpty()) {
                SemanticVersion highestVersion = this.getHighestVersion(availableVersions);
                LOGGER.warn(String.format("current package version is lower than all the available versions in the central. local changes will be compared against the latest release version ('%s').", highestVersion));
                return highestVersion;
            }
            LOGGER.debug("local changes will be compared against the release version: " + String.valueOf(compatibleVersion.get()));
            return compatibleVersion.get();
        }
        catch (CentralClientException e) {
            throw new SemverToolException(e);
        }
    }

    Path resolvePackage(String orgName, String pkgName, SemanticVersion version) throws SemverToolException {
        Path localRepoPath = ProjectUtils.createAndGetHomeReposPath();
        Path centralCachePath = localRepoPath.resolve("repositories").resolve("central.ballerina.io");
        Path packagePathInLocalRepo = localRepoPath.resolve(orgName).resolve(pkgName).resolve(version.toString());
        if (Files.exists(packagePathInLocalRepo, new LinkOption[0]) && Files.isDirectory(packagePathInLocalRepo, new LinkOption[0])) {
            LOGGER.debug("target version: " + String.valueOf(version) + "is already available in local repository");
            return ProjectUtils.getPackagePath((Path)localRepoPath, (String)orgName, (String)pkgName, (String)version.toString());
        }
        Path packagePathInCentralCache = centralCachePath.resolve(orgName).resolve(pkgName).resolve(version.toString());
        if (Files.exists(packagePathInCentralCache, new LinkOption[0]) && Files.isDirectory(packagePathInCentralCache, new LinkOption[0])) {
            LOGGER.debug("target version: " + String.valueOf(version) + "is already available in central repository cache");
            return ProjectUtils.getPackagePath((Path)centralCachePath, (String)orgName, (String)pkgName, (String)version.toString());
        }
        this.outStream.printf("resolving package '%s/%s:%s'...%n", orgName, pkgName, version);
        return this.resolveBalaPath(orgName, pkgName, version.toString());
    }

    private Optional<SemanticVersion> selectCompatibleVersion(List<SemanticVersion> versionList, SemanticVersion pkgVersion) {
        AtomicReference<SemanticVersion> latestCompatibleVersion = new AtomicReference<SemanticVersion>(SemanticVersion.from((String)"0.0.0"));
        versionList.forEach(version -> {
            if (version.lessThanOrEqualTo(pkgVersion) && version.greaterThan((SemanticVersion)latestCompatibleVersion.get())) {
                latestCompatibleVersion.set((SemanticVersion)version);
            }
        });
        if (latestCompatibleVersion.get().equals((Object)SemanticVersion.from((String)"0.0.0"))) {
            return Optional.empty();
        }
        return Optional.ofNullable(latestCompatibleVersion.get());
    }

    private void initializeCentralClient() {
        Settings settings = RepoUtils.readSettings();
        this.centralClient = new CentralAPIClient(RepoUtils.getRemoteRepoURL(), ProjectUtils.initializeProxy((Proxy)settings.getProxy()), settings.getProxy().username(), settings.getProxy().password(), ProjectUtils.getAccessTokenOfCLI((Settings)settings), settings.getCentral().getConnectTimeout(), settings.getCentral().getReadTimeout(), settings.getCentral().getWriteTimeout(), settings.getCentral().getCallTimeout(), settings.getCentral().getMaxRetries());
    }

    private Path resolveBalaPath(String org, String pkgName, String version) throws SemverToolException {
        Package resolvedPackage;
        String repository = this.hasCustomHomeRepoPath() ? "local" : null;
        PackageDescriptor packageDescriptor = PackageDescriptor.from((PackageOrg)PackageOrg.from((String)org), (PackageName)PackageName.from((String)pkgName), (PackageVersion)PackageVersion.from((String)version), (String)repository);
        ResolutionRequest resolutionRequest = ResolutionRequest.from((PackageDescriptor)packageDescriptor);
        System.setProperty("enableOutputStream", Boolean.TRUE.toString());
        PackageResolver packageResolver = (PackageResolver)this.getEnvironment().getService(PackageResolver.class);
        Collection resolutionResponses = packageResolver.resolvePackages(Collections.singletonList(resolutionRequest), ResolutionOptions.builder().setOffline(false).build());
        ResolutionResponse resolutionResponse = resolutionResponses.stream().findFirst().orElse(null);
        if (resolutionResponse != null && resolutionResponse.resolutionStatus().equals((Object)ResolutionResponse.ResolutionStatus.RESOLVED) && (resolvedPackage = resolutionResponse.resolvedPackage()) != null) {
            return resolvedPackage.project().sourceRoot();
        }
        throw new SemverToolException("failed to resolve package '" + String.valueOf(packageDescriptor) + "' from central");
    }

    private SemanticVersion getHighestVersion(List<SemanticVersion> availableVersions) {
        AtomicReference<SemanticVersion> highestVersion = new AtomicReference<SemanticVersion>(SemanticVersion.from((String)"0.0.0"));
        availableVersions.forEach(version -> {
            if (version.greaterThan((SemanticVersion)highestVersion.get())) {
                highestVersion.set((SemanticVersion)version);
            }
        });
        return highestVersion.get();
    }

    private Environment getEnvironment() {
        if (this.hasCustomHomeRepoPath()) {
            return EnvironmentBuilder.getBuilder().setUserHome(ProjectUtils.createAndGetHomeReposPath()).build();
        }
        return EnvironmentBuilder.buildDefault();
    }

    private boolean hasCustomHomeRepoPath() {
        return System.getenv("BALLERINA_HOME_DIR") != null;
    }
}

