/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker.comparator;

import io.ballerina.compiler.syntax.tree.EnumDeclarationNode;
import io.ballerina.compiler.syntax.tree.EnumMemberNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.semver.checker.comparator.DocumentationComparator;
import io.ballerina.semver.checker.comparator.DumbNodeListComparator;
import io.ballerina.semver.checker.comparator.EnumMemberComparator;
import io.ballerina.semver.checker.comparator.NodeComparator;
import io.ballerina.semver.checker.diff.Diff;
import io.ballerina.semver.checker.diff.DiffExtractor;
import io.ballerina.semver.checker.diff.DiffKind;
import io.ballerina.semver.checker.diff.EnumDiff;
import io.ballerina.semver.checker.diff.NodeDiffImpl;
import io.ballerina.semver.checker.diff.SemverImpact;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class EnumComparator
extends NodeComparator<EnumDeclarationNode> {
    public EnumComparator(EnumDeclarationNode newNode, EnumDeclarationNode oldNode) {
        super(newNode, oldNode);
    }

    @Override
    public Optional<? extends Diff> computeDiff() {
        EnumDiff.Builder enumDiffBuilder = new EnumDiff.Builder((EnumDeclarationNode)this.newNode, (EnumDeclarationNode)this.oldNode);
        return enumDiffBuilder.withChildDiffs(this.compareMetadata()).withChildDiffs(this.compareQualifiers()).withChildDiffs(this.compareEnumMembers()).build();
    }

    public List<Diff> compareMetadata() {
        LinkedList<Diff> metadataDiffs = new LinkedList<Diff>();
        Optional newMeta = ((EnumDeclarationNode)this.newNode).metadata();
        Optional oldMeta = ((EnumDeclarationNode)this.oldNode).metadata();
        Node newDocs = newMeta.flatMap(MetadataNode::documentationString).orElse(null);
        Node oldDocs = oldMeta.flatMap(MetadataNode::documentationString).orElse(null);
        DocumentationComparator documentationComparator = new DocumentationComparator(newDocs, oldDocs);
        documentationComparator.computeDiff().ifPresent(metadataDiffs::add);
        NodeList newAnnots = newMeta.map(MetadataNode::annotations).orElse(null);
        NodeList oldAnnots = oldMeta.map(MetadataNode::annotations).orElse(null);
        DumbNodeListComparator annotsComparator = new DumbNodeListComparator(newAnnots, oldAnnots, DiffKind.ENUM_ANNOTATION);
        annotsComparator.computeDiff().ifPresent(metadataDiffs::add);
        return metadataDiffs;
    }

    private List<Diff> compareQualifiers() {
        ArrayList<Diff> qualifierDiffs = new ArrayList<Diff>();
        Optional newPublicQual = ((EnumDeclarationNode)this.newNode).qualifier();
        Optional oldPublicQual = ((EnumDeclarationNode)this.oldNode).qualifier();
        if (newPublicQual.isPresent() && oldPublicQual.isEmpty()) {
            NodeDiffImpl.Builder<Object> qualifierDiffBuilder = new NodeDiffImpl.Builder<Object>(((Node)newPublicQual.get()), null);
            qualifierDiffBuilder.withVersionImpact(SemverImpact.MINOR).withMessage("'public' qualifier is added to enum '" + this.getEnumIdentifier() + "'").build().ifPresent(qualifierDiffs::add);
        } else if (newPublicQual.isEmpty() && oldPublicQual.isPresent()) {
            NodeDiffImpl.Builder<Node> qualifierDiffBuilder = new NodeDiffImpl.Builder<Node>(null, (Node)oldPublicQual.get());
            qualifierDiffBuilder.withVersionImpact(SemverImpact.MAJOR).withMessage("'public' qualifier is removed from enum '" + this.getEnumIdentifier() + "'").build().ifPresent(qualifierDiffs::add);
        }
        return qualifierDiffs;
    }

    private List<Diff> compareEnumMembers() {
        LinkedList<Diff> memberDiffs = new LinkedList<Diff>();
        Map newMembers = ((EnumDeclarationNode)this.newNode).enumMemberList().stream().map(node -> (EnumMemberNode)node).collect(Collectors.toMap(enumMemberNode -> enumMemberNode.identifier().text().trim(), Function.identity()));
        Map oldMembers = ((EnumDeclarationNode)this.oldNode).enumMemberList().stream().map(node -> (EnumMemberNode)node).collect(Collectors.toMap(enumMemberNode -> enumMemberNode.identifier().text().trim(), Function.identity()));
        DiffExtractor memberDiffExtractor = new DiffExtractor(newMembers, oldMembers);
        memberDiffExtractor.getAdditions().forEach((name, node) -> new NodeDiffImpl.Builder<Object>(node, null).withKind(DiffKind.ENUM_MEMBER).withVersionImpact(SemverImpact.MINOR).withMessage("new enum member '" + name + "' is added").build().ifPresent(memberDiffs::add));
        memberDiffExtractor.getRemovals().forEach((name, node) -> new NodeDiffImpl.Builder<EnumMemberNode>((EnumMemberNode)null, (EnumMemberNode)node).withKind(DiffKind.ENUM_MEMBER).withVersionImpact(SemverImpact.MAJOR).withMessage("enum member '" + name + "' is removed").build().ifPresent(memberDiffs::add));
        memberDiffExtractor.getCommons().forEach((name, members) -> {
            EnumMemberComparator paramComparator = new EnumMemberComparator((EnumMemberNode)members.getKey(), (EnumMemberNode)members.getValue());
            paramComparator.computeDiff().ifPresent(memberDiffs::add);
        });
        return memberDiffs;
    }

    private String getEnumIdentifier() {
        return this.newNode != null ? ((EnumDeclarationNode)this.newNode).identifier().text().trim() : ((EnumDeclarationNode)this.oldNode).identifier().text().trim();
    }
}

