/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker.comparator;

import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.semver.checker.comparator.DocumentationComparator;
import io.ballerina.semver.checker.comparator.DumbNodeListComparator;
import io.ballerina.semver.checker.comparator.NodeComparator;
import io.ballerina.semver.checker.comparator.ParamListComparator;
import io.ballerina.semver.checker.diff.Diff;
import io.ballerina.semver.checker.diff.FunctionDiff;
import io.ballerina.semver.checker.diff.NodeDiff;
import io.ballerina.semver.checker.diff.NodeDiffImpl;
import io.ballerina.semver.checker.diff.NodeListDiff;
import io.ballerina.semver.checker.diff.SemverImpact;
import io.ballerina.semver.checker.util.SyntaxTreeUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class FunctionComparator
extends NodeComparator<FunctionDefinitionNode> {
    public FunctionComparator(FunctionDefinitionNode newNode, FunctionDefinitionNode oldNode) {
        super(newNode, oldNode);
    }

    @Override
    public Optional<? extends Diff> computeDiff() {
        FunctionDiff.Builder funcDiffBuilder = new FunctionDiff.Builder((FunctionDefinitionNode)this.newNode, (FunctionDefinitionNode)this.oldNode);
        return funcDiffBuilder.withChildDiffs(this.compareMetadata()).withChildDiffs(this.compareFunctionQualifiers()).withChildDiffs(this.compareFunctionParams()).withChildDiffs(this.compareReturnTypeDesc()).withChildDiffs(this.compareFunctionBody()).build();
    }

    public List<Diff> compareMetadata() {
        ArrayList<Diff> metadataDiffs = new ArrayList<Diff>();
        Optional newMeta = ((FunctionDefinitionNode)this.newNode).metadata();
        Optional oldMeta = ((FunctionDefinitionNode)this.oldNode).metadata();
        Node newDocs = newMeta.flatMap(MetadataNode::documentationString).orElse(null);
        Node oldDocs = oldMeta.flatMap(MetadataNode::documentationString).orElse(null);
        DocumentationComparator documentationComparator = new DocumentationComparator(newDocs, oldDocs);
        documentationComparator.computeDiff().ifPresent(metadataDiffs::add);
        NodeList newAnnots = newMeta.map(MetadataNode::annotations).orElse(null);
        NodeList oldAnnots = oldMeta.map(MetadataNode::annotations).orElse(null);
        return metadataDiffs;
    }

    private List<Diff> compareFunctionQualifiers() {
        ArrayList<Diff> qualifierDiffs = new ArrayList<Diff>();
        NodeList newQualifiers = ((FunctionDefinitionNode)this.newNode).qualifierList();
        NodeList oldQualifiers = ((FunctionDefinitionNode)this.oldNode).qualifierList();
        Optional<Token> newPublicQual = SyntaxTreeUtils.lookupQualifier((NodeList<Token>)newQualifiers, SyntaxKind.PUBLIC_KEYWORD);
        Optional<Token> oldPublicQual = SyntaxTreeUtils.lookupQualifier((NodeList<Token>)oldQualifiers, SyntaxKind.PUBLIC_KEYWORD);
        if (newPublicQual.isPresent() && oldPublicQual.isEmpty()) {
            qualifierDiffBuilder = new NodeDiffImpl.Builder<Object>(((Node)newPublicQual.get()), null);
            qualifierDiffBuilder.withVersionImpact(SemverImpact.MINOR).withMessage("'public' qualifier is added").build().ifPresent(qualifierDiffs::add);
        } else if (newPublicQual.isEmpty() && oldPublicQual.isPresent()) {
            qualifierDiffBuilder = new NodeDiffImpl.Builder<Node>(null, (Node)oldPublicQual.get());
            qualifierDiffBuilder.withVersionImpact(SemverImpact.MAJOR).withMessage("'public' qualifier is removed").build().ifPresent(qualifierDiffs::add);
        }
        Optional<Token> newIsolatedQual = SyntaxTreeUtils.lookupQualifier((NodeList<Token>)newQualifiers, SyntaxKind.ISOLATED_KEYWORD);
        Optional<Token> oldIsolatedQual = SyntaxTreeUtils.lookupQualifier((NodeList<Token>)oldQualifiers, SyntaxKind.ISOLATED_KEYWORD);
        if (newIsolatedQual.isPresent() && oldIsolatedQual.isEmpty()) {
            qualifierDiffBuilder = new NodeDiffImpl.Builder<Object>(((Node)newIsolatedQual.get()), null);
            qualifierDiffBuilder.withVersionImpact(SemverImpact.AMBIGUOUS).withMessage("'isolated' qualifier is added").build().ifPresent(qualifierDiffs::add);
        } else if (newIsolatedQual.isEmpty() && oldIsolatedQual.isPresent()) {
            qualifierDiffBuilder = new NodeDiffImpl.Builder<Node>(null, (Node)oldIsolatedQual.get());
            qualifierDiffBuilder.withVersionImpact(SemverImpact.AMBIGUOUS).withMessage("'isolated' qualifier is removed").build().ifPresent(qualifierDiffs::add);
        }
        Optional<Token> newTransactionalQual = SyntaxTreeUtils.lookupQualifier((NodeList<Token>)newQualifiers, SyntaxKind.TRANSACTIONAL_KEYWORD);
        Optional<Token> oldTransactionalQual = SyntaxTreeUtils.lookupQualifier((NodeList<Token>)oldQualifiers, SyntaxKind.TRANSACTIONAL_KEYWORD);
        if (newTransactionalQual.isPresent() && oldTransactionalQual.isEmpty()) {
            NodeDiffImpl.Builder<Object> qualifierDiffBuilder = new NodeDiffImpl.Builder<Object>(((Node)newTransactionalQual.get()), null);
            qualifierDiffBuilder.withVersionImpact(SemverImpact.AMBIGUOUS).withMessage("'transactional' qualifier is added").build().ifPresent(qualifierDiffs::add);
        } else if (newTransactionalQual.isEmpty() && oldTransactionalQual.isPresent()) {
            NodeDiffImpl.Builder<Node> qualifierDiffBuilder = new NodeDiffImpl.Builder<Node>(null, (Node)oldTransactionalQual.get());
            qualifierDiffBuilder.withVersionImpact(SemverImpact.AMBIGUOUS).withMessage("'transactional' qualifier is removed").build().ifPresent(qualifierDiffs::add);
        }
        return qualifierDiffs;
    }

    private List<Diff> compareFunctionParams() {
        ArrayList<Diff> paramDiffs = new ArrayList<Diff>();
        List<ParameterNode> newParams = ((FunctionDefinitionNode)this.newNode).functionSignature().parameters().stream().toList();
        List<ParameterNode> oldParams = ((FunctionDefinitionNode)this.oldNode).functionSignature().parameters().stream().toList();
        ParamListComparator paramComparator = new ParamListComparator(newParams, oldParams);
        paramComparator.computeDiff().ifPresent(diff -> paramDiffs.addAll(this.extractTerminalDiffs((Diff)diff, (List<Diff>)new LinkedList<Diff>())));
        return paramDiffs;
    }

    private List<Diff> compareReturnTypeDesc() {
        ArrayList<Diff> returnTypeDiffs = new ArrayList<Diff>();
        Optional newReturn = ((FunctionDefinitionNode)this.newNode).functionSignature().returnTypeDesc();
        Optional oldReturn = ((FunctionDefinitionNode)this.oldNode).functionSignature().returnTypeDesc();
        if (newReturn.isPresent() && oldReturn.isEmpty()) {
            NodeDiffImpl.Builder<Object> returnDiffBuilder = new NodeDiffImpl.Builder<Object>(((Node)newReturn.get()), null);
            returnDiffBuilder.withVersionImpact(SemverImpact.MAJOR).withMessage("return type is added").build().ifPresent(returnTypeDiffs::add);
        } else if (newReturn.isEmpty() && oldReturn.isPresent()) {
            NodeDiffImpl.Builder<Node> returnDiffBuilder = new NodeDiffImpl.Builder<Node>(null, (Node)oldReturn.get());
            returnDiffBuilder.withVersionImpact(SemverImpact.MAJOR).withMessage("return type is removed").build().ifPresent(returnTypeDiffs::add);
        } else if (newReturn.isPresent()) {
            this.compareReturnTypes((ReturnTypeDescriptorNode)newReturn.get(), (ReturnTypeDescriptorNode)oldReturn.get()).ifPresent(returnTypeDiffs::add);
            returnTypeDiffs.addAll(this.compareReturnAnnotations((ReturnTypeDescriptorNode)newReturn.get(), (ReturnTypeDescriptorNode)oldReturn.get()));
        }
        return returnTypeDiffs;
    }

    private Optional<? extends Diff> compareReturnTypes(ReturnTypeDescriptorNode newReturn, ReturnTypeDescriptorNode oldReturn) {
        Node newType = newReturn.type();
        Node oldType = oldReturn.type();
        if (!newType.toSourceCode().trim().equals(oldType.toSourceCode().trim())) {
            NodeDiffImpl.Builder<Node> returnTypeDiffBuilder = new NodeDiffImpl.Builder<Node>(newType, oldType);
            return returnTypeDiffBuilder.withVersionImpact(SemverImpact.AMBIGUOUS).withMessage(String.format("return type is changed from '%s' to '%s'", oldType.toSourceCode(), newType.toSourceCode())).build();
        }
        return Optional.empty();
    }

    private List<Diff> compareReturnAnnotations(ReturnTypeDescriptorNode newReturn, ReturnTypeDescriptorNode oldReturn) {
        LinkedList<Diff> returnAnnotationDiffs = new LinkedList<Diff>();
        NodeList newAnnots = newReturn.annotations();
        NodeList oldAnnots = oldReturn.annotations();
        DumbNodeListComparator annotsComparator = new DumbNodeListComparator(newAnnots, oldAnnots);
        annotsComparator.computeDiff().ifPresent(diff -> returnAnnotationDiffs.addAll(diff.getChildDiffs()));
        return returnAnnotationDiffs;
    }

    private List<Diff> compareFunctionBody() {
        ArrayList<Diff> functionBodyDiff = new ArrayList<Diff>();
        FunctionBodyNode newBody = ((FunctionDefinitionNode)this.newNode).functionBody();
        FunctionBodyNode oldBody = ((FunctionDefinitionNode)this.oldNode).functionBody();
        NodeDiffImpl.Builder<FunctionBodyNode> functionBodyDiffBuilder = new NodeDiffImpl.Builder<FunctionBodyNode>(newBody, oldBody);
        if (newBody != null && oldBody == null) {
            functionBodyDiffBuilder.withVersionImpact(SemverImpact.PATCH).withMessage("function body is added").build().ifPresent(functionBodyDiff::add);
        } else if (newBody == null && oldBody != null) {
            functionBodyDiffBuilder.withVersionImpact(SemverImpact.PATCH).withMessage("function body is removed").build().ifPresent(functionBodyDiff::add);
        } else if (newBody != null && !newBody.toSourceCode().equals(oldBody.toSourceCode())) {
            functionBodyDiffBuilder.withVersionImpact(SemverImpact.PATCH).withMessage("function body is modified").build().ifPresent(functionBodyDiff::add);
        }
        return functionBodyDiff;
    }

    private List<Diff> extractTerminalDiffs(Diff diff, List<Diff> extractedDiffs) {
        if (diff instanceof NodeDiff && ((NodeDiff)diff).getMessage().isPresent()) {
            extractedDiffs.add(diff);
        } else if (diff instanceof NodeListDiff && ((NodeListDiff)diff).getMessage().isPresent()) {
            extractedDiffs.add(diff);
        } else {
            for (Diff childDiff : diff.getChildDiffs()) {
                this.extractTerminalDiffs(childDiff, extractedDiffs);
            }
        }
        return extractedDiffs;
    }
}

