/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker.comparator;

import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.ConstantDeclarationNode;
import io.ballerina.compiler.syntax.tree.EnumDeclarationNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.projects.Module;
import io.ballerina.semver.checker.comparator.Comparator;
import io.ballerina.semver.checker.diff.DiffExtractor;
import io.ballerina.semver.checker.diff.ModuleDiff;
import io.ballerina.semver.checker.util.SyntaxTreeUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ModuleComparator
implements Comparator {
    private final Module newModule;
    private final Module oldModule;
    private final Map<String, FunctionDefinitionNode> newFunctions = new HashMap<String, FunctionDefinitionNode>();
    private final Map<String, FunctionDefinitionNode> oldFunctions = new HashMap<String, FunctionDefinitionNode>();
    private final Map<String, ServiceDeclarationNode> newServices = new HashMap<String, ServiceDeclarationNode>();
    private final Map<String, ServiceDeclarationNode> oldServices = new HashMap<String, ServiceDeclarationNode>();
    private final Map<String, ModuleVariableDeclarationNode> newVars = new HashMap<String, ModuleVariableDeclarationNode>();
    private final Map<String, ModuleVariableDeclarationNode> oldVars = new HashMap<String, ModuleVariableDeclarationNode>();
    private final Map<String, ConstantDeclarationNode> newConstants = new HashMap<String, ConstantDeclarationNode>();
    private final Map<String, ConstantDeclarationNode> oldConstants = new HashMap<String, ConstantDeclarationNode>();
    private final Map<String, ClassDefinitionNode> newClasses = new HashMap<String, ClassDefinitionNode>();
    private final Map<String, ClassDefinitionNode> oldClasses = new HashMap<String, ClassDefinitionNode>();
    private final Map<String, TypeDefinitionNode> newTypes = new HashMap<String, TypeDefinitionNode>();
    private final Map<String, TypeDefinitionNode> oldTypes = new HashMap<String, TypeDefinitionNode>();
    private final Map<String, EnumDeclarationNode> newEnums = new HashMap<String, EnumDeclarationNode>();
    private final Map<String, EnumDeclarationNode> oldEnums = new HashMap<String, EnumDeclarationNode>();

    public ModuleComparator(Module newModule, Module oldModule) {
        this.newModule = newModule;
        this.oldModule = oldModule;
    }

    public Optional<ModuleDiff> computeDiff() {
        this.extractModuleLevelDefinitions(this.newModule, true);
        this.extractModuleLevelDefinitions(this.oldModule, false);
        ModuleDiff.Builder moduleDiffBuilder = new ModuleDiff.Builder(this.newModule, this.oldModule);
        this.extractFunctionDiffs(moduleDiffBuilder);
        this.extractServiceDiffs(moduleDiffBuilder);
        this.extractModuleVarDiffs(moduleDiffBuilder);
        this.extractConstantDiffs(moduleDiffBuilder);
        this.extractClassDiffs(moduleDiffBuilder);
        this.extractTypeDefinitionDiffs(moduleDiffBuilder);
        this.extractEnumDeclarationDiffs(moduleDiffBuilder);
        return moduleDiffBuilder.build();
    }

    private void extractFunctionDiffs(ModuleDiff.Builder diffModifier) {
        DiffExtractor<FunctionDefinitionNode> funcDiffExtractor = new DiffExtractor<FunctionDefinitionNode>(this.newFunctions, this.oldFunctions);
        funcDiffExtractor.getAdditions().forEach((name, function) -> diffModifier.withFunctionAdded((FunctionDefinitionNode)function));
        funcDiffExtractor.getRemovals().forEach((name, function) -> diffModifier.withFunctionRemoved((FunctionDefinitionNode)function));
        funcDiffExtractor.getCommons().forEach((name, functions) -> diffModifier.withFunctionChanged((FunctionDefinitionNode)functions.getKey(), (FunctionDefinitionNode)functions.getValue()));
    }

    private void extractServiceDiffs(ModuleDiff.Builder diffModifier) {
        DiffExtractor<ServiceDeclarationNode> serviceDiffExtractor = new DiffExtractor<ServiceDeclarationNode>(this.newServices, this.oldServices);
        serviceDiffExtractor.getAdditions().forEach((name, service) -> diffModifier.withServiceAdded((ServiceDeclarationNode)service));
        serviceDiffExtractor.getRemovals().forEach((name, service) -> diffModifier.withServiceRemoved((ServiceDeclarationNode)service));
        serviceDiffExtractor.getCommons().forEach((name, service) -> diffModifier.withServiceChanged((ServiceDeclarationNode)service.getKey(), (ServiceDeclarationNode)service.getValue()));
    }

    private void extractModuleVarDiffs(ModuleDiff.Builder diffModifier) {
        DiffExtractor<ModuleVariableDeclarationNode> moduleVarDiffExtractor = new DiffExtractor<ModuleVariableDeclarationNode>(this.newVars, this.oldVars);
        moduleVarDiffExtractor.getAdditions().forEach((name, var) -> diffModifier.withModuleVarAdded((ModuleVariableDeclarationNode)var));
        moduleVarDiffExtractor.getRemovals().forEach((name, var) -> diffModifier.withModuleVarRemoved((ModuleVariableDeclarationNode)var));
        moduleVarDiffExtractor.getCommons().forEach((name, var) -> diffModifier.withModuleVarChanged((ModuleVariableDeclarationNode)var.getKey(), (ModuleVariableDeclarationNode)var.getValue()));
    }

    private void extractConstantDiffs(ModuleDiff.Builder diffModifier) {
        DiffExtractor<ConstantDeclarationNode> constDiffExtractor = new DiffExtractor<ConstantDeclarationNode>(this.newConstants, this.oldConstants);
        constDiffExtractor.getAdditions().forEach((name, constant) -> diffModifier.withConstantAdded((ConstantDeclarationNode)constant));
        constDiffExtractor.getRemovals().forEach((name, constant) -> diffModifier.withConstantRemoved((ConstantDeclarationNode)constant));
        constDiffExtractor.getCommons().forEach((name, constant) -> diffModifier.withConstantChanged((ConstantDeclarationNode)constant.getKey(), (ConstantDeclarationNode)constant.getValue()));
    }

    private void extractClassDiffs(ModuleDiff.Builder diffModifier) {
        DiffExtractor<ClassDefinitionNode> constDiffExtractor = new DiffExtractor<ClassDefinitionNode>(this.newClasses, this.oldClasses);
        constDiffExtractor.getAdditions().forEach((name, clazz) -> diffModifier.withClassAdded((ClassDefinitionNode)clazz));
        constDiffExtractor.getRemovals().forEach((name, clazz) -> diffModifier.withClassRemoved((ClassDefinitionNode)clazz));
        constDiffExtractor.getCommons().forEach((name, clazz) -> diffModifier.withClassModified((ClassDefinitionNode)clazz.getKey(), (ClassDefinitionNode)clazz.getValue()));
    }

    private void extractTypeDefinitionDiffs(ModuleDiff.Builder diffModifier) {
        DiffExtractor<TypeDefinitionNode> constDiffExtractor = new DiffExtractor<TypeDefinitionNode>(this.newTypes, this.oldTypes);
        constDiffExtractor.getAdditions().forEach((name, type) -> diffModifier.withTypeDefAdded((TypeDefinitionNode)type));
        constDiffExtractor.getRemovals().forEach((name, type) -> diffModifier.withTypeDefRemoved((TypeDefinitionNode)type));
        constDiffExtractor.getCommons().forEach((name, types) -> diffModifier.withTypeDefModified((TypeDefinitionNode)types.getKey(), (TypeDefinitionNode)types.getValue()));
    }

    private void extractEnumDeclarationDiffs(ModuleDiff.Builder diffModifier) {
        DiffExtractor<EnumDeclarationNode> constDiffExtractor = new DiffExtractor<EnumDeclarationNode>(this.newEnums, this.oldEnums);
        constDiffExtractor.getAdditions().forEach((name, type) -> diffModifier.withEnumAdded((EnumDeclarationNode)type));
        constDiffExtractor.getRemovals().forEach((name, type) -> diffModifier.withEnumRemoved((EnumDeclarationNode)type));
        constDiffExtractor.getCommons().forEach((name, types) -> diffModifier.withEnumModified((EnumDeclarationNode)types.getKey(), (EnumDeclarationNode)types.getValue()));
    }

    private void extractModuleLevelDefinitions(Module module, boolean isNewModule) {
        module.documentIds().forEach(documentId -> {
            SyntaxTree documentST = module.document(documentId).syntaxTree();
            if (documentST.rootNode() == null || documentST.rootNode().kind() != SyntaxKind.MODULE_PART) {
                return;
            }
            NodeList members = ((ModulePartNode)documentST.rootNode()).members();
            for (ModuleMemberDeclarationNode member : members) {
                switch (member.kind()) {
                    case FUNCTION_DEFINITION: {
                        FunctionDefinitionNode funcNode = (FunctionDefinitionNode)member;
                        if (isNewModule) {
                            this.newFunctions.put(SyntaxTreeUtils.getFunctionIdentifier(funcNode), funcNode);
                            break;
                        }
                        this.oldFunctions.put(SyntaxTreeUtils.getFunctionIdentifier(funcNode), funcNode);
                        break;
                    }
                    case SERVICE_DECLARATION: {
                        ServiceDeclarationNode serviceNode = (ServiceDeclarationNode)member;
                        Optional<String> serviceName = SyntaxTreeUtils.getServiceIdentifier(serviceNode);
                        if (!serviceName.isPresent()) break;
                        if (isNewModule) {
                            this.newServices.put(serviceName.get(), serviceNode);
                            break;
                        }
                        this.oldServices.put(serviceName.get(), serviceNode);
                        break;
                    }
                    case MODULE_VAR_DECL: {
                        ModuleVariableDeclarationNode varNode = (ModuleVariableDeclarationNode)member;
                        if (isNewModule) {
                            this.newVars.put(SyntaxTreeUtils.getModuleVarIdentifier(varNode), varNode);
                            break;
                        }
                        this.oldVars.put(SyntaxTreeUtils.getModuleVarIdentifier(varNode), varNode);
                        break;
                    }
                    case CONST_DECLARATION: {
                        ConstantDeclarationNode constNode = (ConstantDeclarationNode)member;
                        if (isNewModule) {
                            this.newConstants.put(SyntaxTreeUtils.getConstIdentifier(constNode), constNode);
                            break;
                        }
                        this.oldConstants.put(SyntaxTreeUtils.getConstIdentifier(constNode), constNode);
                        break;
                    }
                    case CLASS_DEFINITION: {
                        ClassDefinitionNode classNode = (ClassDefinitionNode)member;
                        if (isNewModule) {
                            this.newClasses.put(SyntaxTreeUtils.getClassIdentifier(classNode), classNode);
                            break;
                        }
                        this.oldClasses.put(SyntaxTreeUtils.getClassIdentifier(classNode), classNode);
                        break;
                    }
                    case TYPE_DEFINITION: {
                        TypeDefinitionNode typeNode = (TypeDefinitionNode)member;
                        if (isNewModule) {
                            this.newTypes.put(SyntaxTreeUtils.getTypeDefIdentifier(typeNode), typeNode);
                            break;
                        }
                        this.oldTypes.put(SyntaxTreeUtils.getTypeDefIdentifier(typeNode), typeNode);
                        break;
                    }
                    case ENUM_DECLARATION: {
                        EnumDeclarationNode enumNode = (EnumDeclarationNode)member;
                        if (isNewModule) {
                            this.newEnums.put(SyntaxTreeUtils.getEnumIdentifier(enumNode), enumNode);
                            break;
                        }
                        this.oldEnums.put(SyntaxTreeUtils.getEnumIdentifier(enumNode), enumNode);
                        break;
                    }
                }
            }
        });
    }
}

