/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker.comparator;

import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.semver.checker.comparator.DocumentationComparator;
import io.ballerina.semver.checker.comparator.DumbNodeComparator;
import io.ballerina.semver.checker.comparator.DumbNodeListComparator;
import io.ballerina.semver.checker.comparator.NodeComparator;
import io.ballerina.semver.checker.diff.Diff;
import io.ballerina.semver.checker.diff.DiffKind;
import io.ballerina.semver.checker.diff.NodeDiffBuilder;
import io.ballerina.semver.checker.diff.NodeDiffImpl;
import io.ballerina.semver.checker.diff.ObjectFieldDiff;
import io.ballerina.semver.checker.diff.SemverImpact;
import io.ballerina.semver.checker.util.SyntaxTreeUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class ObjectFieldComparator
extends NodeComparator<ObjectFieldNode> {
    public ObjectFieldComparator(ObjectFieldNode newNode, ObjectFieldNode oldNode) {
        super(newNode, oldNode);
    }

    @Override
    public Optional<? extends Diff> computeDiff() {
        NodeDiffBuilder diffBuilder = new ObjectFieldDiff.Builder((ObjectFieldNode)this.newNode, (ObjectFieldNode)this.oldNode).withChildDiffs(this.compareObjectFieldMetadata((ObjectFieldNode)this.newNode, (ObjectFieldNode)this.oldNode)).withChildDiffs(this.compareObjectFieldQualifiers((ObjectFieldNode)this.newNode, (ObjectFieldNode)this.oldNode)).withChildDiffs(this.compareObjectFieldType((ObjectFieldNode)this.newNode, (ObjectFieldNode)this.oldNode)).withChildDiffs(this.compareObjectFieldExpression((ObjectFieldNode)this.newNode, (ObjectFieldNode)this.oldNode));
        if (!this.isPublic()) {
            diffBuilder = diffBuilder.withVersionImpact(SemverImpact.PATCH);
        }
        return diffBuilder.build();
    }

    private List<Diff> compareObjectFieldMetadata(ObjectFieldNode newNode, ObjectFieldNode oldNode) {
        ArrayList<Diff> metadataDiffs = new ArrayList<Diff>();
        Optional newMeta = newNode.metadata();
        Optional oldMeta = oldNode.metadata();
        Node newDocs = newMeta.flatMap(MetadataNode::documentationString).orElse(null);
        Node oldDocs = oldMeta.flatMap(MetadataNode::documentationString).orElse(null);
        DocumentationComparator documentationComparator = new DocumentationComparator(newDocs, oldDocs);
        documentationComparator.computeDiff().ifPresent(metadataDiffs::add);
        NodeList newAnnots = newMeta.map(MetadataNode::annotations).orElse(null);
        NodeList oldAnnots = oldMeta.map(MetadataNode::annotations).orElse(null);
        DumbNodeListComparator annotComparator = new DumbNodeListComparator(newAnnots, oldAnnots);
        annotComparator.computeDiff().ifPresent(metadataDiffs::add);
        return metadataDiffs;
    }

    private List<Diff> compareObjectFieldQualifiers(ObjectFieldNode newNode, ObjectFieldNode oldNode) {
        ArrayList<Diff> qualifierDiffs = new ArrayList<Diff>();
        NodeList newQualifiers = newNode.qualifierList();
        NodeList oldQualifiers = oldNode.qualifierList();
        Optional newPublicQual = newNode.visibilityQualifier();
        Optional oldPublicQual = oldNode.visibilityQualifier();
        if (newPublicQual.isPresent() && oldPublicQual.isEmpty()) {
            qualifierDiffBuilder = new NodeDiffImpl.Builder<Object>(((Node)newPublicQual.get()), null);
            qualifierDiffBuilder.withKind(DiffKind.OBJECT_FIELD).withVersionImpact(SemverImpact.MINOR).withMessage("'public' qualifier is added to object field '" + this.getObjectFieldName() + "'").build().ifPresent(qualifierDiffs::add);
        } else if (newPublicQual.isEmpty() && oldPublicQual.isPresent()) {
            qualifierDiffBuilder = new NodeDiffImpl.Builder<Node>(null, (Node)oldPublicQual.get());
            qualifierDiffBuilder.withKind(DiffKind.OBJECT_FIELD).withVersionImpact(SemverImpact.MAJOR).withMessage("'public' qualifier is removed from object field '" + this.getObjectFieldName() + "'").build().ifPresent(qualifierDiffs::add);
        }
        Optional<Token> newIsolatedQual = SyntaxTreeUtils.lookupQualifier((NodeList<Token>)newQualifiers, SyntaxKind.PRIVATE_KEYWORD);
        Optional<Token> oldIsolatedQual = SyntaxTreeUtils.lookupQualifier((NodeList<Token>)oldQualifiers, SyntaxKind.PRIVATE_KEYWORD);
        if (newIsolatedQual.isPresent() && oldIsolatedQual.isEmpty()) {
            qualifierDiffBuilder = new NodeDiffImpl.Builder<Object>(((Node)newIsolatedQual.get()), null);
            qualifierDiffBuilder.withKind(DiffKind.OBJECT_FIELD).withVersionImpact(SemverImpact.PATCH).withMessage("'private' qualifier is added to object field '" + this.getObjectFieldName() + "'").build().ifPresent(qualifierDiffs::add);
        } else if (newIsolatedQual.isEmpty() && oldIsolatedQual.isPresent()) {
            qualifierDiffBuilder = new NodeDiffImpl.Builder<Node>(null, (Node)oldIsolatedQual.get());
            qualifierDiffBuilder.withKind(DiffKind.OBJECT_FIELD).withVersionImpact(SemverImpact.PATCH).withMessage("'private' qualifier is removed from object field '" + this.getObjectFieldName() + "'").build().ifPresent(qualifierDiffs::add);
        }
        Optional<Token> newTransactionalQual = SyntaxTreeUtils.lookupQualifier((NodeList<Token>)newQualifiers, SyntaxKind.FINAL_KEYWORD);
        Optional<Token> oldTransactionalQual = SyntaxTreeUtils.lookupQualifier((NodeList<Token>)oldQualifiers, SyntaxKind.FINAL_KEYWORD);
        if (newTransactionalQual.isPresent() && oldTransactionalQual.isEmpty()) {
            NodeDiffImpl.Builder<Object> qualifierDiffBuilder = new NodeDiffImpl.Builder<Object>(((Node)newTransactionalQual.get()), null);
            qualifierDiffBuilder.withKind(DiffKind.OBJECT_FIELD).withVersionImpact(SemverImpact.AMBIGUOUS).withMessage("'final' qualifier is added to object field '" + this.getObjectFieldName() + "'").build().ifPresent(qualifierDiffs::add);
        } else if (newTransactionalQual.isEmpty() && oldTransactionalQual.isPresent()) {
            NodeDiffImpl.Builder<Node> qualifierDiffBuilder = new NodeDiffImpl.Builder<Node>(null, (Node)oldTransactionalQual.get());
            qualifierDiffBuilder.withKind(DiffKind.OBJECT_FIELD).withVersionImpact(SemverImpact.PATCH).withMessage("'final' qualifier is removed from object field '" + this.getObjectFieldName() + "'").build().ifPresent(qualifierDiffs::add);
        }
        return qualifierDiffs;
    }

    private List<Diff> compareObjectFieldType(ObjectFieldNode newNode, ObjectFieldNode oldNode) {
        LinkedList<Diff> typeDiffs = new LinkedList<Diff>();
        Node newType = newNode.typeName();
        Node oldType = oldNode.typeName();
        if (newType == null || oldType == null) {
            return typeDiffs;
        }
        if (!newType.toSourceCode().trim().equals(oldType.toSourceCode().trim())) {
            NodeDiffImpl.Builder<Node> diffBuilder = new NodeDiffImpl.Builder<Node>(newType, oldType);
            diffBuilder.withKind(DiffKind.OBJECT_FIELD).withVersionImpact(SemverImpact.AMBIGUOUS).withMessage(String.format("object field type changed from '%s' to '%s'", oldType.toSourceCode().trim(), newType.toSourceCode().trim())).build().ifPresent(typeDiffs::add);
        }
        return typeDiffs;
    }

    private List<Diff> compareObjectFieldExpression(ObjectFieldNode newNode, ObjectFieldNode oldNode) {
        LinkedList<Diff> exprDiffs = new LinkedList<Diff>();
        DumbNodeComparator<Node> exprComparator = new DumbNodeComparator<Node>(newNode.expression().orElse(null), oldNode.expression().orElse(null), DiffKind.OBJECT_FIELD_EXPR);
        exprComparator.computeDiff().ifPresent(exprDiffs::add);
        return exprDiffs;
    }

    private boolean isPublic() {
        boolean isNewPublic = this.newNode != null && ((ObjectFieldNode)this.newNode).visibilityQualifier().stream().anyMatch(qualifier -> qualifier.kind() == SyntaxKind.PUBLIC_KEYWORD);
        boolean isOldPublic = this.oldNode != null && ((ObjectFieldNode)this.oldNode).visibilityQualifier().stream().anyMatch(qualifier -> qualifier.kind() == SyntaxKind.PUBLIC_KEYWORD);
        return isNewPublic || isOldPublic;
    }

    private String getObjectFieldName() {
        return this.newNode != null ? ((ObjectFieldNode)this.newNode).fieldName().text() : ((ObjectFieldNode)this.oldNode).fieldName().text();
    }
}

