/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker.comparator;

import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.RestParameterNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.semver.checker.comparator.NodeComparator;
import io.ballerina.semver.checker.diff.Diff;
import io.ballerina.semver.checker.diff.NodeDiffBuilder;
import io.ballerina.semver.checker.diff.NodeDiffImpl;
import io.ballerina.semver.checker.diff.SemverImpact;
import java.util.Optional;

public class ParamComparator
extends NodeComparator<ParameterNode> {
    ParamComparator(ParameterNode newNode, ParameterNode oldNode) {
        super(newNode, oldNode);
    }

    @Override
    public Optional<? extends Diff> computeDiff() {
        NodeDiffImpl.Builder<ParameterNode> paramDiffs = new NodeDiffImpl.Builder<ParameterNode>((ParameterNode)this.newNode, (ParameterNode)this.oldNode);
        this.compareParamKind((ParameterNode)this.newNode, (ParameterNode)this.oldNode).ifPresent(paramDiffs::withChildDiff);
        this.compareParamType((ParameterNode)this.newNode, (ParameterNode)this.oldNode).ifPresent(paramDiffs::withChildDiff);
        this.compareParamValue((ParameterNode)this.newNode, (ParameterNode)this.oldNode).ifPresent(paramDiffs::withChildDiff);
        this.compareParamAnnotations((ParameterNode)this.newNode, (ParameterNode)this.oldNode).ifPresent(paramDiffs::withChildDiff);
        return paramDiffs.build();
    }

    private Optional<NodeDiffImpl<Node>> compareParamAnnotations(ParameterNode newNode, ParameterNode oldNode) {
        return Optional.empty();
    }

    private Optional<? extends Diff> compareParamValue(ParameterNode newParam, ParameterNode oldParam) {
        if (newParam.kind() != SyntaxKind.DEFAULTABLE_PARAM || oldParam.kind() != SyntaxKind.DEFAULTABLE_PARAM) {
            return Optional.empty();
        }
        Node newExpr = ((DefaultableParameterNode)newParam).expression();
        Node oldExpr = ((DefaultableParameterNode)oldParam).expression();
        if (newExpr.toSourceCode().trim().equals(oldExpr.toSourceCode().trim())) {
            return Optional.empty();
        }
        NodeDiffImpl.Builder<ParameterNode> diffBuilder = new NodeDiffImpl.Builder<ParameterNode>(newParam, oldParam);
        diffBuilder.withMessage(String.format("default value of parameter '%s' is changed from '%s' to '%s'", ((DefaultableParameterNode)newParam).paramName(), oldExpr.toSourceCode().trim(), newExpr.toSourceCode().trim()));
        if (newExpr instanceof BasicLiteralNode && oldExpr instanceof BasicLiteralNode) {
            diffBuilder.withVersionImpact(SemverImpact.MINOR);
        } else {
            diffBuilder.withVersionImpact(SemverImpact.AMBIGUOUS);
        }
        return diffBuilder.build();
    }

    private Optional<? extends Diff> compareParamType(ParameterNode newParam, ParameterNode oldParam) {
        Node newType = this.getParamType(newParam);
        Node oldType = this.getParamType(oldParam);
        if (newType == null || oldType == null) {
            return Optional.empty();
        }
        if (!newType.toSourceCode().trim().equals(oldType.toSourceCode().trim())) {
            NodeDiffBuilder diffBuilder = new NodeDiffImpl.Builder<ParameterNode>(newParam, oldParam);
            diffBuilder = diffBuilder.withVersionImpact(SemverImpact.AMBIGUOUS);
            diffBuilder.withMessage(String.format("type of parameter '%s' is changed from '%s' to '%s'", this.getParamName(newParam), oldType.toSourceCode().trim(), newType.toSourceCode().trim()));
            return diffBuilder.build();
        }
        return Optional.empty();
    }

    private Optional<? extends Diff> compareParamKind(ParameterNode newParam, ParameterNode oldParam) {
        if (((ParameterNode)this.newNode).kind() == ((ParameterNode)this.oldNode).kind()) {
            return Optional.empty();
        }
        NodeDiffBuilder paramDiffBuilder = new NodeDiffImpl.Builder<ParameterNode>(newParam, oldParam);
        paramDiffBuilder = paramDiffBuilder.withMessage(String.format("kind of parameter '%s' is changed from '%s' to '%s'", this.getParamName(newParam), oldParam.kind(), newParam.kind()));
        if (newParam.kind() == SyntaxKind.REQUIRED_PARAM && oldParam.kind() == SyntaxKind.DEFAULTABLE_PARAM) {
            paramDiffBuilder.withVersionImpact(SemverImpact.MAJOR);
        } else if (newParam.kind() == SyntaxKind.DEFAULTABLE_PARAM && oldParam.kind() == SyntaxKind.REQUIRED_PARAM) {
            paramDiffBuilder.withVersionImpact(SemverImpact.MINOR);
        } else if (newParam.kind() == SyntaxKind.DEFAULTABLE_PARAM && oldParam.kind() == SyntaxKind.REST_PARAM) {
            paramDiffBuilder.withVersionImpact(SemverImpact.MAJOR);
        } else if (newParam.kind() == SyntaxKind.REST_PARAM && oldParam.kind() == SyntaxKind.DEFAULTABLE_PARAM) {
            paramDiffBuilder.withVersionImpact(SemverImpact.MAJOR);
        } else if (newParam.kind() == SyntaxKind.REQUIRED_PARAM && oldParam.kind() == SyntaxKind.REST_PARAM) {
            paramDiffBuilder.withVersionImpact(SemverImpact.MAJOR);
        } else if (newParam.kind() == SyntaxKind.REST_PARAM && oldParam.kind() == SyntaxKind.REQUIRED_PARAM) {
            paramDiffBuilder.withVersionImpact(SemverImpact.MAJOR);
        }
        return paramDiffBuilder.build();
    }

    private Node getParamType(ParameterNode paramNode) {
        if (paramNode.kind() == SyntaxKind.REQUIRED_PARAM) {
            return ((RequiredParameterNode)paramNode).typeName();
        }
        if (paramNode.kind() == SyntaxKind.DEFAULTABLE_PARAM) {
            return ((DefaultableParameterNode)paramNode).typeName();
        }
        if (paramNode.kind() == SyntaxKind.REST_PARAM) {
            return ((RestParameterNode)paramNode).typeName();
        }
        return null;
    }

    private String getParamName(ParameterNode paramNode) {
        Node paramName = null;
        if (paramNode.kind() == SyntaxKind.REQUIRED_PARAM) {
            paramName = ((RequiredParameterNode)paramNode).paramName().orElse(null);
        } else if (paramNode.kind() == SyntaxKind.DEFAULTABLE_PARAM) {
            paramName = ((DefaultableParameterNode)paramNode).paramName().orElse(null);
        } else if (paramNode.kind() == SyntaxKind.REST_PARAM) {
            paramName = ((RestParameterNode)paramNode).paramName().orElse(null);
        }
        return paramName != null ? paramName.toSourceCode().trim() : "unknown";
    }
}

