/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker.diff;

import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.semver.checker.diff.Diff;
import io.ballerina.semver.checker.diff.DiffKind;
import io.ballerina.semver.checker.diff.DiffType;
import io.ballerina.semver.checker.diff.NodeDiffBuilder;
import io.ballerina.semver.checker.diff.NodeDiffImpl;
import io.ballerina.semver.checker.diff.SemverImpact;
import java.util.Collection;
import java.util.Optional;

public class ClassDiff
extends NodeDiffImpl<ClassDefinitionNode> {
    private ClassDiff(ClassDefinitionNode newNode, ClassDefinitionNode oldNode) {
        super(newNode, oldNode, DiffKind.CLASS);
    }

    @Override
    public void computeVersionImpact() {
        boolean isPublic = this.isPublic();
        if (this.newNode != null && this.oldNode == null) {
            this.versionImpact = isPublic ? SemverImpact.MINOR : SemverImpact.PATCH;
        } else if (this.newNode == null && this.oldNode != null) {
            this.versionImpact = isPublic ? SemverImpact.MAJOR : SemverImpact.PATCH;
        } else if (isPublic) {
            super.computeVersionImpact();
        } else {
            this.versionImpact = SemverImpact.PATCH;
        }
    }

    private boolean isPublic() {
        boolean isNewPublic = this.newNode != null && ((ClassDefinitionNode)this.newNode).visibilityQualifier().stream().anyMatch(qualifier -> qualifier.kind() == SyntaxKind.PUBLIC_KEYWORD);
        boolean isOldPublic = this.oldNode != null && ((ClassDefinitionNode)this.oldNode).visibilityQualifier().stream().anyMatch(qualifier -> qualifier.kind() == SyntaxKind.PUBLIC_KEYWORD);
        return isNewPublic || isOldPublic;
    }

    public static class Builder
    extends NodeDiffImpl.Builder<ClassDefinitionNode> {
        private final ClassDiff classDiff;

        public Builder(ClassDefinitionNode newNode, ClassDefinitionNode oldNode) {
            super(newNode, oldNode);
            this.classDiff = new ClassDiff(newNode, oldNode);
        }

        @Override
        public Optional<ClassDiff> build() {
            if (!this.classDiff.getChildDiffs().isEmpty()) {
                this.classDiff.computeVersionImpact();
                this.classDiff.setType(DiffType.MODIFIED);
                return Optional.of(this.classDiff);
            }
            if (this.classDiff.getType() == DiffType.NEW || this.classDiff.getType() == DiffType.REMOVED) {
                return Optional.of(this.classDiff);
            }
            return Optional.empty();
        }

        @Override
        public NodeDiffBuilder withType(DiffType diffType) {
            this.classDiff.setType(diffType);
            return this;
        }

        @Override
        public NodeDiffBuilder withVersionImpact(SemverImpact versionImpact) {
            this.classDiff.setVersionImpact(versionImpact);
            return this;
        }

        @Override
        public NodeDiffBuilder withMessage(String message) {
            this.classDiff.setMessage(message);
            return this;
        }

        @Override
        public NodeDiffBuilder withChildDiff(Diff childDiff) {
            this.classDiff.childDiffs.add(childDiff);
            return this;
        }

        @Override
        public NodeDiffBuilder withChildDiffs(Collection<? extends Diff> childDiffs) {
            this.classDiff.childDiffs.addAll(childDiffs);
            return this;
        }
    }
}

