/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker.diff;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;

public class DiffExtractor<T> {
    private final Map<String, T> newValues;
    private final Map<String, T> oldValues;
    private Map<String, T> additions;
    private Map<String, T> removals;
    private Map<String, Map.Entry<T, T>> commons;

    public DiffExtractor(Map<String, T> newVals, Map<String, T> oldVals) {
        this.newValues = newVals;
        this.oldValues = oldVals;
    }

    public Map<String, T> getAdditions() {
        this.extractChanges();
        return this.additions;
    }

    public Map<String, T> getRemovals() {
        this.extractChanges();
        return this.removals;
    }

    public Map<String, Map.Entry<T, T>> getCommons() {
        this.extractChanges();
        return this.commons;
    }

    private void extractChanges() {
        if (this.additions != null && this.removals != null && this.commons != null) {
            return;
        }
        this.additions = new HashMap<String, T>();
        this.removals = new HashMap<String, T>();
        this.commons = new HashMap<String, Map.Entry<T, T>>();
        for (Map.Entry<String, T> entry : this.newValues.entrySet()) {
            if (!this.oldValues.containsKey(entry.getKey())) {
                this.additions.put(entry.getKey(), entry.getValue());
                continue;
            }
            this.commons.put(entry.getKey(), new AbstractMap.SimpleEntry<T, T>(entry.getValue(), this.oldValues.remove(entry.getKey())));
        }
        for (Map.Entry<String, T> entry : this.oldValues.entrySet()) {
            this.removals.put(entry.getKey(), entry.getValue());
        }
    }
}

