/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker.diff;

import io.ballerina.compiler.syntax.tree.EnumDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.semver.checker.diff.Diff;
import io.ballerina.semver.checker.diff.DiffKind;
import io.ballerina.semver.checker.diff.DiffType;
import io.ballerina.semver.checker.diff.NodeDiffBuilder;
import io.ballerina.semver.checker.diff.NodeDiffImpl;
import io.ballerina.semver.checker.diff.SemverImpact;
import java.util.Collection;
import java.util.Optional;

public class EnumDiff
extends NodeDiffImpl<EnumDeclarationNode> {
    private EnumDiff(EnumDeclarationNode newNode, EnumDeclarationNode oldNode) {
        super(newNode, oldNode, DiffKind.ENUM);
    }

    @Override
    public void computeVersionImpact() {
        boolean isPublic = this.isPublic();
        if (this.newNode != null && this.oldNode == null) {
            this.versionImpact = isPublic ? SemverImpact.MINOR : SemverImpact.PATCH;
        } else if (this.newNode == null && this.oldNode != null) {
            this.versionImpact = isPublic ? SemverImpact.MAJOR : SemverImpact.PATCH;
        } else if (isPublic) {
            super.computeVersionImpact();
        } else {
            this.versionImpact = SemverImpact.PATCH;
        }
    }

    private boolean isPublic() {
        boolean isNewPublic = this.newNode != null && ((EnumDeclarationNode)this.newNode).qualifier().stream().anyMatch(qualifier -> qualifier.kind() == SyntaxKind.PUBLIC_KEYWORD);
        boolean isOldPublic = this.oldNode != null && ((EnumDeclarationNode)this.oldNode).qualifier().stream().anyMatch(qualifier -> qualifier.kind() == SyntaxKind.PUBLIC_KEYWORD);
        return isNewPublic || isOldPublic;
    }

    public static class Builder
    extends NodeDiffImpl.Builder<EnumDeclarationNode> {
        private final EnumDiff enumDiff;

        public Builder(EnumDeclarationNode newNode, EnumDeclarationNode oldNode) {
            super(newNode, oldNode);
            this.enumDiff = new EnumDiff(newNode, oldNode);
        }

        @Override
        public Optional<EnumDiff> build() {
            if (!this.enumDiff.getChildDiffs().isEmpty()) {
                this.enumDiff.computeVersionImpact();
                this.enumDiff.setType(DiffType.MODIFIED);
                return Optional.of(this.enumDiff);
            }
            if (this.enumDiff.getType() == DiffType.NEW || this.enumDiff.getType() == DiffType.REMOVED) {
                return Optional.of(this.enumDiff);
            }
            return Optional.empty();
        }

        @Override
        public NodeDiffBuilder withType(DiffType diffType) {
            this.enumDiff.setType(diffType);
            return this;
        }

        @Override
        public NodeDiffBuilder withVersionImpact(SemverImpact versionImpact) {
            this.enumDiff.setVersionImpact(versionImpact);
            return this;
        }

        @Override
        public NodeDiffBuilder withMessage(String message) {
            this.enumDiff.setMessage(message);
            return this;
        }

        @Override
        public NodeDiffBuilder withChildDiff(Diff childDiff) {
            this.enumDiff.childDiffs.add(childDiff);
            return this;
        }

        @Override
        public NodeDiffBuilder withChildDiffs(Collection<? extends Diff> childDiffs) {
            this.enumDiff.childDiffs.addAll(childDiffs);
            return this;
        }
    }
}

