/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker.diff;

import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.semver.checker.diff.Diff;
import io.ballerina.semver.checker.diff.DiffKind;
import io.ballerina.semver.checker.diff.DiffType;
import io.ballerina.semver.checker.diff.NodeDiffBuilder;
import io.ballerina.semver.checker.diff.NodeDiffImpl;
import io.ballerina.semver.checker.diff.SemverImpact;
import java.util.Collection;
import java.util.Optional;

public class FunctionDiff
extends NodeDiffImpl<FunctionDefinitionNode> {
    private FunctionDiff(FunctionDefinitionNode newNode, FunctionDefinitionNode oldNode) {
        super(newNode, oldNode);
    }

    @Override
    public void computeVersionImpact() {
        if (this.isRemote() || this.isResource()) {
            super.computeVersionImpact();
            return;
        }
        boolean isPublic = this.isPublic();
        if (this.newNode != null && this.oldNode == null) {
            this.versionImpact = isPublic ? SemverImpact.MINOR : SemverImpact.PATCH;
        } else if (this.newNode == null && this.oldNode != null) {
            this.versionImpact = isPublic ? SemverImpact.MAJOR : SemverImpact.PATCH;
        } else if (isPublic) {
            super.computeVersionImpact();
        } else {
            this.versionImpact = SemverImpact.PATCH;
        }
    }

    private boolean isPublic() {
        boolean isNewPublic = this.newNode != null && ((FunctionDefinitionNode)this.newNode).qualifierList().stream().anyMatch(qualifier -> qualifier.kind() == SyntaxKind.PUBLIC_KEYWORD);
        boolean isOldPublic = this.oldNode != null && ((FunctionDefinitionNode)this.oldNode).qualifierList().stream().anyMatch(qualifier -> qualifier.kind() == SyntaxKind.PUBLIC_KEYWORD);
        return isNewPublic || isOldPublic;
    }

    public boolean isResource() {
        boolean isNewResource = this.newNode != null && ((FunctionDefinitionNode)this.newNode).qualifierList().stream().anyMatch(qualifier -> qualifier.kind() == SyntaxKind.RESOURCE_KEYWORD);
        boolean isOldResource = this.oldNode != null && ((FunctionDefinitionNode)this.oldNode).qualifierList().stream().anyMatch(qualifier -> qualifier.kind() == SyntaxKind.RESOURCE_KEYWORD);
        return isNewResource || isOldResource;
    }

    public boolean isRemote() {
        boolean isNewRemote = this.newNode != null && ((FunctionDefinitionNode)this.newNode).qualifierList().stream().anyMatch(qualifier -> qualifier.kind() == SyntaxKind.REMOTE_KEYWORD);
        boolean isOldRemote = this.oldNode != null && ((FunctionDefinitionNode)this.oldNode).qualifierList().stream().anyMatch(qualifier -> qualifier.kind() == SyntaxKind.REMOTE_KEYWORD);
        return isNewRemote || isOldRemote;
    }

    public static class Builder
    extends NodeDiffImpl.Builder<FunctionDefinitionNode> {
        private final FunctionDiff functionDiff;

        public Builder(FunctionDefinitionNode newNode, FunctionDefinitionNode oldNode) {
            super(newNode, oldNode);
            this.functionDiff = new FunctionDiff(newNode, oldNode);
        }

        @Override
        public Optional<FunctionDiff> build() {
            if (this.functionDiff.isRemote()) {
                this.functionDiff.setKind(DiffKind.REMOTE_FUNCTION);
            } else if (this.functionDiff.isResource()) {
                this.functionDiff.setKind(DiffKind.RESOURCE_FUNCTION);
            } else {
                this.functionDiff.setKind(DiffKind.FUNCTION);
            }
            if (!this.functionDiff.getChildDiffs().isEmpty()) {
                this.functionDiff.setType(DiffType.MODIFIED);
            }
            if (this.functionDiff.diffType != DiffType.UNKNOWN) {
                this.functionDiff.computeVersionImpact();
                return Optional.of(this.functionDiff);
            }
            return Optional.empty();
        }

        @Override
        public NodeDiffBuilder withType(DiffType diffType) {
            this.functionDiff.setType(diffType);
            return this;
        }

        @Override
        public NodeDiffBuilder withKind(DiffKind diffKind) {
            this.functionDiff.setKind(diffKind);
            return this;
        }

        @Override
        public NodeDiffBuilder withVersionImpact(SemverImpact versionImpact) {
            this.functionDiff.setVersionImpact(versionImpact);
            return this;
        }

        @Override
        public NodeDiffBuilder withMessage(String message) {
            this.functionDiff.setMessage(message);
            return this;
        }

        @Override
        public NodeDiffBuilder withChildDiff(Diff childDiff) {
            this.functionDiff.childDiffs.add(childDiff);
            return this;
        }

        @Override
        public NodeDiffBuilder withChildDiffs(Collection<? extends Diff> childDiffs) {
            this.functionDiff.childDiffs.addAll(childDiffs);
            return this;
        }
    }
}

