/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker.diff;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.semver.checker.diff.Diff;
import io.ballerina.semver.checker.diff.DiffKind;
import io.ballerina.semver.checker.diff.DiffType;
import io.ballerina.semver.checker.diff.NodeDiffBuilder;
import io.ballerina.semver.checker.diff.NodeListDiff;
import io.ballerina.semver.checker.diff.SemverImpact;
import io.ballerina.semver.checker.util.DiffUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public class NodeListDiffImpl<T extends Node>
implements NodeListDiff<List<T>> {
    protected final List<T> newNodes;
    protected final List<T> oldNodes;
    protected DiffType diffType;
    protected DiffKind diffKind;
    protected SemverImpact versionImpact;
    protected final List<Diff> childDiffs;
    private String message;

    private NodeListDiffImpl(List<T> newNodes, List<T> oldNodes) {
        this(newNodes, oldNodes, DiffType.UNKNOWN, SemverImpact.UNKNOWN);
    }

    private NodeListDiffImpl(List<T> newNodes, List<T> oldNodes, DiffType diffType, SemverImpact versionImpact) {
        this.newNodes = newNodes;
        this.oldNodes = oldNodes;
        this.diffType = diffType;
        this.versionImpact = versionImpact;
        this.childDiffs = new ArrayList<Diff>();
        this.message = null;
    }

    @Override
    public Optional<List<T>> getNewNodes() {
        return Optional.ofNullable(this.newNodes);
    }

    @Override
    public Optional<List<T>> getOldNodes() {
        return Optional.ofNullable(this.oldNodes);
    }

    @Override
    public DiffType getType() {
        return this.diffType;
    }

    private void setType(DiffType diffType) {
        this.diffType = diffType;
    }

    @Override
    public DiffKind getKind() {
        return this.diffKind;
    }

    private void setKind(DiffKind diffKind) {
        this.diffKind = diffKind;
    }

    @Override
    public SemverImpact getVersionImpact() {
        return this.versionImpact;
    }

    private void setVersionImpact(SemverImpact versionImpact) {
        this.versionImpact = versionImpact;
    }

    @Override
    public void computeVersionImpact() {
        if (this.versionImpact == SemverImpact.UNKNOWN) {
            this.versionImpact = this.childDiffs.stream().map(Diff::getVersionImpact).max(Comparator.comparingInt(SemverImpact::getRank)).orElse(SemverImpact.UNKNOWN);
        }
    }

    @Override
    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }

    private void setMessage(String message) {
        this.message = message;
    }

    @Override
    public List<Diff> getChildDiffs() {
        return this.childDiffs;
    }

    @Override
    public List<Diff> getChildDiffs(SemverImpact versionImpact) {
        ArrayList<Diff> filteredDiffs = new ArrayList<Diff>();
        for (Diff diff : this.childDiffs) {
            if (diff.getChildDiffs().isEmpty()) {
                if (diff.getVersionImpact() != versionImpact) continue;
                filteredDiffs.add(diff);
                continue;
            }
            for (Diff childDiff : diff.getChildDiffs()) {
                filteredDiffs.addAll(childDiff.getChildDiffs(versionImpact));
            }
        }
        return filteredDiffs;
    }

    @Override
    public String getAsString() {
        StringBuilder sb = new StringBuilder();
        if (this.childDiffs == null || this.childDiffs.isEmpty()) {
            sb.append(DiffUtils.stringifyDiff(this));
        } else {
            this.childDiffs.forEach(diff -> sb.append(diff.getAsString()));
        }
        return sb.toString();
    }

    public JsonArray getAsJson() {
        JsonArray childArray = new JsonArray();
        if (this.childDiffs == null || this.childDiffs.isEmpty()) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("type", (JsonElement)new JsonPrimitive(this.getType().name().toLowerCase(Locale.ENGLISH)));
            jsonObject.add("versionImpact", (JsonElement)new JsonPrimitive(this.getVersionImpact().name().toLowerCase(Locale.ENGLISH)));
            if (this.getKind() == null || this.getKind() == DiffKind.UNKNOWN) {
                jsonObject.add("kind", (JsonElement)new JsonPrimitive(DiffUtils.getDiffTypeName(this)));
            } else {
                jsonObject.add("kind", (JsonElement)new JsonPrimitive(this.getKind().toString()));
            }
            if (this.getMessage().isPresent()) {
                jsonObject.add("message", (JsonElement)new JsonPrimitive(this.getMessage().get()));
            }
            childArray.add((JsonElement)jsonObject);
        } else {
            for (Diff diff : this.childDiffs) {
                JsonElement jsonDiff = diff.getAsJson();
                if (jsonDiff.isJsonArray()) {
                    childArray.addAll((JsonArray)jsonDiff);
                    continue;
                }
                childArray.add(diff.getAsJson());
            }
        }
        return childArray;
    }

    public static class Builder<T extends Node>
    implements NodeDiffBuilder {
        private final NodeListDiffImpl<T> nodeListDiff;

        public Builder(List<T> newNodes, List<T> oldNodes) {
            this.nodeListDiff = new NodeListDiffImpl<T>(newNodes, oldNodes);
        }

        public Optional<NodeListDiffImpl<?>> build() {
            if (!this.nodeListDiff.getChildDiffs().isEmpty()) {
                if (this.nodeListDiff.getVersionImpact() == SemverImpact.UNKNOWN) {
                    this.nodeListDiff.computeVersionImpact();
                }
                this.nodeListDiff.setType(DiffType.MODIFIED);
                return Optional.of(this.nodeListDiff);
            }
            if (this.nodeListDiff.getType() == DiffType.NEW || this.nodeListDiff.getType() == DiffType.REMOVED || this.nodeListDiff.getMessage().isPresent()) {
                return Optional.of(this.nodeListDiff);
            }
            return Optional.empty();
        }

        @Override
        public NodeDiffBuilder withKind(DiffKind diffKind) {
            this.nodeListDiff.setKind(diffKind);
            return this;
        }

        @Override
        public NodeDiffBuilder withType(DiffType diffType) {
            this.nodeListDiff.setType(diffType);
            return this;
        }

        @Override
        public NodeDiffBuilder withVersionImpact(SemverImpact versionImpact) {
            this.nodeListDiff.setVersionImpact(versionImpact);
            return this;
        }

        @Override
        public NodeDiffBuilder withMessage(String message) {
            this.nodeListDiff.setMessage(message);
            return this;
        }

        @Override
        public NodeDiffBuilder withChildDiff(Diff childDiff) {
            this.nodeListDiff.childDiffs.add(childDiff);
            return this;
        }

        @Override
        public NodeDiffBuilder withChildDiffs(Collection<? extends Diff> childDiffs) {
            this.nodeListDiff.childDiffs.addAll(childDiffs);
            return null;
        }
    }
}

