/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker.diff;

import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.semver.checker.diff.Diff;
import io.ballerina.semver.checker.diff.DiffKind;
import io.ballerina.semver.checker.diff.DiffType;
import io.ballerina.semver.checker.diff.NodeDiffBuilder;
import io.ballerina.semver.checker.diff.NodeDiffImpl;
import io.ballerina.semver.checker.diff.SemverImpact;
import java.util.Collection;
import java.util.Optional;

public class TypeDefinitionDiff
extends NodeDiffImpl<TypeDefinitionNode> {
    private TypeDefinitionDiff(TypeDefinitionNode newNode, TypeDefinitionNode oldNode) {
        super(newNode, oldNode, DiffKind.TYPE_DEFINITION);
    }

    @Override
    public void computeVersionImpact() {
        boolean isPublic = this.isPublic();
        if (this.newNode != null && this.oldNode == null) {
            this.versionImpact = isPublic ? SemverImpact.MINOR : SemverImpact.PATCH;
        } else if (this.newNode == null && this.oldNode != null) {
            this.versionImpact = isPublic ? SemverImpact.MAJOR : SemverImpact.PATCH;
        } else if (isPublic) {
            super.computeVersionImpact();
        } else {
            this.versionImpact = SemverImpact.PATCH;
        }
    }

    private boolean isPublic() {
        boolean isNewPublic = this.newNode != null && ((TypeDefinitionNode)this.newNode).visibilityQualifier().stream().anyMatch(qualifier -> qualifier.kind() == SyntaxKind.PUBLIC_KEYWORD);
        boolean isOldPublic = this.oldNode != null && ((TypeDefinitionNode)this.oldNode).visibilityQualifier().stream().anyMatch(qualifier -> qualifier.kind() == SyntaxKind.PUBLIC_KEYWORD);
        return isNewPublic || isOldPublic;
    }

    public static class Builder
    extends NodeDiffImpl.Builder<TypeDefinitionNode> {
        private final TypeDefinitionDiff typeDefDiff;

        public Builder(TypeDefinitionNode newNode, TypeDefinitionNode oldNode) {
            super(newNode, oldNode);
            this.typeDefDiff = new TypeDefinitionDiff(newNode, oldNode);
        }

        @Override
        public Optional<TypeDefinitionDiff> build() {
            if (!this.typeDefDiff.getChildDiffs().isEmpty()) {
                this.typeDefDiff.computeVersionImpact();
                this.typeDefDiff.setType(DiffType.MODIFIED);
                return Optional.of(this.typeDefDiff);
            }
            if (this.typeDefDiff.getType() == DiffType.NEW || this.typeDefDiff.getType() == DiffType.REMOVED) {
                return Optional.of(this.typeDefDiff);
            }
            return Optional.empty();
        }

        @Override
        public NodeDiffBuilder withType(DiffType diffType) {
            this.typeDefDiff.setType(diffType);
            return this;
        }

        @Override
        public NodeDiffBuilder withVersionImpact(SemverImpact versionImpact) {
            this.typeDefDiff.setVersionImpact(versionImpact);
            return this;
        }

        @Override
        public NodeDiffBuilder withMessage(String message) {
            this.typeDefDiff.setMessage(message);
            return this;
        }

        @Override
        public NodeDiffBuilder withChildDiff(Diff childDiff) {
            this.typeDefDiff.childDiffs.add(childDiff);
            return this;
        }

        @Override
        public NodeDiffBuilder withChildDiffs(Collection<? extends Diff> childDiffs) {
            this.typeDefDiff.childDiffs.addAll(childDiffs);
            return this;
        }
    }
}

