/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.observe.observers;

import io.ballerina.runtime.observability.BallerinaObserver;
import io.ballerina.runtime.observability.ObserverContext;
import io.ballerina.runtime.observability.metrics.DefaultMetricRegistry;
import io.ballerina.runtime.observability.metrics.Gauge;
import io.ballerina.runtime.observability.metrics.MetricId;
import io.ballerina.runtime.observability.metrics.MetricRegistry;
import io.ballerina.runtime.observability.metrics.StatisticConfig;
import io.ballerina.runtime.observability.metrics.Tag;
import java.io.PrintStream;
import java.time.Duration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BallerinaMetricsObserver
implements BallerinaObserver {
    private static final String PROPERTY_START_TIME = "_observation_start_time_";
    private static final String PROPERTY_IN_PROGRESS_COUNTER = "_observation_in_progress_counter_";
    private static final PrintStream consoleError = System.err;
    private static final MetricRegistry metricRegistry = DefaultMetricRegistry.getInstance();
    private static final StatisticConfig[] responseTimeStatisticConfigs = new StatisticConfig[]{StatisticConfig.builder().expiry(Duration.ofSeconds(10L)).percentiles(StatisticConfig.DEFAULT.getPercentiles()).build(), StatisticConfig.builder().expiry(Duration.ofMinutes(1L)).percentiles(StatisticConfig.DEFAULT.getPercentiles()).build(), StatisticConfig.builder().expiry(Duration.ofMinutes(5L)).percentiles(StatisticConfig.DEFAULT.getPercentiles()).build()};

    public void startServerObservation(ObserverContext observerContext) {
        this.startObservation(observerContext);
    }

    public void startClientObservation(ObserverContext observerContext) {
        this.startObservation(observerContext);
    }

    public void stopServerObservation(ObserverContext observerContext) {
        if (!observerContext.isStarted()) {
            return;
        }
        this.stopObservation(observerContext);
    }

    public void stopClientObservation(ObserverContext observerContext) {
        if (!observerContext.isStarted()) {
            return;
        }
        this.stopObservation(observerContext);
    }

    private void startObservation(ObserverContext observerContext) {
        observerContext.addProperty(PROPERTY_START_TIME, (Object)System.nanoTime());
        Set tags = observerContext.getAllTags();
        try {
            Gauge inProgressGauge = metricRegistry.gauge(new MetricId("inprogress_requests", "In-progress requests", tags), new StatisticConfig[0]);
            inProgressGauge.increment();
            observerContext.addProperty(PROPERTY_IN_PROGRESS_COUNTER, (Object)inProgressGauge);
        }
        catch (RuntimeException e) {
            this.handleError("inprogress_requests", tags, e);
        }
    }

    private void stopObservation(ObserverContext observerContext) {
        HashSet<Tag> tags = new HashSet<Tag>();
        Map customTags = observerContext.customMetricTags;
        if (customTags != null) {
            tags.addAll(customTags.values());
        }
        tags.addAll(observerContext.getAllTags());
        Integer statusCode = (Integer)observerContext.getProperty("_http_status_code_");
        if (statusCode != null && statusCode > 0) {
            tags.add(Tag.of((String)"http.status_code_group", (String)(statusCode / 100 + "xx")));
        }
        try {
            Long startTime = (Long)observerContext.getProperty(PROPERTY_START_TIME);
            long duration = System.nanoTime() - startTime;
            ((Gauge)observerContext.getProperty(PROPERTY_IN_PROGRESS_COUNTER)).decrement();
            metricRegistry.gauge(new MetricId("response_time_seconds", "Response time", tags), responseTimeStatisticConfigs).setValue((double)duration / 1.0E9);
            metricRegistry.counter(new MetricId("response_time_nanoseconds_total", "Total response response time for all requests", tags)).increment(duration);
            metricRegistry.counter(new MetricId("requests_total", "Total number of requests", tags)).increment();
            if (statusCode != null && 400 <= statusCode && statusCode < 600) {
                metricRegistry.counter(new MetricId("response_errors_total", "Total number of response errors", tags)).increment();
            }
        }
        catch (RuntimeException e) {
            this.handleError("multiple metrics", tags, e);
        }
    }

    private void handleError(String metricName, Set<Tag> tags, RuntimeException e) {
        consoleError.println("error: error collecting metrics for " + metricName + " with tags " + String.valueOf(tags) + ": " + e.getMessage());
    }
}

