/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.sequencemodelgenerator.core;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.Project;
import io.ballerina.sequencemodelgenerator.core.CommonUtil;
import io.ballerina.sequencemodelgenerator.core.ParticipantManager;
import io.ballerina.sequencemodelgenerator.core.model.Diagram;
import io.ballerina.sequencemodelgenerator.core.model.Participant;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextRange;
import java.nio.file.Path;
import java.util.List;

public class ModelGenerator {
    public static Diagram getSequenceDiagramModel(Project project, LineRange lineRange, SemanticModel semanticModel) {
        Path filePath = CommonUtil.getFilePath(project, lineRange.fileName(), null);
        SyntaxTree syntaxTree = CommonUtil.getSyntaxTree(project, filePath);
        TextDocument textDocument = syntaxTree.textDocument();
        int start = textDocument.textPositionFrom(lineRange.startLine());
        int end = textDocument.textPositionFrom(lineRange.endLine());
        TextRange textRange = TextRange.from((int)start, (int)(end - start));
        NonTerminalNode rootNode = CommonUtil.getNode(syntaxTree, textRange);
        String moduleName = semanticModel.symbol((Node)rootNode).flatMap(CommonUtil::getModuleName).orElse(".");
        ParticipantManager.initialize(semanticModel, project);
        ParticipantManager participantManager = ParticipantManager.getInstance();
        participantManager.generateParticipant(semanticModel, (Node)rootNode, moduleName);
        List<Participant> participants = participantManager.getParticipants();
        return new Diagram(participants, lineRange);
    }
}

