/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.sequencemodelgenerator.core;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.Project;
import io.ballerina.sequencemodelgenerator.core.CommonUtil;
import io.ballerina.sequencemodelgenerator.core.ParticipantAnalyzer;
import io.ballerina.sequencemodelgenerator.core.model.Participant;
import io.ballerina.tools.diagnostics.Location;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParticipantManager {
    private static ParticipantManager instance = null;
    private final Map<String, String> cache = new HashMap<String, String>();
    private final List<Participant> participants = new ArrayList<Participant>();
    private final SemanticModel semanticModel;
    private final Project project;
    private final String packageName;

    private ParticipantManager(SemanticModel semanticModel, Project project) {
        this.semanticModel = semanticModel;
        this.project = project;
        this.packageName = project.currentPackage().packageName().toString();
    }

    public static void initialize(SemanticModel semanticModel, Project project) {
        instance = new ParticipantManager(semanticModel, project);
    }

    public static ParticipantManager getInstance() {
        return instance;
    }

    public String getParticipantId(Node name) {
        String participantId = this.cache.get(name.toString());
        if (participantId != null) {
            return participantId;
        }
        try {
            Symbol symbol = (Symbol)this.semanticModel.symbol(name).orElseThrow();
            Location location = (Location)symbol.getLocation().orElseThrow();
            String fileName = location.lineRange().fileName();
            String moduleName = CommonUtil.getModuleName(symbol).orElseThrow();
            Path filePath = CommonUtil.getFilePath(this.project, fileName, moduleName.equals(this.packageName) ? null : moduleName);
            SyntaxTree syntaxTree = CommonUtil.getSyntaxTree(this.project, filePath);
            SemanticModel moduleSemanticModel = CommonUtil.getSemanticModel(this.project, filePath);
            NonTerminalNode participantNode = CommonUtil.getNode(syntaxTree, location.textRange());
            return this.generateParticipant(moduleSemanticModel, (Node)participantNode, moduleName);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public String generateParticipant(SemanticModel moduleSemanticModel, Node participantNode, String moduleName) {
        ParticipantAnalyzer participantAnalyzer = new ParticipantAnalyzer(moduleSemanticModel, moduleName);
        participantNode.accept((NodeVisitor)participantAnalyzer);
        Participant participant = participantAnalyzer.getParticipant();
        this.participants.add(participant);
        String participantId = participant.id();
        this.cache.put(participant.name(), participantId);
        return participantId;
    }

    public List<Participant> getParticipants() {
        return this.participants;
    }
}

