/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.datamapper;

import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.ballerinalang.datamapper.AIDataMapperCodeActionUtil;
import org.ballerinalang.datamapper.config.ClientExtendedConfigImpl;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagnosticBasedCodeActionProvider;
import org.ballerinalang.langserver.config.LSClientConfigHolder;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.TextEdit;

public class AIDataMapperCodeAction
implements DiagnosticBasedCodeActionProvider {
    public static final String NAME = "AI Data Mapper";
    public static final String GENERATE_MAPPING_FUNCTION = "Generate mapping function";

    public boolean validate(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        return CodeActionNodeValidator.validate((Node)context.nodeAtRange());
    }

    public List<CodeAction> getCodeActions(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        ArrayList<CodeAction> actions = new ArrayList<CodeAction>();
        if (diagnostic.message().toLowerCase(Locale.ROOT).contains("incompatible types")) {
            AIDataMapperCodeAction.getAIDataMapperCommand(diagnostic, positionDetails, context).map(actions::add);
        }
        return actions;
    }

    public String getName() {
        return NAME;
    }

    public boolean isEnabled(LanguageServerContext serverContext) {
        return ((ClientExtendedConfigImpl)((Object)LSClientConfigHolder.getInstance((LanguageServerContext)serverContext).getConfigAs(ClientExtendedConfigImpl.class))).getDataMapper().isEnabled();
    }

    private static Optional<CodeAction> getAIDataMapperCommand(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        try {
            Optional typeSymbol = positionDetails.diagnosticProperty(1);
            if (typeSymbol.isEmpty()) {
                return Optional.empty();
            }
            TypeDescKind typeDescriptor = CommonUtil.getRawType((TypeSymbol)((TypeSymbol)typeSymbol.get())).typeKind();
            if (typeDescriptor == TypeDescKind.UNION || typeDescriptor == TypeDescKind.RECORD || typeDescriptor == TypeDescKind.COMPILATION_ERROR) {
                List<TextEdit> fEdits = AIDataMapperCodeActionUtil.getInstance().getAIDataMapperCodeActionEdits(positionDetails, context, diagnostic);
                if (fEdits.isEmpty()) {
                    return Optional.empty();
                }
                CodeAction action = CodeActionUtil.createCodeAction((String)GENERATE_MAPPING_FUNCTION, fEdits, (String)context.fileUri(), (String)"quickfix");
                return Optional.of(action);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Optional.empty();
    }
}

