/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.datamapper.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.ballerinalang.datamapper.utils.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpClientRequest {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientRequest.class);
    private static final int DEFAULT_READ_TIMEOUT = 30000;
    private static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    private static final CheckedFunction<BufferedReader, String> DEFAULT_RESPONSE_BUILDER = bufferedReader -> {
        String line;
        StringBuilder sb = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            sb.append(line);
        }
        return sb.toString();
    };

    private HttpClientRequest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponse doPost(String endpoint, String postBody, Map<String, String> headers) throws IOException {
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = HttpClientRequest.getURLConnection(endpoint);
            HttpClientRequest.setHeadersAndMethod(urlConnection, headers, "POST");
            try (OutputStream out = urlConnection.getOutputStream();
                 OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);){
                writer.write(postBody);
            }
            HttpResponse httpResponse = HttpClientRequest.buildResponse(urlConnection);
            return httpResponse;
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    private static HttpURLConnection getURLConnection(String requestUrl) throws IOException {
        URL url = new URL(requestUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.setReadTimeout(30000);
        conn.setConnectTimeout(15000);
        conn.setDoInput(true);
        conn.setUseCaches(true);
        conn.setAllowUserInteraction(false);
        return conn;
    }

    private static void setHeadersAndMethod(HttpURLConnection conn, Map<String, String> headers, String method) throws ProtocolException {
        for (Map.Entry<String, String> e : headers.entrySet()) {
            conn.addRequestProperty(e.getKey(), e.getValue());
        }
        conn.setRequestMethod(method);
    }

    private static HttpResponse buildResponse(HttpURLConnection conn) throws IOException {
        return HttpClientRequest.buildResponse(conn, DEFAULT_RESPONSE_BUILDER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpResponse buildResponse(HttpURLConnection conn, CheckedFunction<BufferedReader, String> responseBuilder) throws IOException {
        String responseData;
        try (BufferedReader rd = null;
             InputStreamReader inputStreamReader = new InputStreamReader(conn.getInputStream(), Charset.defaultCharset());){
            rd = new BufferedReader(inputStreamReader);
            responseData = responseBuilder.apply(rd);
        }
        HttpResponse httpResponse = new HttpResponse(responseData, conn.getResponseCode());
        return httpResponse;
    }

    @FunctionalInterface
    public static interface CheckedFunction<T, R> {
        public R apply(T var1) throws IOException;
    }
}

