/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.array;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BFunctionPointer;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import io.ballerina.runtime.internal.utils.ValueComparisonUtils;
import org.ballerinalang.langlib.array.utils.ArrayUtils;

public final class Sort {
    private Sort() {
    }

    public static BArray sort(Environment env, BArray arr, Object direction, Object func) {
        ArrayUtils.checkIsArrayOnlyOperation(TypeUtils.getImpliedType((Type)arr.getType()), "sort()");
        BFunctionPointer function = (BFunctionPointer)func;
        Object[][] sortArr = new Object[arr.size()][2];
        Object[][] sortArrClone = new Object[arr.size()][2];
        if (function != null) {
            for (i = 0; i < arr.size(); ++i) {
                sortArr[i][0] = function.call(env.getRuntime(), new Object[]{arr.get((long)i)});
                sortArr[i][1] = arr.get((long)i);
            }
        } else {
            for (i = 0; i < arr.size(); ++i) {
                Object object = arr.get((long)i);
                sortArr[i][1] = object;
                sortArr[i][0] = object;
            }
        }
        Sort.mergesort(sortArr, sortArrClone, 0, sortArr.length - 1, direction.toString());
        BArray sortedArray = ValueCreator.createArrayValue((ArrayType)TypeCreator.createArrayType((Type)arr.getElementType()));
        for (int k = 0; k < sortArr.length; ++k) {
            sortedArray.add((long)k, sortArr[k][1]);
        }
        return sortedArray;
    }

    private static void mergesort(Object[][] input, Object[][] aux, int lo, int hi, String direction) {
        if (hi <= lo) {
            return;
        }
        int mid = lo + (hi - lo) / 2;
        Sort.mergesort(input, aux, lo, mid, direction);
        Sort.mergesort(input, aux, mid + 1, hi, direction);
        Sort.merge(input, aux, lo, mid, hi, direction);
    }

    private static void merge(Object[][] input, Object[][] aux, int lo, int mid, int hi, String direction) {
        if (hi + 1 - lo >= 0) {
            System.arraycopy(input, lo, aux, lo, hi + 1 - lo);
        }
        int i = lo;
        int j = mid + 1;
        for (int k = lo; k <= hi; ++k) {
            try {
                int index = i > mid ? j++ : (j > hi ? i++ : (direction.equals("ascending") && ValueComparisonUtils.compareValues((Object)aux[j][0], (Object)aux[i][0], (String)direction) < 0 ? j++ : (direction.equals("descending") && ValueComparisonUtils.compareValues((Object)aux[i][0], (Object)aux[j][0], (String)direction) < 0 ? j++ : i++)));
                input[k] = aux[index];
                continue;
            }
            catch (BError error) {
                throw ErrorCreator.createError((BString)ErrorReasons.getModulePrefixedReason((String)"lang.array", (String)"SortOperationError"), (BMap)((BMap)error.getDetails()));
            }
        }
    }
}

