/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.map;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import io.ballerina.runtime.internal.utils.MapUtils;
import org.ballerinalang.langlib.map.util.MapLibUtils;

public final class Remove {
    private Remove() {
    }

    public static Object remove(BMap<?, ?> m, BString k) {
        Type type = TypeUtils.getImpliedType((Type)m.getType());
        MapUtils.checkIsMapOnlyOperation((Type)type, (String)"remove()");
        MapLibUtils.validateRequiredFieldForRecord(m, k.getValue());
        if (m.containsKey((Object)k)) {
            try {
                return m.remove((Object)k);
            }
            catch (BError e) {
                Object errorMsgDetail = "failed to remove element from map";
                if (ErrorHelper.hasMessageDetail((BError)e)) {
                    errorMsgDetail = (String)errorMsgDetail + ": " + ((BMap)e.getDetails()).get((Object)StringUtils.fromString((String)"message")).toString();
                }
                throw ErrorCreator.createError((BString)e.getErrorMessage(), (BString)StringUtils.fromString((String)errorMsgDetail));
            }
        }
        throw ErrorCreator.createError((BString)ErrorReasons.MAP_KEY_NOT_FOUND_ERROR, (BMap)ErrorHelper.getErrorDetails((ErrorCodes)ErrorCodes.KEY_NOT_FOUND_ERROR, (Object[])new Object[]{k}));
    }
}

