/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.crypto;

import io.ballerina.stdlib.crypto.CryptoUtils;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Locale;
import org.bouncycastle.util.encoders.Base64;

public class PasswordUtils {
    public static final int MIN_WORK_FACTOR = 4;
    public static final int MAX_WORK_FACTOR = 31;
    public static final int DEFAULT_WORK_FACTOR = 12;
    public static final int SALT_LENGTH = 16;
    public static final int DEFAULT_ITERATIONS = 3;
    public static final int DEFAULT_MEMORY = 65536;
    public static final int DEFAULT_PARALLELISM = 4;
    public static final int HASH_LENGTH = 32;
    public static final SecureRandom SECURE_RANDOM = new SecureRandom();

    private PasswordUtils() {
    }

    public static Object validateWorkFactor(long workFactor) {
        if (workFactor < 4L || workFactor > 31L) {
            return CryptoUtils.createError(String.format("Work factor must be between %d and %d", 4, 31));
        }
        return null;
    }

    public static byte[] generateRandomSalt() {
        byte[] salt = new byte[16];
        SECURE_RANDOM.nextBytes(salt);
        return salt;
    }

    public static String formatBCryptHash(long workFactor, byte[] saltAndHash) {
        String saltAndHashBase64 = Base64.toBase64String((byte[])saltAndHash);
        return String.format(Locale.ROOT, "$2a$%02d$%s", workFactor, saltAndHashBase64);
    }

    public static String formatArgon2Hash(long memory, long iterations, long parallelism, String saltBase64, String hashBase64) {
        return String.format(Locale.ROOT, "$argon2id$v=19$m=%d,t=%d,p=%d$%s$%s", memory, iterations, parallelism, saltBase64, hashBase64);
    }

    public static String formatArgon2Salt(long memory, long iterations, long parallelism, String saltBase64) {
        return String.format(Locale.ROOT, "$argon2id$v=19$m=%d,t=%d,p=%d$%s", memory, iterations, parallelism, saltBase64);
    }

    public static byte[] combine(byte[] salt, byte[] hash) {
        byte[] combined = new byte[salt.length + hash.length];
        System.arraycopy(salt, 0, combined, 0, salt.length);
        System.arraycopy(hash, 0, combined, salt.length, hash.length);
        return combined;
    }

    public static boolean constantTimeArrayEquals(byte[] a, byte[] b) {
        return MessageDigest.isEqual(a, b);
    }
}

