/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.crypto;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.Queue;

public class SequentialBufferedPipe {
    Queue<Byte> buffer = new LinkedList<Byte>();
    boolean outputClosed = false;

    public InputStream getInputStream() {
        return new InputStream(){

            @Override
            public int read() {
                if (SequentialBufferedPipe.this.buffer.isEmpty()) {
                    if (SequentialBufferedPipe.this.outputClosed) {
                        return -1;
                    }
                    return 0;
                }
                return SequentialBufferedPipe.this.buffer.poll() & 0xFF;
            }

            @Override
            public int read(byte[] b, int off, int len) {
                int i;
                if (SequentialBufferedPipe.this.buffer.isEmpty()) {
                    if (SequentialBufferedPipe.this.outputClosed) {
                        return -1;
                    }
                    return 0;
                }
                for (i = 0; i < len && !SequentialBufferedPipe.this.buffer.isEmpty(); ++i) {
                    b[off + i] = SequentialBufferedPipe.this.buffer.poll();
                }
                return i;
            }
        };
    }

    public OutputStream getOutputStream() {
        return new OutputStream(){

            @Override
            public void write(int b) {
                SequentialBufferedPipe.this.buffer.add((byte)b);
            }

            @Override
            public void write(byte[] b, int off, int len) {
                for (int i = off; i < off + len; ++i) {
                    SequentialBufferedPipe.this.buffer.add(b[i]);
                }
            }

            @Override
            public void close() {
                SequentialBufferedPipe.this.outputClosed = true;
            }
        };
    }
}

