/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.crypto.nativeimpl;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.stdlib.crypto.CryptoUtils;
import io.ballerina.stdlib.crypto.nativeimpl.ModuleUtils;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.jcajce.SecretKeyWithEncapsulation;

public class Kem {
    private Kem() {
    }

    public static Object encapsulateMlKem768(BMap<?, ?> publicKey) {
        CryptoUtils.addBCProvider();
        PublicKey key = (PublicKey)publicKey.getNativeData("NATIVE_DATA_PUBLIC_KEY");
        Object encapsulate = CryptoUtils.generateEncapsulated("ML-KEM-768", key, "BC");
        if (encapsulate instanceof SecretKeyWithEncapsulation) {
            SecretKeyWithEncapsulation secretKeyWithEncapsulation = (SecretKeyWithEncapsulation)encapsulate;
            return Kem.getEncapsulationResultRecord(secretKeyWithEncapsulation);
        }
        return encapsulate;
    }

    public static Object encapsulateRsaKem(BMap<?, ?> publicKey) {
        PublicKey key = (PublicKey)publicKey.getNativeData("NATIVE_DATA_PUBLIC_KEY");
        Object encapsulate = CryptoUtils.generateRsaEncapsulated(key);
        if (encapsulate instanceof SecretKeyWithEncapsulation) {
            SecretKeyWithEncapsulation secretKeyWithEncapsulation = (SecretKeyWithEncapsulation)encapsulate;
            return Kem.getEncapsulationResultRecord(secretKeyWithEncapsulation);
        }
        return encapsulate;
    }

    private static Object getEncapsulationResultRecord(SecretKeyWithEncapsulation secretKeyWithEncapsulation) {
        BMap encapsulationResultRecord = ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"EncapsulationResult");
        encapsulationResultRecord.put((Object)StringUtils.fromString((String)"sharedSecret"), (Object)ValueCreator.createArrayValue((byte[])secretKeyWithEncapsulation.getEncoded()));
        encapsulationResultRecord.put((Object)StringUtils.fromString((String)"encapsulatedSecret"), (Object)ValueCreator.createArrayValue((byte[])secretKeyWithEncapsulation.getEncapsulation()));
        return encapsulationResultRecord;
    }

    public static Object decapsulateMlKem768(BArray inputValue, BMap<?, ?> privateKey) {
        CryptoUtils.addBCProvider();
        byte[] input = inputValue.getBytes();
        PrivateKey key = (PrivateKey)privateKey.getNativeData("NATIVE_DATA_PRIVATE_KEY");
        return CryptoUtils.extractSecret(input, "ML-KEM-768", key, "BC");
    }

    public static Object decapsulateRsaKem(BArray inputValue, BMap<?, ?> privateKey) {
        byte[] input = inputValue.getBytes();
        PrivateKey key = (PrivateKey)privateKey.getNativeData("NATIVE_DATA_PRIVATE_KEY");
        return CryptoUtils.extractRsaSecret(input, key);
    }
}

