/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api;

import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.concurrent.StrandMetadata;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.observability.ObserveUtils;
import io.ballerina.runtime.observability.ObserverContext;
import io.ballerina.stdlib.http.api.BallerinaConnectorException;
import io.ballerina.stdlib.http.api.HTTPInterceptorServicesRegistry;
import io.ballerina.stdlib.http.api.HTTPServicesRegistry;
import io.ballerina.stdlib.http.api.HttpCallableUnitCallback;
import io.ballerina.stdlib.http.api.HttpDispatcher;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpRequestInterceptorUnitCallback;
import io.ballerina.stdlib.http.api.HttpResource;
import io.ballerina.stdlib.http.api.HttpService;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.InterceptorResource;
import io.ballerina.stdlib.http.transport.contract.HttpConnectorListener;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BallerinaHTTPConnectorListener
implements HttpConnectorListener {
    private static final Logger log = LoggerFactory.getLogger(BallerinaHTTPConnectorListener.class);
    protected static final String HTTP_RESOURCE = "httpResource";
    protected final HTTPServicesRegistry httpServicesRegistry;
    protected final List<HTTPInterceptorServicesRegistry> httpInterceptorServicesRegistries;
    protected final BMap endpointConfig;
    protected final Object listenerLevelInterceptors;

    public BallerinaHTTPConnectorListener(HTTPServicesRegistry httpServicesRegistry, List<HTTPInterceptorServicesRegistry> httpInterceptorServicesRegistries, BMap endpointConfig, Object interceptors) {
        this.httpInterceptorServicesRegistries = httpInterceptorServicesRegistries;
        this.httpServicesRegistry = httpServicesRegistry;
        this.endpointConfig = endpointConfig;
        this.listenerLevelInterceptors = interceptors;
    }

    @Override
    public void onMessage(HttpCarbonMessage inboundMessage) {
        if (Objects.isNull(inboundMessage.getProperty("INTERCEPTOR_SERVICES_REGISTRIES"))) {
            this.setTargetServiceToInboundMsg(inboundMessage);
        }
        List interceptorServicesRegistries = (List)inboundMessage.getProperty("INTERCEPTOR_SERVICES_REGISTRIES");
        try {
            if (this.executeInterceptorServices(interceptorServicesRegistries, inboundMessage)) {
                return;
            }
        }
        catch (Exception ex) {
            HttpRequestInterceptorUnitCallback callback = new HttpRequestInterceptorUnitCallback(inboundMessage, this.httpServicesRegistry.getRuntime(), this);
            callback.invokeErrorInterceptors(HttpUtil.createError(ex), true);
            return;
        }
        if (inboundMessage.isInterceptorError()) {
            HttpRequestInterceptorUnitCallback callback = new HttpRequestInterceptorUnitCallback(inboundMessage, this.httpServicesRegistry.getRuntime(), this);
            callback.returnErrorResponse(inboundMessage.getProperty("INTERCEPTOR_SERVICE_ERROR"));
        } else {
            try {
                this.executeMainResourceOnMessage(inboundMessage);
            }
            catch (Exception ex) {
                HttpCallableUnitCallback callback = new HttpCallableUnitCallback(inboundMessage, this.httpServicesRegistry.getRuntime());
                callback.invokeErrorInterceptors(HttpUtil.createError(ex), true);
            }
        }
    }

    private boolean executeInterceptorServices(List<HTTPInterceptorServicesRegistry> interceptorServicesRegistries, HttpCarbonMessage inboundMessage) {
        int interceptorServiceIndex;
        int n = interceptorServiceIndex = inboundMessage.getProperty("REQUEST_INTERCEPTOR_INDEX") == null ? 0 : (Integer)inboundMessage.getProperty("REQUEST_INTERCEPTOR_INDEX");
        while (interceptorServiceIndex < interceptorServicesRegistries.size()) {
            HTTPInterceptorServicesRegistry interceptorServicesRegistry = interceptorServicesRegistries.get(interceptorServiceIndex);
            if (!interceptorServicesRegistry.getServicesType().equals(inboundMessage.getRequestInterceptorServiceState())) {
                ++interceptorServiceIndex;
                continue;
            }
            InterceptorResource interceptorResource = this.findInterceptorResource(interceptorServicesRegistry, inboundMessage);
            if (this.checkForInterceptorDataBinding(inboundMessage, interceptorServiceIndex, interceptorResource)) {
                return true;
            }
            ++interceptorServiceIndex;
            if (interceptorResource == null) continue;
            inboundMessage.removeProperty("WAIT_FOR_FULL_REQUEST");
            inboundMessage.setProperty("REQUEST_INTERCEPTOR_INDEX", interceptorServiceIndex);
            inboundMessage.setProperty("INTERCEPTOR_SERVICE", true);
            this.extractPropertiesAndStartInterceptorResourceExecution(inboundMessage, interceptorResource, interceptorServicesRegistry);
            return true;
        }
        inboundMessage.removeProperty("REQUEST_INTERCEPTOR_INDEX");
        return false;
    }

    private boolean checkForInterceptorDataBinding(HttpCarbonMessage inboundMessage, int interceptorServiceIndex, InterceptorResource interceptorResource) {
        if (!inboundMessage.isLastHttpContentArrived() && HttpDispatcher.shouldDiffer(interceptorResource) && inboundMessage.isAccessedInNonInterceptorService()) {
            inboundMessage.setProperty("WAIT_FOR_FULL_REQUEST", true);
            inboundMessage.setProperty("INTERCEPTOR_SERVICE", true);
            inboundMessage.setProperty("REQUEST_INTERCEPTOR_INDEX", interceptorServiceIndex);
            inboundMessage.removeInboundContentListener();
            return true;
        }
        return false;
    }

    @Override
    public void onError(Throwable throwable) {
        log.warn("Error in HTTP server connector: {}", (Object)throwable.getMessage());
    }

    protected void extractPropertiesAndStartResourceExecution(HttpCarbonMessage inboundMessage, HttpResource httpResource) {
        boolean isTransactionInfectable = httpResource.isTransactionInfectable();
        Map<String, Object> properties = this.collectRequestProperties(inboundMessage, isTransactionInfectable);
        Object[] signatureParams = HttpDispatcher.getSignatureParameters(httpResource, inboundMessage, (BMap<BString, Object>)this.endpointConfig, this.httpServicesRegistry.getRuntime());
        if (ObserveUtils.isObservabilityEnabled()) {
            ObserverContext observerContext = new ObserverContext();
            observerContext.setManuallyClosed(true);
            observerContext.setObjectName("http");
            HashMap httpHeaders = new HashMap();
            inboundMessage.getHeaders().forEach(entry -> httpHeaders.put((String)entry.getKey(), (String)entry.getValue()));
            observerContext.addProperty("_trace_properties_", httpHeaders);
            observerContext.addTag("http.method", inboundMessage.getHttpMethod());
            observerContext.addTag("protocol", (String)inboundMessage.getProperty("PROTOCOL"));
            observerContext.addTag("http.url", httpResource.getAbsoluteResourcePath());
            properties.put("__observer_context__", observerContext);
            inboundMessage.setProperty("observabilityContext", observerContext);
        }
        Runtime runtime = this.httpServicesRegistry.getRuntime();
        HttpCallableUnitCallback callback = new HttpCallableUnitCallback(inboundMessage, runtime, httpResource, this.httpServicesRegistry.isPossibleLastService());
        BObject service = httpResource.getParentService().getBalService();
        String resourceName = httpResource.getName();
        ObjectType serviceType = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)service));
        Thread.startVirtualThread(() -> {
            boolean isIsolated = serviceType.isIsolated() && serviceType.isIsolated(resourceName);
            StrandMetadata metaData = new StrandMetadata(isIsolated, properties);
            try {
                Object result = runtime.callMethod(service, resourceName, metaData, signatureParams);
                callback.handleResult(result);
            }
            catch (BError error) {
                callback.handlePanic(error);
            }
        });
    }

    protected boolean accessed(HttpCarbonMessage inboundMessage) {
        return inboundMessage.getProperty(HTTP_RESOURCE) != null;
    }

    private Map<String, Object> collectRequestProperties(HttpCarbonMessage inboundMessage, boolean isInfectable) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (inboundMessage.getProperty("SRC_HANDLER") != null) {
            Object srcHandler = inboundMessage.getProperty("SRC_HANDLER");
            properties.put("SRC_HANDLER", srcHandler);
        }
        String txnId = inboundMessage.getHeader("x-b7a-xid");
        String registerAtUrl = inboundMessage.getHeader("x-b7a-register-at");
        String trxInfo = inboundMessage.getHeader("x-b7a-info-record");
        if (!isInfectable && txnId != null) {
            log.error("Infection attempt on resource with transactionInfectable=false, txnId:" + txnId);
            throw new BallerinaConnectorException("Cannot create transaction context: resource is not transactionInfectable");
        }
        if (isInfectable && txnId != null && registerAtUrl != null && trxInfo != null) {
            properties.put("globalTransactionId", txnId);
            properties.put("transactionUrl", registerAtUrl);
            properties.put("transactionInfo", trxInfo);
        }
        properties.put("REMOTE_ADDRESS", inboundMessage.getProperty("REMOTE_ADDRESS"));
        properties.put("ORIGIN_HOST", inboundMessage.getHeader("ORIGIN_HOST"));
        properties.put("POOLED_BYTE_BUFFER_FACTORY", inboundMessage.getHeader("POOLED_BYTE_BUFFER_FACTORY"));
        properties.put("INBOUND_MESSAGE", inboundMessage);
        return properties;
    }

    protected void extractPropertiesAndStartInterceptorResourceExecution(HttpCarbonMessage inboundMessage, InterceptorResource resource, HTTPInterceptorServicesRegistry registry) {
        Map<String, Object> properties = this.collectRequestProperties(inboundMessage, true);
        Runtime runtime = registry.getRuntime();
        Object[] signatureParams = HttpDispatcher.getSignatureParameters(resource, inboundMessage, (BMap<BString, Object>)this.endpointConfig, registry.getRuntime());
        HttpRequestInterceptorUnitCallback callback = new HttpRequestInterceptorUnitCallback(inboundMessage, runtime, this);
        BObject service = resource.getParentService().getBalService();
        String resourceName = resource.getName();
        inboundMessage.removeProperty("INTERCEPTOR_SERVICE_ERROR");
        ObjectType serviceType = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)service));
        Thread.startVirtualThread(() -> {
            boolean isIsolated = serviceType.isIsolated() && serviceType.isIsolated(resourceName);
            StrandMetadata metaData = new StrandMetadata(isIsolated, properties);
            try {
                Object result = runtime.callMethod(service, resourceName, metaData, signatureParams);
                callback.handleResult(result);
            }
            catch (BError error) {
                callback.handlePanic(error);
            }
        });
    }

    protected void executeMainResourceOnMessage(HttpCarbonMessage inboundMessage) {
        if (this.accessed(inboundMessage)) {
            inboundMessage.removeProperty("WAIT_FOR_FULL_REQUEST");
            HttpResource httpResource = (HttpResource)inboundMessage.getProperty(HTTP_RESOURCE);
            this.extractPropertiesAndStartResourceExecution(inboundMessage, httpResource);
            return;
        }
        HttpResource httpResource = HttpDispatcher.findResource(this.httpServicesRegistry, inboundMessage);
        if (!inboundMessage.isLastHttpContentArrived() && HttpDispatcher.shouldDiffer(httpResource) && inboundMessage.isAccessedInNonInterceptorService()) {
            inboundMessage.setProperty(HTTP_RESOURCE, httpResource);
            inboundMessage.setProperty("WAIT_FOR_FULL_REQUEST", true);
            inboundMessage.removeInboundContentListener();
            return;
        }
        try {
            if (httpResource != null) {
                inboundMessage.removeProperty("INTERCEPTOR_SERVICE");
                this.extractPropertiesAndStartResourceExecution(inboundMessage, httpResource);
            }
        }
        catch (BallerinaConnectorException ex) {
            HttpCallableUnitCallback callback = new HttpCallableUnitCallback(inboundMessage, this.httpServicesRegistry.getRuntime());
            callback.invokeErrorInterceptors(HttpUtil.createError(ex), true);
        }
    }

    private InterceptorResource findInterceptorResource(HTTPInterceptorServicesRegistry interceptorServicesRegistry, HttpCarbonMessage inboundMessage) {
        try {
            return HttpDispatcher.findInterceptorResource(interceptorServicesRegistry, inboundMessage);
        }
        catch (Exception e) {
            if (e.getMessage().startsWith("no matching resource found for path") || e.getMessage().startsWith("Method not allowed") || e.getMessage().startsWith("no matching service found for path")) {
                return null;
            }
            throw e;
        }
    }

    private void setTargetServiceToInboundMsg(HttpCarbonMessage inboundMessage) {
        inboundMessage.setProperty("INTERCEPTOR_SERVICES_REGISTRIES", this.httpInterceptorServicesRegistries);
        inboundMessage.setProperty("INTERCEPTORS", this.listenerLevelInterceptors);
        try {
            HttpService targetService = HttpDispatcher.findService(this.httpServicesRegistry, inboundMessage, true);
            inboundMessage.setProperty("TARGET_SERVICE", targetService.getBalService());
            if (targetService.hasInterceptors()) {
                inboundMessage.setProperty("INTERCEPTORS", targetService.getBalInterceptorServicesArray());
                inboundMessage.setProperty("INTERCEPTOR_SERVICES_REGISTRIES", targetService.getInterceptorServicesRegistries());
            }
        }
        catch (Exception e) {
            HttpService singleService;
            if (((BArray)this.listenerLevelInterceptors).size() == 1 && e instanceof BError && ((BError)((Object)e)).getType().getName().equals(HttpErrorType.INTERNAL_SERVICE_NOT_FOUND_ERROR.getErrorName()) && (singleService = HttpDispatcher.findSingleService(this.httpServicesRegistry)) != null && singleService.hasInterceptors()) {
                inboundMessage.setProperty("INTERCEPTORS", singleService.getBalInterceptorServicesArray());
                inboundMessage.setProperty("INTERCEPTOR_SERVICES_REGISTRIES", singleService.getInterceptorServicesRegistries());
            }
            inboundMessage.setProperty("TARGET_SERVICE", (Object)HttpUtil.createError(e));
        }
    }
}

