/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.FunctionType;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.TypeId;
import io.ballerina.runtime.api.utils.JsonUtils;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BRefValue;
import io.ballerina.runtime.api.values.BStreamingJson;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BXmlItem;
import io.ballerina.runtime.api.values.BXmlSequence;
import io.ballerina.runtime.observability.ObserveUtils;
import io.ballerina.runtime.observability.ObserverContext;
import io.ballerina.stdlib.http.api.BallerinaConnectorException;
import io.ballerina.stdlib.http.api.CompressionConfigState;
import io.ballerina.stdlib.http.api.CorsHeaderGenerator;
import io.ballerina.stdlib.http.api.DefaultHttpWsConnectorFactoryHolder;
import io.ballerina.stdlib.http.api.HTTPInterceptorServicesRegistry;
import io.ballerina.stdlib.http.api.HTTPServicesRegistry;
import io.ballerina.stdlib.http.api.HttpConstants;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpResourceArguments;
import io.ballerina.stdlib.http.api.HttpService;
import io.ballerina.stdlib.http.api.Resource;
import io.ballerina.stdlib.http.api.Service;
import io.ballerina.stdlib.http.api.ValueCreatorUtils;
import io.ballerina.stdlib.http.api.client.caching.RequestCacheControlObj;
import io.ballerina.stdlib.http.api.client.caching.ResponseCacheControlObj;
import io.ballerina.stdlib.http.api.nativeimpl.ModuleUtils;
import io.ballerina.stdlib.http.api.nativeimpl.pipelining.PipeliningHandler;
import io.ballerina.stdlib.http.api.service.endpoint.Register;
import io.ballerina.stdlib.http.transport.contract.HttpResponseFuture;
import io.ballerina.stdlib.http.transport.contract.HttpWsConnectorFactory;
import io.ballerina.stdlib.http.transport.contract.config.ChunkConfig;
import io.ballerina.stdlib.http.transport.contract.config.ForwardedExtensionConfig;
import io.ballerina.stdlib.http.transport.contract.config.InboundMsgSizeValidationConfig;
import io.ballerina.stdlib.http.transport.contract.config.KeepAliveConfig;
import io.ballerina.stdlib.http.transport.contract.config.ListenerConfiguration;
import io.ballerina.stdlib.http.transport.contract.config.Parameter;
import io.ballerina.stdlib.http.transport.contract.config.ProxyServerConfiguration;
import io.ballerina.stdlib.http.transport.contract.config.SenderConfiguration;
import io.ballerina.stdlib.http.transport.contract.config.SslConfiguration;
import io.ballerina.stdlib.http.transport.contract.exceptions.ClientConnectorException;
import io.ballerina.stdlib.http.transport.contract.exceptions.ConnectionTimedOutException;
import io.ballerina.stdlib.http.transport.contract.exceptions.EndpointTimeOutException;
import io.ballerina.stdlib.http.transport.contract.exceptions.PromiseRejectedException;
import io.ballerina.stdlib.http.transport.contract.exceptions.ServerConnectorException;
import io.ballerina.stdlib.http.transport.contract.exceptions.SslException;
import io.ballerina.stdlib.http.transport.contractimpl.sender.channel.pool.ConnectionManager;
import io.ballerina.stdlib.http.transport.contractimpl.sender.channel.pool.PoolConfiguration;
import io.ballerina.stdlib.http.transport.message.Http2PushPromise;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.ballerina.stdlib.http.transport.message.HttpMessageDataStreamer;
import io.ballerina.stdlib.io.utils.IOConstants;
import io.ballerina.stdlib.io.utils.IOUtils;
import io.ballerina.stdlib.mime.util.EntityBodyChannel;
import io.ballerina.stdlib.mime.util.EntityBodyHandler;
import io.ballerina.stdlib.mime.util.EntityHeaderHandler;
import io.ballerina.stdlib.mime.util.EntityWrapper;
import io.ballerina.stdlib.mime.util.HeaderUtil;
import io.ballerina.stdlib.mime.util.MimeConstants;
import io.ballerina.stdlib.mime.util.MimeUtil;
import io.ballerina.stdlib.mime.util.MultipartDataSource;
import io.ballerina.stdlib.mime.util.MultipartDecoder;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    public static final boolean TRUE = true;
    public static final boolean FALSE = false;
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private static final String METHOD_ACCESSED = "isMethodAccessed";
    private static final String IO_EXCEPTION_OCCURRED = "I/O exception occurred";
    private static final String CHUNKING_CONFIG = "chunking_config";
    private static final String ILLEGAL_FUNCTION_INVOKED = "illegal respond: response has already been sent";
    private static final String JAVA_CONFIG_TLS_NAMED_GROUPS = "jdk.tls.namedGroups";
    private static final String[] DEFAULT_NAMED_GROUPS = new String[]{"X25519MLKEM768", "x25519", "secp256r1", "secp384r1", "secp521r1"};

    public static BObject createNewEntity(BObject httpMessageStruct) {
        BObject entity = ValueCreatorUtils.createEntityObject();
        HttpCarbonMessage httpCarbonMessage = HttpUtil.getCarbonMsg(httpMessageStruct, HttpUtil.createHttpCarbonMessage(HttpUtil.isRequest(httpMessageStruct)));
        entity.addNativeData("entity_byte_channel", null);
        httpMessageStruct.addNativeData("http_headers", (Object)httpCarbonMessage.getHeaders());
        httpMessageStruct.addNativeData("http_trailer_headers", (Object)httpCarbonMessage.getTrailerHeaders());
        httpMessageStruct.set(HttpUtil.isRequest(httpMessageStruct) ? MimeConstants.REQUEST_ENTITY_FIELD : MimeConstants.RESPONSE_ENTITY_FIELD, (Object)entity);
        httpMessageStruct.addNativeData("is_byte_channel_set", (Object)false);
        return entity;
    }

    public static void setEntity(BObject messageObj, BObject entityObj, boolean isRequest, boolean updateAllHeaders) {
        HttpCarbonMessage httpCarbonMessage = HttpUtil.getCarbonMsg(messageObj, HttpUtil.createHttpCarbonMessage(isRequest));
        String contentType = MimeUtil.getContentTypeWithParameters((BObject)entityObj);
        if (EntityBodyHandler.checkEntityBodyAvailability((BObject)entityObj)) {
            httpCarbonMessage.waitAndReleaseAllEntities();
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
            ((HttpHeaders)messageObj.getNativeData("http_headers")).set(HttpHeaderNames.CONTENT_TYPE.toString(), (Object)contentType);
        }
        httpCarbonMessage.setProperty("EntityObj", entityObj);
        messageObj.set(isRequest ? MimeConstants.REQUEST_ENTITY_FIELD : MimeConstants.RESPONSE_ENTITY_FIELD, (Object)entityObj);
        messageObj.addNativeData("is_byte_channel_set", (Object)EntityBodyHandler.checkEntityBodyAvailability((BObject)entityObj));
        if (updateAllHeaders) {
            HttpUtil.setEntityHeaderToTransportHeader(entityObj, (HttpHeaders)messageObj.getNativeData("http_headers"));
        }
    }

    public static BObject getEntity(BObject messageObj, boolean isRequest, boolean entityBodyRequired, boolean entityHeadersRequired) {
        BObject entity = (BObject)messageObj.get(isRequest ? MimeConstants.REQUEST_ENTITY_FIELD : MimeConstants.RESPONSE_ENTITY_FIELD);
        HttpCarbonMessage httpCarbonMessage = HttpUtil.getCarbonMsg(messageObj, HttpUtil.createHttpCarbonMessage(isRequest));
        boolean byteChannelAlreadySet = false;
        if (messageObj.getNativeData("is_byte_channel_set") != null) {
            byteChannelAlreadySet = (Boolean)messageObj.getNativeData("is_byte_channel_set");
        }
        if (entityBodyRequired && !byteChannelAlreadySet) {
            HttpUtil.populateEntityBody(messageObj, entity, isRequest, entityHeadersRequired);
        }
        if (entityHeadersRequired) {
            HttpUtil.populateEntityHeaders(messageObj, entity);
        }
        httpCarbonMessage.setProperty("EntityObj", entity);
        return entity;
    }

    public static void populateEntityBody(BObject messageObj, BObject entityObj, boolean request, boolean streaming) {
        HttpCarbonMessage httpCarbonMessage = HttpUtil.getCarbonMsg(messageObj, HttpUtil.createHttpCarbonMessage(request));
        String contentType = httpCarbonMessage.getHeader(HttpHeaderNames.CONTENT_TYPE.toString());
        if (httpCarbonMessage.getProperty("EntityObj") != null) {
            messageObj.set(request ? MimeConstants.REQUEST_ENTITY_FIELD : MimeConstants.RESPONSE_ENTITY_FIELD, (Object)entityObj);
            messageObj.addNativeData("is_byte_channel_set", (Object)true);
            entityObj.addNativeData("transport_message", (Object)httpCarbonMessage);
            return;
        }
        if (MimeUtil.isNotNullAndEmpty((String)contentType) && contentType.startsWith("multipart/") && !streaming) {
            MultipartDecoder.parseBody((BObject)entityObj, (String)contentType, (InputStream)new HttpMessageDataStreamer(httpCarbonMessage).getInputStream());
        } else {
            long contentLength = HttpUtil.extractContentLength(httpCarbonMessage);
            if (contentLength > 0L) {
                if (streaming) {
                    entityObj.addNativeData("entity_byte_channel", (Object)new EntityWrapper(new EntityBodyChannel(new HttpMessageDataStreamer(httpCarbonMessage).getInputStream())));
                } else {
                    entityObj.addNativeData("transport_message", (Object)httpCarbonMessage);
                }
            } else if (HttpHeaderValues.CHUNKED.toString().equals(httpCarbonMessage.getHeader(HttpHeaderNames.TRANSFER_ENCODING.toString()))) {
                entityObj.addNativeData("transport_message", (Object)httpCarbonMessage);
            }
        }
        messageObj.set(request ? MimeConstants.REQUEST_ENTITY_FIELD : MimeConstants.RESPONSE_ENTITY_FIELD, (Object)entityObj);
        messageObj.addNativeData("is_byte_channel_set", (Object)true);
    }

    private static void populateEntityHeaders(BObject messageObj, BObject entity) {
        HttpCarbonMessage httpCarbonMessage = (HttpCarbonMessage)messageObj.getNativeData("transport_message");
        if (httpCarbonMessage == null) {
            return;
        }
        BMap headers = EntityHeaderHandler.getNewHeaderMap();
        HttpHeaders httpHeaders = httpCarbonMessage.getHeaders();
        for (String key : httpHeaders.names()) {
            String[] values = httpHeaders.getAll(key).toArray(new String[0]);
            headers.put((Object)StringUtils.fromString((String)key.toLowerCase(Locale.getDefault())), (Object)StringUtils.fromStringArray((String[])values));
        }
        entity.set(MimeConstants.HEADERS_MAP_FIELD, (Object)headers);
        TreeSet distinctNames = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        distinctNames.addAll(httpHeaders.names());
        entity.set(MimeConstants.HEADER_NAMES_ARRAY_FIELD, (Object)StringUtils.fromStringSet(distinctNames));
    }

    public static long extractContentLength(HttpCarbonMessage httpCarbonMessage) {
        long contentLength = -1L;
        String lengthStr = httpCarbonMessage.getHeader(HttpHeaderNames.CONTENT_LENGTH.toString());
        try {
            long l = contentLength = lengthStr != null ? Long.parseLong(lengthStr) : contentLength;
            if (contentLength == -1L) {
                contentLength = httpCarbonMessage.countMessageLengthTill(1L);
            }
        }
        catch (NumberFormatException e) {
            throw MimeUtil.createError((String)"InvalidContentLengthError", (String)"Invalid content length");
        }
        return contentLength;
    }

    public static BObject extractEntity(BObject request) {
        Object isEntityBodyAvailable = request.getNativeData("is_byte_channel_set");
        if (isEntityBodyAvailable == null || !((Boolean)isEntityBodyAvailable).booleanValue()) {
            return null;
        }
        return (BObject)request.get(HttpUtil.isRequest(request) ? MimeConstants.REQUEST_ENTITY_FIELD : MimeConstants.RESPONSE_ENTITY_FIELD);
    }

    public static void closeMessageOutputStream(OutputStream messageOutputStream) {
        try {
            if (messageOutputStream != null) {
                messageOutputStream.close();
            }
        }
        catch (IOException e) {
            log.error("Couldn't close message output stream", (Throwable)e);
        }
    }

    public static void prepareOutboundResponse(BObject connectionObj, HttpCarbonMessage inboundRequestMsg, HttpCarbonMessage outboundResponseMsg, BObject outboundResponseObj) {
        HttpUtil.checkEntityAvailability(outboundResponseObj);
        HttpUtil.addCorsHeaders(inboundRequestMsg, outboundResponseMsg);
        HttpUtil.enrichOutboundMessage(outboundResponseMsg, outboundResponseObj);
        Service httpService = (Service)connectionObj.getNativeData("HTTP_SERVICE");
        if (httpService != null) {
            HttpUtil.setCompressionHeaders(httpService.getCompressionConfig(), inboundRequestMsg, outboundResponseMsg);
            if (HttpUtil.hasEventStreamContentType(outboundResponseMsg)) {
                HttpUtil.setChunkingHeader("ALWAYS", outboundResponseMsg);
            } else {
                HttpUtil.setChunkingHeader(httpService.getChunkingConfig(), outboundResponseMsg);
            }
            if (httpService.getMediaTypeSubtypePrefix() != null) {
                HttpUtil.setMediaTypeSubtypePrefix(httpService.getMediaTypeSubtypePrefix(), outboundResponseMsg);
            }
        }
    }

    private static void setMediaTypeSubtypePrefix(String mediaTypeSubtypePrefix, HttpCarbonMessage responseMsg) {
        String existingMediaType = responseMsg.getHeader(HttpHeaderNames.CONTENT_TYPE.toString());
        if (Objects.isNull(existingMediaType)) {
            return;
        }
        String specificMediaType = HttpUtil.getMediaTypeWithPrefix(mediaTypeSubtypePrefix, existingMediaType);
        if (Objects.nonNull(specificMediaType)) {
            responseMsg.setHeader(HttpHeaderNames.CONTENT_TYPE.toString(), specificMediaType);
        }
    }

    public static String getMediaTypeWithPrefix(String mediaTypeSubtypePrefix, String existingMediaType) {
        String specificMediaType = null;
        int index = existingMediaType.indexOf("/");
        if (index > 0) {
            String[] mediaType = existingMediaType.split("/");
            specificMediaType = mediaType[0] + "/" + mediaTypeSubtypePrefix + "+" + mediaType[1];
        }
        return specificMediaType;
    }

    private static void addCorsHeaders(HttpCarbonMessage requestMsg, HttpCarbonMessage responseMsg) {
        if (requestMsg.getHeader(HttpHeaderNames.ORIGIN.toString()) != null) {
            CorsHeaderGenerator.process(requestMsg, responseMsg, true);
        }
    }

    public static HttpResponseFuture sendOutboundResponse(HttpCarbonMessage requestMsg, HttpCarbonMessage responseMsg) {
        HttpResponseFuture responseFuture;
        try {
            responseFuture = requestMsg.respond(responseMsg);
        }
        catch (ServerConnectorException e) {
            throw new BallerinaConnectorException("Error occurred during response", e);
        }
        return responseFuture;
    }

    public static HttpResponseFuture pushResponse(HttpCarbonMessage requestMsg, HttpCarbonMessage pushResponse, Http2PushPromise pushPromise) {
        HttpResponseFuture responseFuture;
        try {
            responseFuture = requestMsg.pushResponse(pushResponse, pushPromise);
        }
        catch (ServerConnectorException e) {
            throw new BallerinaConnectorException("Error occurred while sending a server push message", e);
        }
        return responseFuture;
    }

    public static HttpResponseFuture pushPromise(HttpCarbonMessage requestMsg, Http2PushPromise pushPromise) {
        HttpResponseFuture responseFuture;
        try {
            responseFuture = requestMsg.pushPromise(pushPromise);
        }
        catch (ServerConnectorException e) {
            throw new BallerinaConnectorException("Error occurred during response", e);
        }
        return responseFuture;
    }

    public static void handleFailure(HttpCarbonMessage requestMessage, String errorMsg) {
        int statusCode = HttpUtil.getStatusCode(requestMessage, errorMsg);
        PipeliningHandler.sendPipelinedResponse(requestMessage, HttpUtil.createErrorMessage(errorMsg, statusCode));
    }

    public static void handleFailure(HttpCarbonMessage requestMessage, BError error) {
        String errorMsg = HttpUtil.getErrorMessage(error);
        int statusCode = HttpUtil.getStatusCode(requestMessage, errorMsg);
        error.printStackTrace();
        PipeliningHandler.sendPipelinedResponse(requestMessage, HttpUtil.createErrorMessage(errorMsg, statusCode));
    }

    private static String getErrorMessage(BError error) {
        BMap errorDetails = (BMap)error.getDetails();
        if (errorDetails != null && errorDetails.get((Object)HttpConstants.HTTP_ERROR_MESSAGE) != null) {
            return errorDetails.get((Object)HttpConstants.HTTP_ERROR_MESSAGE).toString();
        }
        return error.getErrorMessage().getValue();
    }

    private static int getStatusCode(HttpCarbonMessage requestMessage, String errorMsg) {
        Integer carbonStatusCode = requestMessage.getHttpStatusCode();
        if (carbonStatusCode == null) {
            log.error(errorMsg);
            return HttpResponseStatus.INTERNAL_SERVER_ERROR.code();
        }
        return carbonStatusCode;
    }

    public static BError createError(Exception ex) {
        if (ex.getMessage() != null) {
            return ErrorCreator.createError((Throwable)ex);
        }
        return ErrorCreator.createError((BString)StringUtils.fromString((String)""));
    }

    public static HttpCarbonMessage createErrorMessage(String payload, int statusCode) {
        HttpCarbonMessage response = HttpUtil.createHttpCarbonMessage(false);
        response.waitAndReleaseAllEntities();
        if (payload != null) {
            response.addHttpContent((HttpContent)new DefaultLastHttpContent(Unpooled.wrappedBuffer((byte[])payload.getBytes(CharsetUtil.UTF_8))));
        } else {
            response.addHttpContent((HttpContent)new DefaultLastHttpContent());
        }
        HttpUtil.setHttpStatusCodes(statusCode, response);
        return response;
    }

    private static void setHttpStatusCodes(int statusCode, HttpCarbonMessage response) {
        HttpHeaders httpHeaders = response.getHeaders();
        httpHeaders.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain");
        response.setHttpStatusCode(statusCode);
    }

    public static BError getError(Throwable throwable) {
        if (throwable.getCause() instanceof ClientConnectorException) {
            return HttpUtil.createHttpError(throwable);
        }
        if (throwable.getMessage() == null) {
            return HttpUtil.createHttpError(IO_EXCEPTION_OCCURRED);
        }
        return HttpUtil.createHttpError(throwable.getMessage());
    }

    public static BError createHttpError(String errorMessage) {
        HttpErrorType errorType = HttpUtil.getErrorType(errorMessage);
        return HttpUtil.createHttpError(errorMessage, errorType);
    }

    public static BError createHttpError(Throwable throwable) {
        if (throwable instanceof EndpointTimeOutException) {
            return HttpUtil.createHttpError(throwable.getMessage(), HttpErrorType.IDLE_TIMEOUT_TRIGGERED);
        }
        if (throwable instanceof SslException) {
            return HttpUtil.createHttpError(throwable.getMessage(), HttpErrorType.SSL_ERROR);
        }
        if (throwable instanceof PromiseRejectedException) {
            return HttpUtil.createHttpError(throwable.getMessage(), HttpErrorType.HTTP2_CLIENT_ERROR);
        }
        if (throwable instanceof ConnectionTimedOutException) {
            BError cause = HttpUtil.createErrorCause(throwable.getMessage(), IOConstants.ErrorCode.ConnectionTimedOut.errorCode(), IOUtils.getIOPackage());
            return HttpUtil.createHttpError("Something wrong with the connection", HttpErrorType.GENERIC_CLIENT_ERROR, cause);
        }
        if (throwable instanceof ClientConnectorException) {
            BError cause = HttpUtil.createErrorCause(throwable.getMessage(), IOConstants.ErrorCode.GenericError.errorCode(), IOUtils.getIOPackage());
            return HttpUtil.createHttpError("Something wrong with the connection", HttpErrorType.CLIENT_CONNECTOR_ERROR, cause);
        }
        if (throwable instanceof NullPointerException) {
            return HttpUtil.createHttpError("Exception occurred: null", HttpErrorType.GENERIC_CLIENT_ERROR, HttpUtil.createHttpError(throwable.toString()));
        }
        return HttpUtil.createHttpError(throwable.getMessage(), HttpErrorType.CLIENT_ERROR);
    }

    public static BError createHttpError(String message, HttpErrorType errorType) {
        return HttpUtil.createHttpError(errorType, message, null, null);
    }

    public static BError createHttpError(String message, HttpErrorType errorType, BError cause) {
        return HttpUtil.createHttpError(errorType, message, cause, null);
    }

    public static BError createHttpError(HttpErrorType errorType, String message, BError cause, BMap<BString, Object> detail) {
        return ErrorCreator.createError((Module)ModuleUtils.getHttpPackage(), (String)errorType.getErrorName(), (BString)StringUtils.fromString((String)message), (BError)cause, detail);
    }

    public static BError createHttpStatusCodeError(HttpErrorType errorType, String message) {
        return HttpUtil.createHttpStatusCodeError(errorType, message, null, null);
    }

    public static BError createHttpStatusCodeError(HttpErrorType errorType, String message, String body, BError cause) {
        BMap detail = ValueCreator.createRecordValue((Module)ModuleUtils.getHttpStatusPackage(), (String)"ErrorDetail");
        if (body != null) {
            detail.put((Object)HttpConstants.ERROR_DETAIL_BODY, (Object)StringUtils.fromString((String)body));
        }
        return HttpUtil.createHttpError(errorType, message, cause, (BMap<BString, Object>)detail);
    }

    private static HttpErrorType getErrorType(String errorMessage) {
        if (errorMessage.contains("Idle timeout triggered")) {
            return HttpErrorType.IDLE_TIMEOUT_TRIGGERED;
        }
        switch (errorMessage) {
            case "Remote host closed the connection before initiating inbound response": {
                return HttpErrorType.INIT_INBOUND_RESPONSE_FAILED;
            }
            case "Remote host closed the connection while reading inbound response headers": {
                return HttpErrorType.READING_INBOUND_RESPONSE_HEADERS_FAILED;
            }
            case "Remote host closed the connection while reading inbound response body": {
                return HttpErrorType.READING_INBOUND_RESPONSE_BODY_FAILED;
            }
            case "Remote host closed the connection before initiating outbound request": {
                return HttpErrorType.INIT_OUTBOUND_REQUEST_FAILED;
            }
            case "Remote host closed the connection while writing outbound request headers": {
                return HttpErrorType.WRITING_OUTBOUND_REQUEST_HEADER_FAILED;
            }
            case "Remote host closed the connection while writing outbound request entity body": {
                return HttpErrorType.WRITING_OUTBOUND_REQUEST_BODY_FAILED;
            }
            case "Remote client closed the connection before initiating inbound request": {
                return HttpErrorType.INIT_INBOUND_REQUEST_FAILED;
            }
            case "Remote client closed the connection while reading inbound request headers": {
                return HttpErrorType.READING_INBOUND_REQUEST_HEADER_FAILED;
            }
            case "Remote client closed the connection while reading inbound request entity body": {
                return HttpErrorType.READING_INBOUND_REQUEST_BODY_FAILED;
            }
            case "Remote client closed the connection before initiating outbound response": {
                return HttpErrorType.INIT_OUTBOUND_RESPONSE_FAILED;
            }
            case "Remote client closed the connection while writing outbound response headers": {
                return HttpErrorType.WRITING_OUTBOUND_RESPONSE_HEADERS_FAILED;
            }
            case "Remote client closed the connection while writing outbound response entity body": {
                return HttpErrorType.WRITING_OUTBOUND_RESPONSE_BODY_FAILED;
            }
            case "Remote client closed the connection before initiating 100 continue response": {
                return HttpErrorType.INIT_100_CONTINUE_RESPONSE_FAILED;
            }
            case "Remote client closed the connection while writing 100 continue response": {
                return HttpErrorType.WRITING_100_CONTINUE_RESPONSE_FAILED;
            }
            case "Promised stream is already rejected or stream is no longer valid": {
                return HttpErrorType.HTTP2_CLIENT_ERROR;
            }
        }
        return HttpErrorType.GENERIC_CLIENT_ERROR;
    }

    private static BError createErrorCause(String message, String errorTypeId, Module packageName) {
        return ErrorCreator.createDistinctError((String)errorTypeId, (Module)packageName, (BString)StringUtils.fromString((String)message));
    }

    public static HttpCarbonMessage getCarbonMsg(BObject objectValue, HttpCarbonMessage defaultMsg) {
        HttpCarbonMessage httpCarbonMessage = (HttpCarbonMessage)objectValue.getNativeData("transport_message");
        if (httpCarbonMessage != null) {
            return httpCarbonMessage;
        }
        HttpUtil.addCarbonMsg(objectValue, defaultMsg);
        return defaultMsg;
    }

    public static Http2PushPromise getPushPromise(BObject pushPromiseObj, Http2PushPromise defaultPushPromise) {
        Http2PushPromise pushPromise = (Http2PushPromise)pushPromiseObj.getNativeData("transport_push_promise");
        if (pushPromise != null) {
            return pushPromise;
        }
        pushPromiseObj.addNativeData("transport_push_promise", (Object)defaultPushPromise);
        return defaultPushPromise;
    }

    public static void populatePushPromiseStruct(BObject pushPromiseObj, Http2PushPromise pushPromise) {
        pushPromiseObj.addNativeData("transport_push_promise", (Object)pushPromise);
        pushPromiseObj.set(HttpConstants.PUSH_PROMISE_PATH_FIELD, (Object)StringUtils.fromString((String)pushPromise.getPath()));
        pushPromiseObj.set(HttpConstants.PUSH_PROMISE_METHOD_FIELD, (Object)StringUtils.fromString((String)pushPromise.getMethod()));
    }

    public static Http2PushPromise createHttpPushPromise(BObject pushPromiseObj) {
        String path;
        String method = pushPromiseObj.get(HttpConstants.PUSH_PROMISE_METHOD_FIELD).toString();
        if (method == null || method.isEmpty()) {
            method = "GET";
        }
        if ((path = pushPromiseObj.get(HttpConstants.PUSH_PROMISE_PATH_FIELD).toString()) == null || path.isEmpty()) {
            path = "/";
        }
        return new Http2PushPromise(method, path);
    }

    public static void addCarbonMsg(BObject struct, HttpCarbonMessage httpCarbonMessage) {
        struct.addNativeData("transport_message", (Object)httpCarbonMessage);
    }

    public static void populateInboundRequest(BObject inboundRequest, BObject entity, HttpCarbonMessage inboundRequestMsg) {
        inboundRequest.addNativeData("transport_message", (Object)inboundRequestMsg);
        inboundRequest.addNativeData("Request", (Object)true);
        BMap<BString, Object> mutualSslRecord = ValueCreatorUtils.createHTTPRecordValue("MutualSslHandshake");
        mutualSslRecord.put((Object)HttpConstants.REQUEST_MUTUAL_SSL_HANDSHAKE_STATUS, (Object)StringUtils.fromString((String)((String)inboundRequestMsg.getProperty("MUTUAL_SSL_HANDSHAKE_RESULT"))));
        mutualSslRecord.put((Object)HttpConstants.MUTUAL_SSL_CERTIFICATE, (Object)StringUtils.fromString((String)((String)inboundRequestMsg.getProperty("BASE_64_ENCODED_CERT"))));
        inboundRequest.set(HttpConstants.REQUEST_MUTUAL_SSL_HANDSHAKE_FIELD, mutualSslRecord);
        HttpUtil.enrichWithInboundRequestInfo(inboundRequest, inboundRequestMsg);
        HttpUtil.enrichWithInboundRequestHeaders(inboundRequest, inboundRequestMsg);
        HttpUtil.populateEntity(inboundRequest, entity, inboundRequestMsg);
        inboundRequest.set(MimeConstants.REQUEST_ENTITY_FIELD, (Object)entity);
        inboundRequest.addNativeData("is_byte_channel_set", (Object)EntityBodyHandler.checkEntityBodyAvailability((BObject)entity));
        String cacheControlHeader = inboundRequestMsg.getHeader(HttpHeaderNames.CACHE_CONTROL.toString());
        if (cacheControlHeader != null) {
            BObject cacheControlObj = ValueCreatorUtils.createRequestCacheControlObject();
            RequestCacheControlObj requestCacheControl = new RequestCacheControlObj(cacheControlObj);
            requestCacheControl.populateStruct(cacheControlHeader);
            inboundRequest.set(HttpConstants.REQUEST_CACHE_CONTROL_FIELD, (Object)requestCacheControl.getObj());
        }
    }

    private static void enrichWithInboundRequestHeaders(BObject inboundRequestObj, HttpCarbonMessage inboundRequestMsg) {
        if (inboundRequestMsg.getHeader(HttpHeaderNames.USER_AGENT.toString()) != null) {
            BString agent = StringUtils.fromString((String)inboundRequestMsg.getHeader(HttpHeaderNames.USER_AGENT.toString()));
            inboundRequestObj.set(HttpConstants.REQUEST_USER_AGENT_FIELD, (Object)agent);
        }
    }

    private static void enrichWithInboundRequestInfo(BObject inboundRequestObj, HttpCarbonMessage inboundRequestMsg) {
        inboundRequestObj.set(HttpConstants.REQUEST_RAW_PATH_FIELD, (Object)StringUtils.fromString((String)inboundRequestMsg.getRequestUrl()));
        inboundRequestObj.set(HttpConstants.REQUEST_METHOD_FIELD, (Object)StringUtils.fromString((String)inboundRequestMsg.getHttpMethod()));
        inboundRequestObj.set(HttpConstants.REQUEST_VERSION_FIELD, (Object)StringUtils.fromString((String)inboundRequestMsg.getHttpVersion()));
        HttpResourceArguments resourceArgValues = (HttpResourceArguments)inboundRequestMsg.getProperty("RESOURCE_ARGS");
        if (resourceArgValues != null && resourceArgValues.getMap().get("EXTRA_PATH_INFO") != null) {
            Map<Integer, String> extraPath = resourceArgValues.getMap().get("EXTRA_PATH_INFO");
            inboundRequestObj.set(HttpConstants.REQUEST_EXTRA_PATH_INFO_FIELD, (Object)StringUtils.fromString((String)extraPath.get(0)));
        }
    }

    public static void enrichHttpCallerWithNativeData(BObject caller, HttpCarbonMessage inboundMsg, BMap config) {
        caller.addNativeData("transport_message", (Object)inboundMsg);
        caller.set(HttpConstants.HTTP_CONNECTOR_CONFIG_FIELD, (Object)config);
    }

    public static void enrichHttpCallerWithConnectionInfo(BObject httpCaller, HttpCarbonMessage inboundMsg, Resource resource, BMap config) {
        Object remoteSocketAddress = inboundMsg.getProperty("REMOTE_ADDRESS");
        httpCaller.set(HttpConstants.SERVICE_ENDPOINT_CONFIG_FIELD, (Object)config);
        httpCaller.addNativeData("HTTP_SERVICE", (Object)resource.getParentService());
        httpCaller.addNativeData("remoteSocketAddress", remoteSocketAddress);
    }

    public static boolean isDefaultResource(String resourceAccessor) {
        return "default".equals(resourceAccessor.toLowerCase(Locale.getDefault()));
    }

    public static void populateInboundResponse(BObject inboundResponse, BObject entity, HttpCarbonMessage inboundResponseMsg) {
        String cacheControlHeader;
        inboundResponse.addNativeData("transport_message", (Object)inboundResponseMsg);
        int statusCode = inboundResponseMsg.getHttpStatusCode();
        inboundResponse.set(HttpConstants.RESPONSE_STATUS_CODE_FIELD, (Object)statusCode);
        String reasonPhrase = inboundResponseMsg.getReasonPhrase();
        inboundResponse.set(HttpConstants.RESPONSE_REASON_PHRASE_FIELD, (Object)StringUtils.fromString((String)reasonPhrase));
        if (inboundResponseMsg.getHeader(HttpHeaderNames.SERVER.toString()) != null) {
            inboundResponse.set(HttpConstants.RESPONSE_SERVER_FIELD, (Object)StringUtils.fromString((String)inboundResponseMsg.getHeader(HttpHeaderNames.SERVER.toString())));
        }
        if (inboundResponseMsg.getProperty("RESOLVED_REQUESTED_URI") != null) {
            inboundResponse.set(HttpConstants.RESOLVED_REQUESTED_URI_FIELD, (Object)StringUtils.fromString((String)inboundResponseMsg.getProperty("RESOLVED_REQUESTED_URI").toString()));
        }
        if ((cacheControlHeader = inboundResponseMsg.getHeader(HttpHeaderNames.CACHE_CONTROL.toString())) != null) {
            ResponseCacheControlObj responseCacheControl = new ResponseCacheControlObj(ModuleUtils.getHttpPackage(), "ResponseCacheControl");
            responseCacheControl.populateStruct(cacheControlHeader);
            inboundResponse.set(HttpConstants.RESPONSE_CACHE_CONTROL_FIELD, (Object)responseCacheControl.getObj());
        }
        HttpUtil.populateEntity(inboundResponse, entity, inboundResponseMsg);
        inboundResponse.set(MimeConstants.RESPONSE_ENTITY_FIELD, (Object)entity);
        inboundResponse.addNativeData("is_byte_channel_set", (Object)false);
    }

    private static void populateEntity(BObject requestObj, BObject entity, HttpCarbonMessage cMsg) {
        long contentLength = -1L;
        String lengthStr = cMsg.getHeader(HttpHeaderNames.CONTENT_LENGTH.toString());
        try {
            contentLength = lengthStr != null ? Long.parseLong(lengthStr) : contentLength;
            MimeUtil.setContentLength((BObject)entity, (long)contentLength);
        }
        catch (NumberFormatException e) {
            throw HttpUtil.createHttpError("Invalid content length", HttpErrorType.INVALID_CONTENT_LENGTH);
        }
        requestObj.addNativeData("http_headers", (Object)cMsg.getHeaders());
        requestObj.addNativeData("http_trailer_headers", (Object)cMsg.getTrailerHeaders());
    }

    public static void enrichOutboundMessage(HttpCarbonMessage outboundMsg, BObject outboundMsgObj) {
        HttpUtil.setHeadersToTransportMessage(outboundMsg, outboundMsgObj);
        HttpUtil.setPropertiesToTransportMessage(outboundMsg, outboundMsgObj);
    }

    private static void setHeadersToTransportMessage(HttpCarbonMessage outboundMsg, BObject messageObj) {
        HttpHeaders httpHeaders;
        boolean request = HttpUtil.isRequest(messageObj);
        HttpHeaders transportHeaders = outboundMsg.getHeaders();
        if (request || HttpUtil.isResponse(messageObj)) {
            HttpUtil.addRemovedPropertiesBackToHeadersMap(messageObj, transportHeaders);
        }
        if ((httpHeaders = (HttpHeaders)messageObj.getNativeData("http_headers")) != transportHeaders && httpHeaders != null) {
            transportHeaders.add(httpHeaders);
        }
        if (!request) {
            HttpHeaders transportTrailingHeaders = outboundMsg.getTrailerHeaders();
            HttpHeaders trailingHeaders = (HttpHeaders)messageObj.getNativeData("http_trailer_headers");
            if (trailingHeaders != null && trailingHeaders != transportTrailingHeaders) {
                transportTrailingHeaders.add(trailingHeaders);
            }
        }
    }

    private static void setEntityHeaderToTransportHeader(BObject entityObj, HttpHeaders httpHeaders) {
        BMap entityHeaders = EntityHeaderHandler.getEntityHeaderMap((BObject)entityObj);
        for (BString entryKey : (BString[])entityHeaders.getKeys()) {
            BArray entryValues = (BArray)entityHeaders.get((Object)entryKey);
            if (entryValues.size() > 1) {
                List<String> values = Arrays.asList(entryValues.getStringArray());
                httpHeaders.add(entryKey.getValue(), values);
                continue;
            }
            if (entryValues.size() != 1) continue;
            httpHeaders.set(entryKey.getValue(), (Object)entryValues.getBString(0L).getValue());
        }
    }

    private static boolean isRequest(BObject value) {
        return TypeUtils.getType((Object)value).getName().equals("Request");
    }

    private static boolean isResponse(BObject value) {
        return TypeUtils.getType((Object)value).getName().equals("Response");
    }

    private static void addRemovedPropertiesBackToHeadersMap(BObject messageObj, HttpHeaders transportHeaders) {
        if (HttpUtil.isRequest(messageObj)) {
            Object userAgent = messageObj.get(HttpConstants.REQUEST_USER_AGENT_FIELD);
            if (userAgent != null && !userAgent.toString().isEmpty()) {
                transportHeaders.set(HttpHeaderNames.USER_AGENT.toString(), (Object)userAgent.toString());
            }
        } else {
            Object server = messageObj.get(HttpConstants.RESPONSE_SERVER_FIELD);
            if (server != null && !server.toString().isEmpty()) {
                transportHeaders.set(HttpHeaderNames.SERVER.toString(), (Object)server.toString());
            }
        }
    }

    private static void setPropertiesToTransportMessage(HttpCarbonMessage outboundResponseMsg, BObject messageObj) {
        if (HttpUtil.isResponse(messageObj)) {
            Object respPhrase;
            long statusCode = (Long)messageObj.get(HttpConstants.RESPONSE_STATUS_CODE_FIELD);
            if (statusCode != 0L) {
                outboundResponseMsg.setHttpStatusCode(HttpUtil.getIntValue(statusCode));
            }
            if ((respPhrase = messageObj.get(HttpConstants.RESPONSE_REASON_PHRASE_FIELD)) != null && !respPhrase.toString().isEmpty()) {
                outboundResponseMsg.setProperty("HTTP_REASON_PHRASE", respPhrase.toString());
            }
        }
    }

    public static void checkEntityAvailability(BObject value) {
        BObject entity = (BObject)value.get(HttpUtil.isRequest(value) ? MimeConstants.REQUEST_ENTITY_FIELD : MimeConstants.RESPONSE_ENTITY_FIELD);
        if (entity == null) {
            HttpUtil.createNewEntity(value);
        }
    }

    public static Boolean checkRequestBodySizeHeadersAvailability(HttpCarbonMessage message) {
        String contentLength = message.getHeader(HttpHeaderNames.CONTENT_LENGTH.toString());
        String transferEncoding = message.getHeader(HttpHeaderNames.TRANSFER_ENCODING.toString());
        return contentLength != null || transferEncoding != null;
    }

    public static boolean isEntityDataSourceAvailable(BObject value) {
        BObject entityObj = (BObject)value.get(HttpUtil.isRequest(value) ? MimeConstants.REQUEST_ENTITY_FIELD : MimeConstants.RESPONSE_ENTITY_FIELD);
        return entityObj != null && EntityBodyHandler.getMessageDataSource((BObject)entityObj) != null;
    }

    private static void setCompressionHeaders(BMap<BString, Object> compressionConfig, HttpCarbonMessage requestMsg, HttpCarbonMessage outboundResponseMsg) {
        if (!HttpUtil.checkConfigAnnotationAvailability(compressionConfig)) {
            return;
        }
        String contentEncoding = outboundResponseMsg.getHeaders().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING);
        if (contentEncoding != null) {
            return;
        }
        CompressionConfigState compressionState = HttpUtil.getCompressionState(compressionConfig.getStringValue(HttpConstants.ANN_CONFIG_ATTR_COMPRESSION_ENABLE).getValue());
        if (compressionState == CompressionConfigState.NEVER) {
            outboundResponseMsg.getHeaders().set((CharSequence)HttpHeaderNames.CONTENT_ENCODING, (Object)"identity");
            return;
        }
        String acceptEncodingValue = requestMsg.getHeaders().get((CharSequence)HttpHeaderNames.ACCEPT_ENCODING);
        List<String> contentTypesAnnotationValues = HttpUtil.getAsStringList(compressionConfig.getArrayValue(HttpConstants.ANN_CONFIG_ATTR_COMPRESSION_CONTENT_TYPES).getStringArray());
        String contentType = outboundResponseMsg.getHeader(HttpHeaderNames.CONTENT_TYPE.toString());
        if (contentTypesAnnotationValues.isEmpty() || HttpUtil.isContentTypeMatched(contentTypesAnnotationValues, contentType)) {
            if (compressionState == CompressionConfigState.ALWAYS && (acceptEncodingValue == null || "identity".equals(acceptEncodingValue))) {
                outboundResponseMsg.getHeaders().set((CharSequence)HttpHeaderNames.CONTENT_ENCODING, (Object)"gzip");
            }
        } else {
            outboundResponseMsg.getHeaders().set((CharSequence)HttpHeaderNames.CONTENT_ENCODING, (Object)"identity");
        }
    }

    public static CompressionConfigState getCompressionState(String compressionState) {
        switch (compressionState) {
            case "AUTO": {
                return CompressionConfigState.AUTO;
            }
            case "ALWAYS": {
                return CompressionConfigState.ALWAYS;
            }
            case "NEVER": {
                return CompressionConfigState.NEVER;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isContentTypeMatched(List<String> contentTypes, String contentType) {
        if (contentType == null) return false;
        if (!contentTypes.stream().anyMatch(contentType.toLowerCase(Locale.getDefault())::contains)) return false;
        return true;
    }

    private static List<String> getAsStringList(Object[] values) {
        ArrayList<String> valuesList = new ArrayList<String>();
        if (values == null) {
            return valuesList;
        }
        for (Object val : values) {
            valuesList.add(val.toString().trim().toLowerCase(Locale.getDefault()));
        }
        return valuesList;
    }

    public static String getListenerInterface(String host, int port) {
        host = host != null ? host : "0.0.0.0";
        return host + ":" + port;
    }

    public static ChunkConfig getChunkConfig(String chunkConfig) {
        switch (chunkConfig) {
            case "AUTO": {
                return ChunkConfig.AUTO;
            }
            case "ALWAYS": {
                return ChunkConfig.ALWAYS;
            }
            case "NEVER": {
                return ChunkConfig.NEVER;
            }
        }
        throw new BallerinaConnectorException("Invalid configuration found for Transfer-Encoding: " + chunkConfig);
    }

    public static KeepAliveConfig getKeepAliveConfig(String keepAliveConfig) {
        switch (keepAliveConfig) {
            case "AUTO": {
                return KeepAliveConfig.AUTO;
            }
            case "ALWAYS": {
                return KeepAliveConfig.ALWAYS;
            }
            case "NEVER": {
                return KeepAliveConfig.NEVER;
            }
        }
        throw new BallerinaConnectorException("Invalid configuration found for Keep-Alive: " + keepAliveConfig);
    }

    public static ForwardedExtensionConfig getForwardedExtensionConfig(String forwarded) {
        ForwardedExtensionConfig forwardedConfig;
        if ("enable".equalsIgnoreCase(forwarded)) {
            forwardedConfig = ForwardedExtensionConfig.ENABLE;
        } else if ("transition".equalsIgnoreCase(forwarded)) {
            forwardedConfig = ForwardedExtensionConfig.TRANSITION;
        } else if ("disable".equalsIgnoreCase(forwarded)) {
            forwardedConfig = ForwardedExtensionConfig.DISABLE;
        } else {
            throw new BallerinaConnectorException("Invalid configuration found for Forwarded : " + forwarded);
        }
        return forwardedConfig;
    }

    public static HttpCarbonMessage createHttpCarbonMessage(boolean isRequest) {
        HttpCarbonMessage httpCarbonMessage = isRequest ? new HttpCarbonMessage((HttpMessage)new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "")) : new HttpCarbonMessage((HttpMessage)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK));
        httpCarbonMessage.completeMessage();
        return httpCarbonMessage;
    }

    public static void checkFunctionValidity(HttpCarbonMessage reqMsg, HttpCarbonMessage outboundResponseMsg) {
        HttpUtil.serverConnectionStructCheck(reqMsg);
        int statusCode = outboundResponseMsg.getHttpStatusCode();
        HttpUtil.methodInvocationCheck(reqMsg, statusCode, ILLEGAL_FUNCTION_INVOKED);
    }

    static void methodInvocationCheck(HttpCarbonMessage reqMsg, int statusCode, String errMsg) {
        if (reqMsg == null || reqMsg.getProperty(METHOD_ACCESSED) != null) {
            throw HttpUtil.createHttpError(errMsg, HttpErrorType.GENERIC_LISTENER_ERROR);
        }
        if (statusCode == 100 || statusCode == 0) {
            return;
        }
        reqMsg.setProperty(METHOD_ACCESSED, true);
    }

    public static void serverConnectionStructCheck(HttpCarbonMessage reqMsg) {
        if (reqMsg == null) {
            throw HttpUtil.createHttpError("operation not allowed:invalid Connection variable", HttpErrorType.GENERIC_LISTENER_ERROR);
        }
    }

    public static BMap getTransactionConfigAnnotation(MethodType resource, String transactionPackagePath) {
        return (BMap)resource.getAnnotation(StringUtils.fromString((String)(transactionPackagePath + ":Participant")));
    }

    private static int getIntValue(long val) {
        int intVal = (int)val;
        if ((long)intVal != val) {
            throw new IllegalArgumentException("invalid argument: " + val);
        }
        return intVal;
    }

    public static String getContentTypeFromTransportMessage(HttpCarbonMessage transportMessage) {
        return transportMessage.getHeader(HttpHeaderNames.CONTENT_TYPE.toString());
    }

    public static String addBoundaryIfNotExist(HttpCarbonMessage transportMessage, String contentType) {
        String boundaryValue = HeaderUtil.extractBoundaryParameter((String)contentType);
        if (boundaryValue != null) {
            boolean validateContentType = MimeUtil.isValidateContentType((String)contentType);
            if (!validateContentType) {
                String headerValue = HeaderUtil.getHeaderValue((String)contentType);
                BMap paramMap = HeaderUtil.getParamMap((String)contentType);
                paramMap.put((Object)StringUtils.fromString((String)"boundary"), (Object)StringUtils.fromString((String)MimeUtil.includeQuotes((String)boundaryValue)));
                contentType = HeaderUtil.appendHeaderParams((StringBuilder)new StringBuilder(headerValue).append(";"), (BMap)paramMap);
                transportMessage.setHeader("content-type", contentType);
            }
            return boundaryValue;
        }
        return HttpUtil.addBoundaryParameter(transportMessage, contentType);
    }

    private static String addBoundaryParameter(HttpCarbonMessage transportMessage, String contentType) {
        String boundaryString = null;
        if (contentType != null && contentType.startsWith("multipart/")) {
            boundaryString = MimeUtil.getNewMultipartDelimiter();
            transportMessage.setHeader(HttpHeaderNames.CONTENT_TYPE.toString(), contentType + "; boundary=" + boundaryString);
        }
        return boundaryString;
    }

    public static HttpWsConnectorFactory createHttpWsConnectionFactory() {
        return DefaultHttpWsConnectorFactoryHolder.getHttpConnectorFactory();
    }

    public static void checkAndObserveHttpRequest(Environment environment, HttpCarbonMessage message) {
        ObserverContext observerContext = ObserveUtils.getObserverContextOfCurrentFrame((Environment)environment);
        if (observerContext != null) {
            HttpUtil.injectHeaders(message, ObserveUtils.getContextProperties((ObserverContext)observerContext));
            observerContext.addTag("http.method", message.getHttpMethod());
            if (observerContext.getSpan() != null) {
                observerContext.getSpan().addTag("http.url", String.valueOf(message.getProperty("TO")));
            }
            observerContext.addTag("peer.address", String.valueOf(message.getProperty("host")) + ":" + String.valueOf(message.getProperty("port")));
            observerContext.addProperty("_http_status_code_", (Object)0);
        }
    }

    public static void injectHeaders(HttpCarbonMessage msg, Map<String, String> headers) {
        if (headers != null) {
            headers.forEach((key, value) -> msg.setHeader((String)key, String.valueOf(value)));
        }
    }

    private static void setChunkingHeader(String transferValue, HttpCarbonMessage outboundResponseMsg) {
        if (transferValue == null) {
            return;
        }
        outboundResponseMsg.setProperty(CHUNKING_CONFIG, (Object)HttpUtil.getChunkConfig(transferValue));
    }

    public static BObject createResponseStruct(HttpCarbonMessage httpCarbonMessage) {
        BObject responseObj = ValueCreatorUtils.createResponseObject();
        BObject entity = ValueCreatorUtils.createEntityObject();
        HttpUtil.populateInboundResponse(responseObj, entity, httpCarbonMessage);
        return responseObj;
    }

    public static void populateSenderConfigurations(SenderConfiguration senderConfiguration, BMap<BString, Object> clientEndpointConfig, String scheme) {
        double timeout;
        BMap http1Settings;
        BMap proxyFromHttp1Settings;
        BMap secureSocket = clientEndpointConfig.getMapValue(HttpConstants.ENDPOINT_CONFIG_SECURESOCKET);
        String httpVersion = clientEndpointConfig.getStringValue(HttpConstants.CLIENT_EP_HTTP_VERSION).getValue();
        if (scheme.equals("https")) {
            if (secureSocket != null) {
                HttpUtil.populateSSLConfiguration(senderConfiguration, (BMap<BString, Object>)secureSocket);
            } else {
                senderConfiguration.useJavaDefaults();
            }
        }
        BMap proxy = clientEndpointConfig.getMapValue(HttpConstants.PROXY_STRUCT_REFERENCE);
        if ("1.1".equals(httpVersion) && (proxyFromHttp1Settings = (http1Settings = (BMap)clientEndpointConfig.get((Object)HttpConstants.HTTP1_SETTINGS)).getMapValue(HttpConstants.PROXY_STRUCT_REFERENCE)) != null) {
            System.err.println("warning: [ballerina/http] Usage of proxy setting inside http1Settings is deprecated");
            if (proxy == null) {
                proxy = proxyFromHttp1Settings;
            }
        }
        if (proxy != null) {
            ProxyServerConfiguration proxyServerConfiguration;
            String proxyHost = proxy.getStringValue(HttpConstants.PROXY_HOST).getValue();
            int proxyPort = proxy.getIntValue(HttpConstants.PROXY_PORT).intValue();
            String proxyUserName = proxy.getStringValue(HttpConstants.PROXY_USERNAME).getValue();
            String proxyPassword = proxy.getStringValue(HttpConstants.PROXY_PASSWORD).getValue();
            try {
                proxyServerConfiguration = new ProxyServerConfiguration(proxyHost, proxyPort);
            }
            catch (UnknownHostException e) {
                throw new BallerinaConnectorException("Failed to resolve host: " + proxyHost, e);
            }
            if (!proxyUserName.isEmpty()) {
                proxyServerConfiguration.setProxyUsername(proxyUserName);
            }
            if (!proxyPassword.isEmpty()) {
                proxyServerConfiguration.setProxyPassword(proxyPassword);
            }
            senderConfiguration.setProxyServerConfiguration(proxyServerConfiguration);
        }
        if ((timeout = ((BDecimal)clientEndpointConfig.get((Object)HttpConstants.CLIENT_EP_ENDPOINT_TIMEOUT)).floatValue()) < 0.0) {
            senderConfiguration.setSocketIdleTimeout(0);
        } else {
            senderConfiguration.setSocketIdleTimeout((int)(timeout * 1000.0));
        }
        if (httpVersion != null) {
            senderConfiguration.setHttpVersion(httpVersion);
        }
        String forwardedExtension = clientEndpointConfig.getStringValue(HttpConstants.CLIENT_EP_FORWARDED).getValue();
        senderConfiguration.setForwardedExtensionConfig(HttpUtil.getForwardedExtensionConfig(forwardedExtension));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionManager getConnectionManager(BMap poolStruct) {
        ConnectionManager poolManager = (ConnectionManager)poolStruct.getNativeData("ConnectionManager");
        if (poolManager == null) {
            BMap bMap = poolStruct;
            synchronized (bMap) {
                if (poolStruct.getNativeData("ConnectionManager") == null) {
                    PoolConfiguration userDefinedPool = new PoolConfiguration();
                    HttpUtil.populatePoolingConfig(poolStruct, userDefinedPool);
                    poolManager = new ConnectionManager(userDefinedPool);
                    poolStruct.addNativeData("ConnectionManager", (Object)poolManager);
                }
            }
        }
        return poolManager;
    }

    public static void populatePoolingConfig(BMap poolRecord, PoolConfiguration poolConfiguration) {
        double minIdleTimeInStaleState;
        long maxActiveConnections = poolRecord.getIntValue(HttpConstants.CONNECTION_POOLING_MAX_ACTIVE_CONNECTIONS);
        poolConfiguration.setMaxActivePerPool(HttpUtil.validateConfig(maxActiveConnections, HttpConstants.CONNECTION_POOLING_MAX_ACTIVE_CONNECTIONS.getValue()));
        long maxIdleConnections = poolRecord.getIntValue(HttpConstants.CONNECTION_POOLING_MAX_IDLE_CONNECTIONS);
        poolConfiguration.setMaxIdlePerPool(HttpUtil.validateConfig(maxIdleConnections, HttpConstants.CONNECTION_POOLING_MAX_IDLE_CONNECTIONS.getValue()));
        double waitTime = ((BDecimal)poolRecord.get((Object)HttpConstants.CONNECTION_POOLING_WAIT_TIME)).floatValue();
        poolConfiguration.setMaxWaitTime((long)(waitTime * 1000.0));
        long maxActiveStreamsPerConnection = poolRecord.getIntValue(HttpConstants.CONNECTION_POOLING_MAX_ACTIVE_STREAMS_PER_CONNECTION);
        poolConfiguration.setHttp2MaxActiveStreamsPerConnection(maxActiveStreamsPerConnection == -1L ? Integer.MAX_VALUE : HttpUtil.validateConfig(maxActiveStreamsPerConnection, HttpConstants.CONNECTION_POOLING_MAX_ACTIVE_STREAMS_PER_CONNECTION.getValue()));
        double minEvictableIdleTime = ((BDecimal)poolRecord.get((Object)HttpConstants.CONNECTION_POOLING_EVICTABLE_IDLE_TIME)).floatValue();
        poolConfiguration.setMinEvictableIdleTime(minEvictableIdleTime < 0.0 ? 0L : (long)minEvictableIdleTime * 1000L);
        double timeBetweenEvictionRuns = ((BDecimal)poolRecord.get((Object)HttpConstants.CONNECTION_POOLING_TIME_BETWEEN_EVICTION_RUNS)).floatValue();
        if (timeBetweenEvictionRuns > 0.0) {
            poolConfiguration.setTimeBetweenEvictionRuns((long)timeBetweenEvictionRuns * 1000L);
        }
        poolConfiguration.setMinIdleTimeInStaleState((minIdleTimeInStaleState = ((BDecimal)poolRecord.get((Object)HttpConstants.CONNECTION_POOLING_IDLE_TIME_STALE_STATE)).floatValue()) < -1.0 ? -1L : (long)minIdleTimeInStaleState * 1000L);
        double timeBetweenStaleEviction = ((BDecimal)poolRecord.get((Object)HttpConstants.CONNECTION_POOLING_TIME_BETWEEN_STALE_CHECK_RUNS)).floatValue();
        if (timeBetweenStaleEviction > 0.0) {
            poolConfiguration.setTimeBetweenStaleEviction((long)timeBetweenStaleEviction * 1000L);
        }
    }

    private static int validateConfig(long value, String configName) {
        try {
            return Math.toIntExact(value);
        }
        catch (ArithmeticException e) {
            log.warn("The value set for the configuration needs to be less than {}. The " + configName + "value is set to {}", (Object)Integer.MAX_VALUE);
            return Integer.MAX_VALUE;
        }
    }

    public static void populateSSLConfiguration(SslConfiguration senderConfiguration, BMap<BString, Object> secureSocket) {
        BArray ciphers;
        BMap<BString, Object> certValidation;
        BMap<BString, Object> protocol;
        ArrayList<Parameter> clientParamList = new ArrayList<Parameter>();
        boolean enable = secureSocket.getBooleanValue(HttpConstants.SECURESOCKET_CONFIG_DISABLE_SSL);
        if (!enable) {
            senderConfiguration.disableSsl();
            BMap<BString, Object> key = HttpUtil.getBMapValueIfPresent(secureSocket, HttpConstants.SECURESOCKET_CONFIG_KEY);
            if (key != null) {
                HttpUtil.evaluateKeyField(key, senderConfiguration);
            }
            return;
        }
        Object cert = secureSocket.get((Object)HttpConstants.SECURESOCKET_CONFIG_CERT);
        if (cert == null) {
            senderConfiguration.useJavaDefaults();
        } else {
            HttpUtil.evaluateCertField(cert, senderConfiguration);
        }
        BMap<BString, Object> key = HttpUtil.getBMapValueIfPresent(secureSocket, HttpConstants.SECURESOCKET_CONFIG_KEY);
        if (key != null) {
            HttpUtil.evaluateKeyField(key, senderConfiguration);
        }
        if ((protocol = HttpUtil.getBMapValueIfPresent(secureSocket, HttpConstants.SECURESOCKET_CONFIG_PROTOCOL)) != null) {
            HttpUtil.evaluateProtocolField(protocol, senderConfiguration, clientParamList);
        }
        if ((certValidation = HttpUtil.getBMapValueIfPresent(secureSocket, HttpConstants.SECURESOCKET_CONFIG_CERT_VALIDATION)) != null) {
            HttpUtil.evaluateCertValidationField(certValidation, senderConfiguration);
        }
        BArray bArray = ciphers = secureSocket.containsKey((Object)HttpConstants.SECURESOCKET_CONFIG_CIPHERS) ? secureSocket.getArrayValue(HttpConstants.SECURESOCKET_CONFIG_CIPHERS) : null;
        if (ciphers != null) {
            HttpUtil.evaluateCiphersField(ciphers, clientParamList);
        }
        HttpUtil.evaluateCommonFields(secureSocket, senderConfiguration, clientParamList);
        if (!clientParamList.isEmpty()) {
            senderConfiguration.setParameters(clientParamList);
        }
    }

    public static String sanitizeBasePath(String basePath) {
        if (!(basePath = basePath.trim().replace("//", "/")).startsWith("/")) {
            basePath = "/".concat(basePath);
        }
        if (basePath.endsWith("/") && basePath.length() != 1) {
            basePath = basePath.substring(0, basePath.length() - 1);
        }
        if (basePath.endsWith("*")) {
            basePath = basePath.substring(0, basePath.length() - 1);
        }
        return basePath;
    }

    public static void serializeDataSource(Object outboundMessageSource, BObject entity, OutputStream messageOutputStream) throws IOException {
        if (MimeUtil.generateAsJSON((Object)outboundMessageSource, (BObject)entity)) {
            JsonUtils.serialize((Object)outboundMessageSource, (OutputStream)messageOutputStream);
        } else {
            HttpUtil.serialize(outboundMessageSource, messageOutputStream);
        }
    }

    public static void serialize(Object value, OutputStream outputStream) throws IOException {
        if (value == null) {
            throw HttpUtil.createHttpError("error occurred while serializing null data");
        }
        if (value instanceof BArray) {
            if (value instanceof BStreamingJson) {
                ((BStreamingJson)value).serialize(outputStream);
            } else {
                ((BArray)value).serialize(outputStream);
            }
        } else if (value instanceof MultipartDataSource) {
            ((MultipartDataSource)value).serialize(outputStream);
        } else if (value instanceof BXmlItem) {
            ((BXmlItem)value).serialize(outputStream);
        } else if (value instanceof BXmlSequence) {
            ((BXmlSequence)value).serialize(outputStream);
        } else if (value instanceof Long || value instanceof String || value instanceof BDecimal || value instanceof Double || value instanceof Integer || value instanceof Boolean) {
            outputStream.write(value.toString().getBytes(Charset.defaultCharset()));
        } else if (value instanceof BString) {
            outputStream.write(((BString)value).getValue().getBytes(Charset.defaultCharset()));
        } else {
            ((BRefValue)value).serialize(outputStream);
        }
    }

    public static boolean checkConfigAnnotationAvailability(BMap configAnnotation) {
        return configAnnotation != null;
    }

    public static ListenerConfiguration getListenerConfig(long port, BMap endpointConfig) {
        BString serverName;
        String host = endpointConfig.getStringValue(HttpConstants.ENDPOINT_CONFIG_HOST).getValue();
        BMap sslConfig = endpointConfig.getMapValue(HttpConstants.ENDPOINT_CONFIG_SECURESOCKET);
        String httpVersion = endpointConfig.getStringValue(HttpConstants.ENDPOINT_CONFIG_VERSION).getValue();
        ListenerConfiguration listenerConfiguration = new ListenerConfiguration();
        if ("1.1".equals(httpVersion)) {
            BMap http1Settings = (BMap)endpointConfig.get((Object)HttpConstants.HTTP1_SETTINGS);
            listenerConfiguration.setPipeliningLimit(http1Settings.getIntValue(HttpConstants.PIPELINING_REQUEST_LIMIT));
            String keepAlive = http1Settings.getStringValue(HttpConstants.ENDPOINT_CONFIG_KEEP_ALIVE).getValue();
            listenerConfiguration.setKeepAliveConfig(HttpUtil.getKeepAliveConfig(keepAlive));
        }
        BMap requestLimits = endpointConfig.getMapValue(HttpConstants.REQUEST_LIMITS);
        HttpUtil.setInboundMgsSizeValidationConfig(requestLimits.getIntValue(HttpConstants.MAX_URI_LENGTH), requestLimits.getIntValue(HttpConstants.MAX_HEADER_SIZE), requestLimits.getIntValue(HttpConstants.MAX_ENTITY_BODY_SIZE), listenerConfiguration.getMsgSizeValidationConfig());
        if (host == null || host.trim().isEmpty()) {
            listenerConfiguration.setHost("0.0.0.0");
        } else {
            listenerConfiguration.setHost(host);
        }
        if (port == 0L) {
            throw new BallerinaConnectorException("Listener port is not defined!");
        }
        listenerConfiguration.setPort(Math.toIntExact(port));
        double idleTimeout = ((BDecimal)endpointConfig.get((Object)HttpConstants.ENDPOINT_CONFIG_TIMEOUT)).floatValue();
        if (idleTimeout < 0.0) {
            throw new BallerinaConnectorException("Idle timeout cannot be negative. If you want to disable the timeout please use value 0");
        }
        listenerConfiguration.setSocketIdleTimeout((int)(idleTimeout * 1000.0));
        double gracefulStopTimeout = ((BDecimal)endpointConfig.get((Object)HttpConstants.ENDPOINT_CONFIG_GRACEFUL_STOP_TIMEOUT)).floatValue();
        if (gracefulStopTimeout < 0.0) {
            throw new BallerinaConnectorException("gracefulStop timeout cannot be negative");
        }
        listenerConfiguration.setGracefulStopTimeout((int)(gracefulStopTimeout * 1000.0));
        if (httpVersion != null) {
            listenerConfiguration.setVersion(httpVersion);
        }
        listenerConfiguration.setServerHeader((serverName = endpointConfig.getStringValue(HttpConstants.SERVER_NAME)) != null ? serverName.getValue() : HttpUtil.getServerName());
        BMap serverSocketConfig = endpointConfig.getMapValue(HttpConstants.SOCKET_CONFIG);
        if (serverSocketConfig != null) {
            HttpUtil.setServerSocketConfig((BMap<BString, Object>)serverSocketConfig, listenerConfiguration);
        }
        if (sslConfig != null) {
            return HttpUtil.setSslConfig((BMap<BString, Object>)sslConfig, listenerConfiguration);
        }
        listenerConfiguration.setPipeliningEnabled(true);
        listenerConfiguration.setHttp2InitialWindowSize(endpointConfig.getIntValue(HttpConstants.ENDPOINT_CONFIG_HTTP2_INITIAL_WINDOW_SIZE).intValue());
        double minIdleTimeInStaleState = ((BDecimal)endpointConfig.get((Object)HttpConstants.ENDPOINT_CONFIG_IDLE_TIME_STALE_STATE)).floatValue();
        listenerConfiguration.setMinIdleTimeInStaleState(minIdleTimeInStaleState < -1.0 ? -1L : (long)minIdleTimeInStaleState * 1000L);
        double timeBetweenStaleEviction = ((BDecimal)endpointConfig.get((Object)HttpConstants.ENDPOINT_CONFIG_TIME_BETWEEN_STALE_CHECK_RUNS)).floatValue();
        if (timeBetweenStaleEviction > 0.0) {
            listenerConfiguration.setTimeBetweenStaleEviction((long)timeBetweenStaleEviction * 1000L);
        }
        return listenerConfiguration;
    }

    private static void setServerSocketConfig(BMap<BString, Object> serverSocketConfig, ListenerConfiguration listenerConfig) {
        double connectTimeOut = ((BDecimal)serverSocketConfig.get((Object)HttpConstants.SOCKET_CONFIG_CONNECT_TIMEOUT)).floatValue();
        listenerConfig.setConnectTimeOut(connectTimeOut);
        int receiveBufferSize = serverSocketConfig.getIntValue(HttpConstants.SOCKET_CONFIG_RECEIVE_BUFFER_SIZE).intValue();
        listenerConfig.setReceiveBufferSize(receiveBufferSize);
        int sendBufferSize = serverSocketConfig.getIntValue(HttpConstants.SOCKET_CONFIG_SEND_BUFFER_SIZE).intValue();
        listenerConfig.setSendBufferSize(sendBufferSize);
        boolean tcpNoDelay = serverSocketConfig.getBooleanValue(HttpConstants.SOCKET_CONFIG_TCP_NO_DELAY);
        listenerConfig.setTcpNoDelay(tcpNoDelay);
        boolean socketReuse = serverSocketConfig.getBooleanValue(HttpConstants.SOCKET_CONFIG_SOCKET_REUSE);
        listenerConfig.setSocketReuse(socketReuse);
        boolean keepAlive = serverSocketConfig.getBooleanValue(HttpConstants.SOCKET_CONFIG_KEEP_ALIVE);
        listenerConfig.setSocketKeepAlive(keepAlive);
        int soBackLog = serverSocketConfig.getIntValue(HttpConstants.SOCKET_CONFIG_SO_BACKLOG).intValue();
        listenerConfig.setSoBackLog(soBackLog);
    }

    public static void populateInterceptorServicesFromService(BObject serviceEndpoint, HTTPServicesRegistry servicesRegistry) {
        List<HTTPInterceptorServicesRegistry> listenerLevelInterceptors = Register.getHttpInterceptorServicesRegistries(serviceEndpoint);
        BArray interceptorsArray = serviceEndpoint.getNativeData("INTERCEPTORS") instanceof BArray ? (BArray)serviceEndpoint.getNativeData("INTERCEPTORS") : null;
        Runtime runtime = servicesRegistry.getRuntime();
        Map<String, HTTPServicesRegistry.ServicesMapHolder> servicesMapByHost = servicesRegistry.getServicesMapByHost();
        for (HTTPServicesRegistry.ServicesMapHolder servicesMapHolder : servicesMapByHost.values()) {
            Map<String, HttpService> servicesByBasePath = servicesMapHolder.getServicesByBasePath();
            for (HttpService service : servicesByBasePath.values()) {
                HttpService.populateInterceptorServicesRegistries(listenerLevelInterceptors, interceptorsArray, service, runtime);
            }
        }
    }

    public static void populateInterceptorServicesFromListener(BObject serviceEndpoint, Runtime runtime) {
        BArray[] interceptorResponse = new BArray[1];
        try {
            Object result = runtime.callMethod(serviceEndpoint, "createInterceptors", null, new Object[0]);
            if (result instanceof BArray) {
                interceptorResponse[0] = (BArray)result;
            } else {
                ((BError)((Object)result)).printStackTrace();
            }
        }
        catch (BError bError) {
            bError.printStackTrace();
            System.exit(1);
        }
        if (interceptorResponse[0] == null) {
            return;
        }
        BObject interceptorService = (BObject)interceptorResponse[0].getValues()[0];
        serviceEndpoint.addNativeData("INTERCEPTORS", (Object)interceptorResponse[0]);
        Register.resetInterceptorRegistry(serviceEndpoint, 1);
        List<HTTPInterceptorServicesRegistry> httpInterceptorServicesRegistries = Register.getHttpInterceptorServicesRegistries(serviceEndpoint);
        HTTPInterceptorServicesRegistry servicesRegistry = httpInterceptorServicesRegistries.get(0);
        servicesRegistry.setServicesType(HttpUtil.getInterceptorServiceType(interceptorService));
        servicesRegistry.registerInterceptorService(interceptorService, "/", true);
        servicesRegistry.setRuntime(runtime);
    }

    public static void markPossibleLastInterceptors(HTTPServicesRegistry servicesRegistry) {
        Map<String, HTTPServicesRegistry.ServicesMapHolder> servicesMapByHost = servicesRegistry.getServicesMapByHost();
        for (HTTPServicesRegistry.ServicesMapHolder servicesMapHolder : servicesMapByHost.values()) {
            Map<String, HttpService> servicesByBasePath = servicesMapHolder.getServicesByBasePath();
            block1: for (HttpService service : servicesByBasePath.values()) {
                List<HTTPInterceptorServicesRegistry> interceptors = service.getInterceptorServicesRegistries();
                for (HTTPInterceptorServicesRegistry interceptor : interceptors) {
                    if (interceptor.getServicesType().equals("ResponseErrorInterceptor")) {
                        interceptor.setPossibleLastInterceptor(true);
                        continue;
                    }
                    if (!interceptor.getServicesType().equals("ResponseInterceptor")) continue;
                    interceptor.setPossibleLastInterceptor(true);
                    servicesRegistry.setPossibleLastService(false);
                    continue block1;
                }
            }
        }
    }

    public static void setInboundMgsSizeValidationConfig(long maxInitialLineLength, long maxHeaderSize, long maxEntityBodySize, InboundMsgSizeValidationConfig sizeValidationConfig) {
        if (maxInitialLineLength < 0L) {
            throw new BallerinaConnectorException("Invalid configuration found for max initial line length : " + maxInitialLineLength);
        }
        sizeValidationConfig.setMaxInitialLineLength(Math.toIntExact(maxInitialLineLength));
        if (maxHeaderSize < 0L) {
            throw new BallerinaConnectorException("Invalid configuration found for maxHeaderSize : " + maxHeaderSize);
        }
        sizeValidationConfig.setMaxHeaderSize(Math.toIntExact(maxHeaderSize));
        if (maxEntityBodySize != -1L) {
            if (maxEntityBodySize >= 0L) {
                sizeValidationConfig.setMaxEntityBodySize(maxEntityBodySize);
            } else {
                throw new BallerinaConnectorException("Invalid configuration found for maxEntityBodySize : " + maxEntityBodySize);
            }
        }
    }

    private static String getServerName() {
        String version = System.getProperty("ballerina.version");
        Object userAgent = version != null ? "ballerina/" + version : "ballerina";
        return userAgent;
    }

    private static ListenerConfiguration setSslConfig(BMap<BString, Object> secureSocket, ListenerConfiguration listenerConfiguration) {
        BArray ciphers;
        BMap<BString, Object> certValidation;
        BMap<BString, Object> protocol;
        ArrayList<Parameter> serverParamList = new ArrayList<Parameter>();
        listenerConfiguration.setScheme("https");
        BMap<BString, Object> key = HttpUtil.getBMapValueIfPresent(secureSocket, HttpConstants.SECURESOCKET_CONFIG_KEY);
        assert (key != null);
        HttpUtil.evaluateKeyField(key, listenerConfiguration);
        BMap<BString, Object> mutualSsl = HttpUtil.getBMapValueIfPresent(secureSocket, HttpConstants.SECURESOCKET_CONFIG_MUTUAL_SSL);
        if (mutualSsl != null) {
            String verifyClient = mutualSsl.getStringValue(HttpConstants.SECURESOCKET_CONFIG_VERIFY_CLIENT).getValue();
            listenerConfiguration.setVerifyClient(verifyClient);
            Object cert = mutualSsl.get((Object)HttpConstants.SECURESOCKET_CONFIG_CERT);
            HttpUtil.evaluateCertField(cert, listenerConfiguration);
        }
        if ((protocol = HttpUtil.getBMapValueIfPresent(secureSocket, HttpConstants.SECURESOCKET_CONFIG_PROTOCOL)) != null) {
            HttpUtil.evaluateProtocolField(protocol, listenerConfiguration, serverParamList);
        }
        if ((certValidation = HttpUtil.getBMapValueIfPresent(secureSocket, HttpConstants.SECURESOCKET_CONFIG_CERT_VALIDATION)) != null) {
            HttpUtil.evaluateCertValidationField(certValidation, listenerConfiguration);
        }
        BArray bArray = ciphers = secureSocket.containsKey((Object)HttpConstants.SECURESOCKET_CONFIG_CIPHERS) ? secureSocket.getArrayValue(HttpConstants.SECURESOCKET_CONFIG_CIPHERS) : null;
        if (ciphers != null) {
            HttpUtil.evaluateCiphersField(ciphers, serverParamList);
        }
        HttpUtil.evaluateCommonFields(secureSocket, listenerConfiguration, serverParamList);
        listenerConfiguration.setTLSStoreType("PKCS12");
        if (!serverParamList.isEmpty()) {
            listenerConfiguration.setParameters(serverParamList);
        }
        listenerConfiguration.setId(HttpUtil.getListenerInterface(listenerConfiguration.getHost(), listenerConfiguration.getPort()));
        return listenerConfiguration;
    }

    private static void evaluateKeyField(BMap<BString, Object> key, SslConfiguration sslConfiguration) {
        if (key.containsKey((Object)HttpConstants.SECURESOCKET_CONFIG_KEYSTORE_FILE_PATH)) {
            String keyStoreFile = key.getStringValue(HttpConstants.SECURESOCKET_CONFIG_KEYSTORE_FILE_PATH).getValue();
            if (keyStoreFile.isBlank()) {
                throw HttpUtil.createHttpError("KeyStore file location must be provided for secure connection", HttpErrorType.SSL_ERROR);
            }
            String keyStorePassword = key.getStringValue(HttpConstants.SECURESOCKET_CONFIG_KEYSTORE_PASSWORD).getValue();
            if (keyStorePassword.isBlank()) {
                throw HttpUtil.createHttpError("KeyStore password must be provided for secure connection", HttpErrorType.SSL_ERROR);
            }
            sslConfiguration.setKeyStoreFile(keyStoreFile);
            sslConfiguration.setKeyStorePass(keyStorePassword);
        } else {
            BString keyPassword;
            String certFile = key.getStringValue(HttpConstants.SECURESOCKET_CONFIG_CERTKEY_CERT_FILE).getValue();
            String keyFile = key.getStringValue(HttpConstants.SECURESOCKET_CONFIG_CERTKEY_KEY_FILE).getValue();
            BString bString = keyPassword = key.containsKey((Object)HttpConstants.SECURESOCKET_CONFIG_CERTKEY_KEY_PASSWORD) ? key.getStringValue(HttpConstants.SECURESOCKET_CONFIG_CERTKEY_KEY_PASSWORD) : null;
            if (certFile.isBlank()) {
                throw HttpUtil.createHttpError("Certificate file location must be provided for secure connection", HttpErrorType.SSL_ERROR);
            }
            if (keyFile.isBlank()) {
                throw HttpUtil.createHttpError("Private key file location must be provided for secure connection", HttpErrorType.SSL_ERROR);
            }
            if (sslConfiguration instanceof ListenerConfiguration) {
                sslConfiguration.setServerCertificates(certFile);
                sslConfiguration.setServerKeyFile(keyFile);
                if (keyPassword != null && !keyPassword.getValue().isBlank()) {
                    sslConfiguration.setServerKeyPassword(keyPassword.getValue());
                }
            } else {
                sslConfiguration.setClientCertificates(certFile);
                sslConfiguration.setClientKeyFile(keyFile);
                if (keyPassword != null && !keyPassword.getValue().isBlank()) {
                    sslConfiguration.setClientKeyPassword(keyPassword.getValue());
                }
            }
        }
    }

    private static void evaluateCertField(Object cert, SslConfiguration sslConfiguration) {
        if (cert instanceof BMap) {
            BMap trustStore = (BMap)cert;
            String trustStoreFile = trustStore.getStringValue(HttpConstants.SECURESOCKET_CONFIG_TRUSTSTORE_FILE_PATH).getValue();
            String trustStorePassword = trustStore.getStringValue(HttpConstants.SECURESOCKET_CONFIG_TRUSTSTORE_PASSWORD).getValue();
            if (trustStoreFile.isBlank()) {
                throw HttpUtil.createHttpError("TrustStore file location must be provided for secure connection", HttpErrorType.SSL_ERROR);
            }
            if (trustStorePassword.isBlank()) {
                throw HttpUtil.createHttpError("TrustStore password must be provided for secure connection", HttpErrorType.SSL_ERROR);
            }
            sslConfiguration.setTrustStoreFile(trustStoreFile);
            sslConfiguration.setTrustStorePass(trustStorePassword);
        } else {
            String certFile = ((BString)cert).getValue();
            if (certFile.isBlank()) {
                throw HttpUtil.createHttpError("Certificate file location must be provided for secure connection", HttpErrorType.SSL_ERROR);
            }
            if (sslConfiguration instanceof ListenerConfiguration) {
                sslConfiguration.setServerTrustCertificates(certFile);
            } else {
                sslConfiguration.setClientTrustCertificates(certFile);
            }
        }
    }

    private static void evaluateProtocolField(BMap<BString, Object> protocol, SslConfiguration sslConfiguration, List<Parameter> paramList) {
        String sslProtocol;
        List<String> sslEnabledProtocolsValueList = Arrays.asList(protocol.getArrayValue(HttpConstants.SECURESOCKET_CONFIG_PROTOCOL_VERSIONS).getStringArray());
        if (!sslEnabledProtocolsValueList.isEmpty()) {
            String sslEnabledProtocols = sslEnabledProtocolsValueList.stream().collect(Collectors.joining(",", "", ""));
            Parameter serverProtocols = new Parameter("sslEnabledProtocols", sslEnabledProtocols);
            paramList.add(serverProtocols);
        }
        if (!(sslProtocol = protocol.getStringValue(HttpConstants.SECURESOCKET_CONFIG_PROTOCOL_NAME).getValue()).isBlank()) {
            sslConfiguration.setSSLProtocol(sslProtocol);
        }
        if (System.getProperty(JAVA_CONFIG_TLS_NAMED_GROUPS) == null) {
            System.setProperty(JAVA_CONFIG_TLS_NAMED_GROUPS, String.join((CharSequence)",", DEFAULT_NAMED_GROUPS));
        }
    }

    private static void evaluateCertValidationField(BMap<BString, Object> certValidation, SslConfiguration sslConfiguration) {
        String type = certValidation.getStringValue(HttpConstants.SECURESOCKET_CONFIG_CERT_VALIDATION_TYPE).getValue();
        if (type.equals(HttpConstants.SECURESOCKET_CONFIG_CERT_VALIDATION_TYPE_OCSP_STAPLING.getValue())) {
            sslConfiguration.setOcspStaplingEnabled(true);
        } else {
            sslConfiguration.setValidateCertEnabled(true);
        }
        long cacheSize = certValidation.getIntValue(HttpConstants.SECURESOCKET_CONFIG_CERT_VALIDATION_CACHE_SIZE).intValue();
        long cacheValidityPeriod = ((BDecimal)certValidation.get((Object)HttpConstants.SECURESOCKET_CONFIG_CERT_VALIDATION_CACHE_VALIDITY_PERIOD)).intValue();
        if (cacheValidityPeriod != 0L) {
            sslConfiguration.setCacheValidityPeriod(Math.toIntExact(cacheValidityPeriod));
        }
        if (cacheSize != 0L) {
            sslConfiguration.setCacheSize(Math.toIntExact(cacheSize));
        }
    }

    private static void evaluateCiphersField(BArray ciphers, List<Parameter> paramList) {
        String[] ciphersArray = ciphers.getStringArray();
        List<String> ciphersList = Arrays.asList(ciphersArray);
        if (ciphersList.size() > 0) {
            String ciphersString = ciphersList.stream().map(Object::toString).collect(Collectors.joining(",", "", ""));
            Parameter serverParameters = new Parameter("ciphers", ciphersString);
            paramList.add(serverParameters);
        }
    }

    private static void evaluateCommonFields(BMap<BString, Object> secureSocket, SslConfiguration sslConfiguration, List<Parameter> paramList) {
        if (!(sslConfiguration instanceof ListenerConfiguration)) {
            boolean hostNameVerificationEnabled = secureSocket.getBooleanValue(HttpConstants.SECURESOCKET_CONFIG_HOST_NAME_VERIFICATION_ENABLED);
            sslConfiguration.setHostNameVerificationEnabled(hostNameVerificationEnabled);
        }
        sslConfiguration.setSslSessionTimeOut((int)HttpUtil.getLongValueOrDefault(secureSocket, HttpConstants.SECURESOCKET_CONFIG_SESSION_TIMEOUT));
        sslConfiguration.setSslHandshakeTimeOut(HttpUtil.getLongValueOrDefault(secureSocket, HttpConstants.SECURESOCKET_CONFIG_HANDSHAKE_TIMEOUT));
        String enableSessionCreation = String.valueOf(secureSocket.getBooleanValue(HttpConstants.SECURESOCKET_CONFIG_SHARE_SESSION));
        Parameter enableSessionCreationParam = new Parameter(HttpConstants.SECURESOCKET_CONFIG_SHARE_SESSION.getValue(), enableSessionCreation);
        paramList.add(enableSessionCreationParam);
        if (secureSocket.containsKey((Object)HttpConstants.SECURESOCKET_CONFIG_SNI_HOST_NAME)) {
            Parameter sniHostNameParam = new Parameter(HttpConstants.SECURESOCKET_CONFIG_SNI_HOST_NAME.getValue(), String.valueOf(secureSocket.getStringValue(HttpConstants.SECURESOCKET_CONFIG_SNI_HOST_NAME)));
            paramList.add(sniHostNameParam);
        }
    }

    private static BMap<BString, Object> getBMapValueIfPresent(BMap<BString, Object> map, BString key) {
        return map.containsKey((Object)key) ? map.getMapValue(key) : null;
    }

    private static long getLongValueOrDefault(BMap<BString, Object> map, BString key) {
        return map.containsKey((Object)key) ? ((BDecimal)map.get((Object)key)).intValue() : 0L;
    }

    public static String getServiceName(BObject balService) {
        String serviceTypeName = balService.getType().getName();
        int serviceIndex = serviceTypeName.lastIndexOf("$$service$");
        return serviceTypeName.substring(0, serviceIndex);
    }

    public static String unescapeAndEncodeValue(String segment) {
        if (segment.length() > 1 && segment.startsWith("'")) {
            segment = segment.substring(1);
        }
        if (!segment.contains("\\")) {
            return segment;
        }
        return HttpUtil.encodeString(segment.replace("\\", ""));
    }

    public static String encodeString(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.name()).replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new BallerinaConnectorException("Error while encoding value: " + value, e);
        }
    }

    public static String getInterceptorServiceType(BObject interceptorService) {
        String interceptorServiceType = null;
        ObjectType objectType = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)interceptorService));
        List typeIdList = objectType.getTypeIdSet().getIds();
        for (TypeId typeId : typeIdList) {
            switch (typeId.getName()) {
                case "RequestInterceptor": {
                    interceptorServiceType = "RequestInterceptor";
                    break;
                }
                case "RequestErrorInterceptor": {
                    interceptorServiceType = "RequestErrorInterceptor";
                    break;
                }
                case "ResponseInterceptor": {
                    interceptorServiceType = "ResponseInterceptor";
                    break;
                }
                case "ResponseErrorInterceptor": {
                    interceptorServiceType = "ResponseErrorInterceptor";
                    break;
                }
            }
        }
        return interceptorServiceType;
    }

    public static String getPrintableErrorMsg(BError err) {
        Object errorMsg = err.getMessage() != null ? err.getMessage() : "";
        Object details = err.getDetails();
        if (details != null && !details.toString().equals("{}")) {
            errorMsg = (String)errorMsg + ", " + details.toString();
        }
        return errorMsg;
    }

    public static Type[] getParameterTypes(FunctionType function) {
        io.ballerina.runtime.api.types.Parameter[] params = function.getParameters();
        Type[] paramTypes = new Type[params.length];
        for (int i = 0; i < params.length; ++i) {
            paramTypes[i] = TypeUtils.getReferredType((Type)params[i].type);
        }
        return paramTypes;
    }

    public static Type[] getOriginalParameterTypes(FunctionType function) {
        io.ballerina.runtime.api.types.Parameter[] params = function.getParameters();
        Type[] paramTypes = new Type[params.length];
        for (int i = 0; i < params.length; ++i) {
            paramTypes[i] = params[i].type;
        }
        return paramTypes;
    }

    public static boolean isHttpStatusCodeResponseTypeWithBody(Type type) {
        if (type instanceof RecordType) {
            Map recordFields = ((RecordType)type).getFields();
            Field statusField = (Field)recordFields.get("status");
            Field bodyField = (Field)recordFields.get("body");
            return Objects.nonNull(statusField) && statusField.getFieldType().getTag() == 47 && Objects.nonNull(bodyField);
        }
        return false;
    }

    public static boolean hasEventStreamContentType(HttpCarbonMessage message) {
        String contentType = HttpUtil.getContentTypeFromTransportMessage(message);
        return contentType != null && contentType.startsWith("text/event-stream");
    }

    private HttpUtil() {
    }
}

