/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api;

import io.ballerina.runtime.api.values.BError;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpIntrospectionResource;
import io.ballerina.stdlib.http.api.HttpSwaggerUiResource;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.Resource;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.ballerina.stdlib.http.uri.DispatcherUtil;
import io.ballerina.stdlib.http.uri.parser.DataElement;
import io.ballerina.stdlib.http.uri.parser.DataReturnAgent;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ResourceDataElement
implements DataElement<Resource, HttpCarbonMessage> {
    private List<Resource> resource;
    private boolean isFirstTraverse = true;
    private boolean hasData = false;

    @Override
    public boolean hasData() {
        return this.hasData;
    }

    @Override
    public void setData(Resource newResource) {
        if (this.isFirstTraverse) {
            this.resource = new ArrayList<Resource>();
            this.resource.add(newResource);
            this.isFirstTraverse = false;
            this.hasData = true;
            return;
        }
        List<String> newMethods = newResource.getMethods();
        if (newMethods == null) {
            for (Resource previousResource : this.resource) {
                if (previousResource.getMethods() != null) continue;
                throw HttpUtil.createHttpError("Two resources have the same addressable URI, " + previousResource.getName() + " and " + newResource.getName(), HttpErrorType.GENERIC_LISTENER_ERROR);
            }
            this.resource.add(newResource);
            this.hasData = true;
            return;
        }
        this.resource.forEach(r -> {
            for (String newMethod : newMethods) {
                if (!DispatcherUtil.isMatchingMethodExist(r, newMethod)) continue;
                if (r.getName().equals(HttpIntrospectionResource.getResourceId())) {
                    String message = "Resources cannot have the accessor and name as same as the auto generated Open API spec retrieval resource: '" + r.getName() + "'";
                    throw HttpUtil.createHttpError(message, HttpErrorType.GENERIC_LISTENER_ERROR);
                }
                if (r.getName().equals(HttpSwaggerUiResource.getResourceId())) {
                    String message = "Resources cannot have the accessor and name as same as the auto generated Swagger-UI retrieval resource: '" + r.getName() + "'";
                    throw HttpUtil.createHttpError(message, HttpErrorType.GENERIC_LISTENER_ERROR);
                }
                throw HttpUtil.createHttpError("Two resources have the same addressable URI, " + r.getName() + " and " + newResource.getName(), HttpErrorType.GENERIC_LISTENER_ERROR);
            }
        });
        this.resource.add(newResource);
        this.hasData = true;
    }

    @Override
    public boolean getData(HttpCarbonMessage carbonMessage, DataReturnAgent<Resource> dataReturnAgent) {
        try {
            if (this.resource == null) {
                return false;
            }
            Resource httpResource = this.validateHTTPMethod(this.resource, carbonMessage);
            if (httpResource == null) {
                return this.isOptionsRequest(carbonMessage);
            }
            this.validateConsumes(httpResource, carbonMessage);
            this.validateProduces(httpResource, carbonMessage);
            dataReturnAgent.setData(httpResource);
            return true;
        }
        catch (BError e) {
            dataReturnAgent.setError(e);
            return false;
        }
    }

    private boolean isOptionsRequest(HttpCarbonMessage inboundMessage) {
        return inboundMessage.getHeader(HttpHeaderNames.ALLOW.toString()) != null;
    }

    private Resource validateHTTPMethod(List<Resource> resources, HttpCarbonMessage carbonMessage) {
        Resource httpResource = null;
        boolean isOptionsRequest = false;
        String httpMethod = carbonMessage.getHttpMethod();
        for (Resource resourceInfo : resources) {
            if (!DispatcherUtil.isMatchingMethodExist(resourceInfo, httpMethod)) continue;
            httpResource = resourceInfo;
            break;
        }
        if (httpResource == null) {
            httpResource = this.tryMatchingToDefaultVerb(resources);
        }
        if (httpResource == null) {
            isOptionsRequest = this.setAllowHeadersIfOPTIONS(resources, httpMethod, carbonMessage);
        }
        if (httpResource != null) {
            return httpResource;
        }
        if (!isOptionsRequest) {
            throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_RESOURCE_METHOD_NOT_ALLOWED_ERROR, "Method not allowed");
        }
        return null;
    }

    private Resource tryMatchingToDefaultVerb(List<Resource> resources) {
        for (Resource resourceInfo : resources) {
            if (resourceInfo.getMethods() != null) continue;
            return resourceInfo;
        }
        return null;
    }

    private boolean setAllowHeadersIfOPTIONS(List<Resource> resources, String httpMethod, HttpCarbonMessage cMsg) {
        if (httpMethod.equals("OPTIONS")) {
            cMsg.setHeader(HttpHeaderNames.ALLOW.toString(), this.getAllowHeaderValues(resources, cMsg));
            return true;
        }
        return false;
    }

    private String getAllowHeaderValues(List<Resource> resources, HttpCarbonMessage cMsg) {
        List<String> methods = new ArrayList<String>();
        ArrayList<Resource> resourceInfos = new ArrayList<Resource>();
        for (Resource resourceInfo : resources) {
            if (resourceInfo.getMethods() != null) {
                methods.addAll(resourceInfo.getMethods());
            }
            resourceInfos.add(resourceInfo);
        }
        cMsg.setProperty("PREFLIGHT_RESOURCES", resourceInfos);
        methods = DispatcherUtil.validateAllowMethods(methods);
        return DispatcherUtil.concatValues(methods, false);
    }

    private void validateConsumes(Resource resource, HttpCarbonMessage cMsg) {
        String contentMediaType = this.extractContentMediaType(cMsg.getHeader(HttpHeaderNames.CONTENT_TYPE.toString()));
        List<String> consumesList = resource.getConsumes();
        if (consumesList == null || consumesList.isEmpty()) {
            return;
        }
        contentMediaType = contentMediaType != null ? contentMediaType : "value";
        for (String consumeType : consumesList) {
            if (!contentMediaType.equalsIgnoreCase(consumeType.trim())) continue;
            return;
        }
        String message = "content-type : " + contentMediaType + " is not supported";
        throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_UNSUPPORTED_REQUEST_MEDIA_TYPE_ERROR, message);
    }

    private String extractContentMediaType(String header) {
        if (header == null) {
            return null;
        }
        if (header.contains(";")) {
            header = header.substring(0, header.indexOf(59)).trim();
        }
        return header;
    }

    private void validateProduces(Resource resource, HttpCarbonMessage cMsg) {
        List<String> acceptMediaTypes = this.extractAcceptMediaTypes(cMsg.getHeader(HttpHeaderNames.ACCEPT.toString()));
        List<String> producesList = resource.getProduces();
        if (producesList == null || producesList.isEmpty() || acceptMediaTypes == null) {
            return;
        }
        if (acceptMediaTypes.contains("*/*")) {
            return;
        }
        if (acceptMediaTypes.stream().anyMatch(mediaType -> mediaType.contains("/*"))) {
            List subTypeWildCardMediaTypes = acceptMediaTypes.stream().filter(mediaType -> mediaType.contains("/*")).map(mediaType -> mediaType.substring(0, mediaType.indexOf(47))).collect(Collectors.toList());
            for (String token : resource.getProducesSubTypes()) {
                if (!subTypeWildCardMediaTypes.contains(token)) continue;
                return;
            }
        }
        List noWildCardMediaTypes = acceptMediaTypes.stream().filter(mediaType -> !mediaType.contains("/*")).collect(Collectors.toList());
        for (String produceType : producesList) {
            if (!noWildCardMediaTypes.stream().anyMatch(produceType::equalsIgnoreCase)) continue;
            return;
        }
        throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_REQUEST_NOT_ACCEPTABLE_ERROR, "Request is not acceptable");
    }

    private List<String> extractAcceptMediaTypes(String header) {
        if (header == null) {
            return null;
        }
        List<String> acceptMediaTypes = new ArrayList<String>();
        if (header.contains(",")) {
            acceptMediaTypes = Arrays.stream(header.split(",")).map(mediaRange -> mediaRange.contains(";") ? mediaRange.substring(0, mediaRange.indexOf(59)) : mediaRange).map(String::trim).distinct().collect(Collectors.toList());
        } else if (header.contains(";")) {
            acceptMediaTypes.add(header.substring(0, header.indexOf(59)).trim());
        } else {
            acceptMediaTypes.add(header.trim());
        }
        return acceptMediaTypes;
    }
}

