/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api;

import io.ballerina.stdlib.http.api.CorsHeaderGenerator;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpIntrospectionResource;
import io.ballerina.stdlib.http.api.HttpOASResource;
import io.ballerina.stdlib.http.api.HttpResourceArguments;
import io.ballerina.stdlib.http.api.HttpSwaggerUiResource;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.Resource;
import io.ballerina.stdlib.http.api.Service;
import io.ballerina.stdlib.http.api.nativeimpl.pipelining.PipeliningHandler;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.ballerina.stdlib.http.uri.DispatcherUtil;
import io.ballerina.stdlib.http.uri.URITemplateException;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;

public class ResourceDispatcher {
    public static Resource findResource(Service service, HttpCarbonMessage inboundRequest) {
        String method = inboundRequest.getHttpMethod();
        String subPath = (String)inboundRequest.getProperty("SUB_PATH");
        subPath = ResourceDispatcher.sanitizeSubPath(subPath);
        HttpResourceArguments resourceArgumentValues = new HttpResourceArguments();
        try {
            Resource resource = service.getUriTemplate().matches(subPath, resourceArgumentValues, inboundRequest);
            if (resource instanceof HttpIntrospectionResource) {
                HttpIntrospectionResource introspectionResource = (HttpIntrospectionResource)resource;
                ResourceDispatcher.handleOasResourceRequest(inboundRequest, introspectionResource);
                return null;
            }
            if (resource instanceof HttpSwaggerUiResource) {
                HttpSwaggerUiResource swaggerUiResource = (HttpSwaggerUiResource)resource;
                ResourceDispatcher.handleOasResourceRequest(inboundRequest, swaggerUiResource);
                return null;
            }
            if (resource != null) {
                inboundRequest.setProperty("RESOURCE_ARGS", resourceArgumentValues);
                inboundRequest.setProperty("RESOURCES_CORS", resource.getCorsHeaders());
                return resource;
            }
            if (!method.equals("OPTIONS")) {
                String message = "no matching resource found for path : " + String.valueOf(inboundRequest.getProperty("TO")) + " , method : " + method;
                throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_RESOURCE_NOT_FOUND_ERROR, message);
            }
            ResourceDispatcher.handleOptionsRequest(inboundRequest, service);
            return null;
        }
        catch (URITemplateException e) {
            throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_RESOURCE_DISPATCHING_SERVER_ERROR, e.getMessage());
        }
    }

    private static String sanitizeSubPath(String subPath) {
        if ("/".equals(subPath)) {
            return subPath;
        }
        if (!((String)subPath).startsWith("/")) {
            subPath = "/" + (String)subPath;
        }
        subPath = ((String)subPath).endsWith("/") ? ((String)subPath).substring(0, ((String)subPath).length() - 1) : subPath;
        return subPath;
    }

    private static void handleOptionsRequest(HttpCarbonMessage cMsg, Service service) {
        HttpCarbonMessage response = HttpUtil.createHttpCarbonMessage(false);
        if (cMsg.getHeader(HttpHeaderNames.ALLOW.toString()) != null) {
            response.setHeader(HttpHeaderNames.ALLOW.toString(), cMsg.getHeader(HttpHeaderNames.ALLOW.toString()));
        } else if (service.getBasePath().equals(cMsg.getProperty("TO")) && !service.getAllAllowedMethods().isEmpty()) {
            response.setHeader(HttpHeaderNames.ALLOW.toString(), DispatcherUtil.concatValues(service.getAllAllowedMethods(), false));
        } else {
            String message = "no matching resource found for path : " + String.valueOf(cMsg.getProperty("TO")) + " , method : OPTIONS";
            throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_RESOURCE_NOT_FOUND_ERROR, message);
        }
        CorsHeaderGenerator.process(cMsg, response, false);
        String introspectionResourcePathHeaderValue = service.getOasResourceLink();
        if (introspectionResourcePathHeaderValue != null) {
            response.setHeader("link", introspectionResourcePathHeaderValue);
        }
        response.setHttpStatusCode(204);
        response.addHttpContent((HttpContent)new DefaultLastHttpContent());
        PipeliningHandler.sendPipelinedResponse(cMsg, response);
        cMsg.waitAndReleaseAllEntities();
    }

    private static void handleOasResourceRequest(HttpCarbonMessage cMsg, HttpOASResource resource) {
        HttpCarbonMessage response = HttpUtil.createHttpCarbonMessage(false);
        response.waitAndReleaseAllEntities();
        response.addHttpContent((HttpContent)new DefaultLastHttpContent(Unpooled.wrappedBuffer((byte[])resource.getPayload())));
        response.setHeader(HttpHeaderNames.CONTENT_TYPE.toString(), resource.getContentType());
        response.setHttpStatusCode(200);
        PipeliningHandler.sendPipelinedResponse(cMsg, response);
        cMsg.waitAndReleaseAllEntities();
    }

    private ResourceDispatcher() {
    }
}

