/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.api.HttpConstants;
import io.ballerina.stdlib.http.api.nativeimpl.ModuleUtils;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.ballerina.stdlib.mime.util.MimeUtil;
import java.net.InetSocketAddress;

public class ValueCreatorUtils {
    public static BObject createRequestObject() {
        return ValueCreatorUtils.createObjectValue(ModuleUtils.getHttpPackage(), "Request", new Object[0]);
    }

    public static BObject createResponseObject() {
        return ValueCreatorUtils.createObjectValue(ModuleUtils.getHttpPackage(), "Response", new Object[0]);
    }

    public static BObject createEntityObject() {
        return ValueCreatorUtils.createObjectValue(MimeUtil.getMimePackage(), "Entity", new Object[0]);
    }

    public static BObject createRequestCacheControlObject() {
        return ValueCreatorUtils.createObjectValue(ModuleUtils.getHttpPackage(), "RequestCacheControl", new Object[0]);
    }

    public static BObject createCallerObject(HttpCarbonMessage inboundMsg, String resourceAccessor) {
        Object localSocketAddress;
        BMap<BString, Object> remote = ValueCreatorUtils.createHTTPRecordValue("Remote");
        BMap<BString, Object> local = ValueCreatorUtils.createHTTPRecordValue("Local");
        Object remoteSocketAddress = inboundMsg.getProperty("REMOTE_ADDRESS");
        if (remoteSocketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)remoteSocketAddress;
            String remoteHost = inetSocketAddress.getHostString();
            long remotePort = inetSocketAddress.getPort();
            String remoteIP = inetSocketAddress.getAddress().getHostAddress();
            remote.put((Object)HttpConstants.REMOTE_HOST_FIELD, (Object)StringUtils.fromString((String)remoteHost));
            remote.put((Object)HttpConstants.REMOTE_PORT_FIELD, (Object)remotePort);
            remote.put((Object)HttpConstants.REMOTE_IP_FIELD, (Object)StringUtils.fromString((String)remoteIP));
        }
        if ((localSocketAddress = inboundMsg.getProperty("LOCAL_ADDRESS")) instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)localSocketAddress;
            String localHost = inetSocketAddress.getHostString();
            long localPort = inetSocketAddress.getPort();
            String localIP = inetSocketAddress.getAddress().getHostAddress();
            local.put((Object)HttpConstants.LOCAL_HOST_FIELD, (Object)StringUtils.fromString((String)localHost));
            local.put((Object)HttpConstants.LOCAL_PORT_FIELD, (Object)localPort);
            local.put((Object)HttpConstants.LOCAL_IP_FIELD, (Object)StringUtils.fromString((String)localIP));
        }
        return ValueCreator.createObjectValue((Module)ModuleUtils.getHttpPackage(), (String)"Caller", (Object[])new Object[]{remote, local, StringUtils.fromString((String)((String)inboundMsg.getProperty("PROTOCOL"))), StringUtils.fromString((String)resourceAccessor)});
    }

    static BObject createHeadersObject() {
        return ValueCreatorUtils.createObjectValue(ModuleUtils.getHttpPackage(), "Headers", new Object[0]);
    }

    static BObject createRequestContextObject() {
        return ValueCreatorUtils.createObjectValue(ModuleUtils.getHttpPackage(), "RequestContext", new Object[0]);
    }

    public static BMap<BString, Object> createHTTPRecordValue(String recordTypeName) {
        return ValueCreator.createRecordValue((Module)ModuleUtils.getHttpPackage(), (String)recordTypeName);
    }

    public static Object createStatusCodeObject(String statusCodeObjName) {
        return ValueCreatorUtils.createObjectValue(ModuleUtils.getHttpPackage(), statusCodeObjName, new Object[0]);
    }

    public static Object createDefaultStatusCodeObject(long statusCode) {
        return ValueCreatorUtils.createObjectValue(ModuleUtils.getHttpPackage(), "DefaultStatus", statusCode);
    }

    private static BObject createObjectValue(Module module, String objectTypeName, Object ... fieldValues) {
        if (fieldValues.length > 0) {
            Object[] fields = new Object[fieldValues.length];
            System.arraycopy(fieldValues, 0, fields, 0, fieldValues.length);
            return ValueCreator.createObjectValue((Module)module, (String)objectTypeName, (Object[])fields);
        }
        return ValueCreator.createObjectValue((Module)module, (String)objectTypeName, (Object[])new Object[0]);
    }

    private ValueCreatorUtils() {
    }
}

