/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.logging.accesslog;

import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.api.HttpConstants;
import io.ballerina.stdlib.http.api.logging.accesslog.HttpAccessLogFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class HttpAccessLogConfig {
    private static final HttpAccessLogConfig instance = new HttpAccessLogConfig();
    private final Set<String> excludedAttributes = new HashSet<String>(List.of("http_referrer", "http_user_agent", "http_x_forwarded_for"));
    private BMap accessLogConfig;

    private HttpAccessLogConfig() {
    }

    public static HttpAccessLogConfig getInstance() {
        return instance;
    }

    public void initializeHttpAccessLogConfig(BMap accessLogConfig) {
        this.accessLogConfig = accessLogConfig;
    }

    public List<String> getCustomHeaders() {
        List<String> attributes = this.getAccessLogAttributes();
        return attributes.stream().filter(attr -> attr.startsWith("http_") && !this.excludedAttributes.contains(attr)).map(attr -> attr.substring(5)).collect(Collectors.toList());
    }

    public HttpAccessLogFormat getAccessLogFormat() {
        BString logFormat;
        if (this.accessLogConfig != null && (logFormat = this.accessLogConfig.getStringValue(HttpConstants.HTTP_LOG_FORMAT)).getValue().equals("json")) {
            return HttpAccessLogFormat.JSON;
        }
        return HttpAccessLogFormat.FLAT;
    }

    public List<String> getAccessLogAttributes() {
        BArray logAttributes;
        if (this.accessLogConfig != null && (logAttributes = this.accessLogConfig.getArrayValue(HttpConstants.HTTP_LOG_ATTRIBUTES)) != null) {
            return Arrays.stream(logAttributes.getStringArray()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

