/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.logging.accesslog;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ballerina.stdlib.http.api.logging.accesslog.HttpAccessLogFormat;
import io.ballerina.stdlib.http.api.logging.accesslog.HttpAccessLogMessage;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class HttpAccessLogFormatter {
    private HttpAccessLogFormatter() {
    }

    public static String formatAccessLogMessage(HttpAccessLogMessage inboundMessage, List<HttpAccessLogMessage> outboundMessages, HttpAccessLogFormat format, List<String> attributes) {
        Map<String, String> inboundMap = HttpAccessLogFormatter.mapAccessLogMessage(inboundMessage, format, attributes);
        if (format == HttpAccessLogFormat.FLAT) {
            String inboundFormatted = inboundMap.values().stream().filter(Objects::nonNull).collect(Collectors.joining(" "));
            if (!outboundMessages.isEmpty()) {
                String outboundFormatted = outboundMessages.stream().map(outboundMsg -> HttpAccessLogFormatter.mapAccessLogMessage(outboundMsg, format, attributes)).map(outboundMap -> outboundMap.values().stream().filter(Objects::nonNull).collect(Collectors.joining(" "))).collect(Collectors.joining(" "));
                return inboundFormatted + " \"~\" " + outboundFormatted;
            }
            return inboundFormatted;
        }
        Gson gson = new Gson();
        JsonObject jsonObject = new JsonObject();
        inboundMap.forEach((arg_0, arg_1) -> ((JsonObject)jsonObject).addProperty(arg_0, arg_1));
        if (!outboundMessages.isEmpty()) {
            JsonArray upstreamArray = new JsonArray();
            for (HttpAccessLogMessage outboundMessage : outboundMessages) {
                Map<String, String> outboundMap2 = HttpAccessLogFormatter.mapAccessLogMessage(outboundMessage, format, attributes);
                JsonObject outboundJson = gson.toJsonTree(outboundMap2).getAsJsonObject();
                upstreamArray.add((JsonElement)outboundJson);
            }
            jsonObject.add("upstream", (JsonElement)upstreamArray);
        }
        return gson.toJson((JsonElement)jsonObject);
    }

    private static Map<String, String> mapAccessLogMessage(HttpAccessLogMessage httpAccessLogMessage, HttpAccessLogFormat format, List<String> attributes) {
        List<String> allAttributes = List.of("ip", "date_time", "request", "request_method", "request_uri", "scheme", "status", "request_body_size", "response_body_size", "request_time", "http_referrer", "http_user_agent", "http_x_forwarded_for");
        List<String> defaultAttributes = List.of("ip", "date_time", "request", "status", "response_body_size", "http_referrer", "http_user_agent");
        LinkedHashMap<String, String> attributeValues = new LinkedHashMap<String, String>();
        allAttributes.forEach(attr -> attributeValues.put((String)attr, (String)null));
        if (!attributes.isEmpty()) {
            attributes.forEach(attr -> attributeValues.put((String)attr, HttpAccessLogFormatter.formatAccessLogAttribute(httpAccessLogMessage, format, attr)));
        } else {
            defaultAttributes.forEach(attr -> attributeValues.put((String)attr, HttpAccessLogFormatter.formatAccessLogAttribute(httpAccessLogMessage, format, attr)));
        }
        return attributeValues;
    }

    private static String formatAccessLogAttribute(HttpAccessLogMessage httpAccessLogMessage, HttpAccessLogFormat format, String attribute) {
        return switch (attribute) {
            case "ip" -> httpAccessLogMessage.getIp();
            case "date_time" -> String.format(format == HttpAccessLogFormat.FLAT ? "[%1$td/%1$tb/%1$tY:%1$tT.%1$tL %1$tz]" : "%1$td/%1$tb/%1$tY:%1$tT.%1$tL %1$tz", httpAccessLogMessage.getDateTime());
            case "request_method" -> httpAccessLogMessage.getRequestMethod();
            case "request_uri" -> httpAccessLogMessage.getRequestUri();
            case "scheme" -> httpAccessLogMessage.getScheme();
            case "request" -> String.format(format == HttpAccessLogFormat.FLAT ? "\"%1$s %2$s %3$s\"" : "%1$s %2$s %3$s", httpAccessLogMessage.getRequestMethod(), httpAccessLogMessage.getRequestUri(), httpAccessLogMessage.getScheme());
            case "status" -> String.valueOf(httpAccessLogMessage.getStatus());
            case "request_body_size" -> String.valueOf(httpAccessLogMessage.getRequestBodySize());
            case "response_body_size" -> String.valueOf(httpAccessLogMessage.getResponseBodySize());
            case "request_time" -> String.valueOf(httpAccessLogMessage.getRequestTime());
            case "http_referrer" -> String.format(format == HttpAccessLogFormat.FLAT ? "\"%1$s\"" : "%1$s", HttpAccessLogFormatter.getHyphenForNull(httpAccessLogMessage.getHttpReferrer()));
            case "http_user_agent" -> String.format(format == HttpAccessLogFormat.FLAT ? "\"%1$s\"" : "%1$s", HttpAccessLogFormatter.getHyphenForNull(httpAccessLogMessage.getHttpUserAgent()));
            case "http_x_forwarded_for" -> String.format(format == HttpAccessLogFormat.FLAT ? "\"%1$s\"" : "%1$s", HttpAccessLogFormatter.getHyphenForNull(httpAccessLogMessage.getHttpXForwardedFor()));
            default -> HttpAccessLogFormatter.getCustomHeaderValueForAttribute(httpAccessLogMessage, format, attribute);
        };
    }

    private static String getCustomHeaderValueForAttribute(HttpAccessLogMessage httpAccessLogMessage, HttpAccessLogFormat format, String attribute) {
        Map<String, String> customHeaders = httpAccessLogMessage.getCustomHeaders();
        if (attribute.startsWith("http_")) {
            String customHeaderKey = attribute.substring(5);
            for (Map.Entry<String, String> entry : customHeaders.entrySet()) {
                if (!entry.getKey().equalsIgnoreCase(customHeaderKey)) continue;
                String value = entry.getValue();
                return format == HttpAccessLogFormat.FLAT ? String.format("\"%s\"", value) : value;
            }
            return format == HttpAccessLogFormat.FLAT ? "\"-\"" : "-";
        }
        return null;
    }

    private static String getHyphenForNull(String value) {
        return value == null ? "-" : value;
    }
}

