/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.service.signature;

import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.stdlib.constraint.Constraints;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.service.signature.HeaderRecordParam;
import io.ballerina.stdlib.http.api.service.signature.ParamUtils;
import io.ballerina.stdlib.http.api.service.signature.SignatureParam;
import java.util.ArrayList;
import java.util.Map;

public class HeaderParam
extends SignatureParam {
    private String headerName;
    private HeaderRecordParam recordParam;
    private boolean nilable;

    HeaderParam(String token) {
        super(token);
    }

    public void initHeaderParam(Type originalType, int index, boolean requireConstraintValidation) {
        this.init(originalType, index, requireConstraintValidation);
        this.nilable = originalType.isNilable();
        this.populateHeaderParamTypeTag(originalType);
    }

    private void populateHeaderParamTypeTag(Type type) {
        RecordType headerRecordType = ParamUtils.getRecordType(type);
        if (headerRecordType != null) {
            this.setEffectiveTypeTag(24);
            Map recordFields = headerRecordType.getFields();
            ArrayList<String> keys = new ArrayList<String>();
            HeaderRecordParam.FieldParam[] fields = new HeaderRecordParam.FieldParam[recordFields.size()];
            int i = 0;
            for (Map.Entry field : recordFields.entrySet()) {
                keys.add((String)field.getKey());
                fields[i++] = new HeaderRecordParam.FieldParam(((Field)field.getValue()).getFieldType());
            }
            this.recordParam = new HeaderRecordParam(this.getToken(), (Type)headerRecordType, keys, fields);
        } else {
            this.setEffectiveTypeTag(ParamUtils.getEffectiveTypeTag(this.getOriginalType(), this.getOriginalType(), "header"));
            this.setArray(ParamUtils.isArrayType(this.getOriginalType()));
        }
    }

    public boolean isNilable() {
        return this.nilable;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public HeaderRecordParam getRecordParam() {
        return this.recordParam;
    }

    public boolean isRecord() {
        return this.getRecordParam() != null;
    }

    @Override
    public Object validateConstraints(Object headerValue) {
        Object result;
        if (this.requireConstraintValidation() && (result = Constraints.validateAfterTypeConversion((Object)headerValue, (Type)this.getOriginalType())) instanceof BError) {
            String message = "header validation failed: " + HttpUtil.getPrintableErrorMsg((BError)((Object)result));
            throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_HEADER_VALIDATION_LISTENER_ERROR, message);
        }
        return headerValue;
    }
}

