/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contract.config;

import io.ballerina.stdlib.http.transport.contract.config.ListenerConfiguration;
import io.ballerina.stdlib.http.transport.contractimpl.common.Util;
import java.util.Map;

public class ServerBootstrapConfiguration {
    private final boolean tcpNoDelay;
    private final boolean keepAlive;
    private final boolean socketReuse;
    private final int connectTimeOut;
    private final int receiveBufferSize;
    private final int sendBufferSize;
    private final int soBackLog;

    public ServerBootstrapConfiguration(ListenerConfiguration listenerConfiguration) {
        this.connectTimeOut = listenerConfiguration.getConnectTimeOut();
        this.receiveBufferSize = listenerConfiguration.getReceiveBufferSize();
        this.sendBufferSize = listenerConfiguration.getSendBufferSize();
        this.tcpNoDelay = listenerConfiguration.isTcpNoDelay();
        this.socketReuse = listenerConfiguration.isSocketReuse();
        this.keepAlive = listenerConfiguration.isSocketKeepAlive();
        this.soBackLog = listenerConfiguration.getSoBackLog();
    }

    public ServerBootstrapConfiguration(Map<String, Object> properties) {
        this.connectTimeOut = Util.getIntProperty(properties, "server.bootstrap.connect.timeout", 15000);
        this.keepAlive = Util.getBooleanProperty(properties, "server.bootstrap.keepalive", true);
        this.receiveBufferSize = Util.getIntProperty(properties, "server.bootstrap.recievebuffersize", 0x100000);
        this.sendBufferSize = Util.getIntProperty(properties, "server.bootstrap.sendbuffersize", 0x100000);
        this.tcpNoDelay = Util.getBooleanProperty(properties, "server.bootstrap.nodelay", true);
        this.socketReuse = Util.getBooleanProperty(properties, "server.bootstrap.socket.reuse", true);
        this.soBackLog = Util.getIntProperty(properties, "server.bootstrap.socket.backlog", 100);
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public int getConnectTimeOut() {
        return this.connectTimeOut;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public boolean isSocketReuse() {
        return this.socketReuse;
    }

    public int getSoBackLog() {
        return this.soBackLog;
    }
}

