/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.listener.states;

import io.ballerina.stdlib.http.transport.contract.HttpResponseFuture;
import io.ballerina.stdlib.http.transport.contract.ServerConnectorFuture;
import io.ballerina.stdlib.http.transport.contract.config.ChunkConfig;
import io.ballerina.stdlib.http.transport.contract.exceptions.ServerConnectorException;
import io.ballerina.stdlib.http.transport.contractimpl.HttpOutboundRespListener;
import io.ballerina.stdlib.http.transport.contractimpl.common.Util;
import io.ballerina.stdlib.http.transport.contractimpl.common.states.StateUtil;
import io.ballerina.stdlib.http.transport.contractimpl.listener.SourceHandler;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.ListenerReqRespStateManager;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.ReceivingEntityBody;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.SendingHeaders;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Response100ContinueSent
extends SendingHeaders {
    private static final Logger LOG = LoggerFactory.getLogger(Response100ContinueSent.class);
    private final ListenerReqRespStateManager listenerReqRespStateManager;
    private final HttpOutboundRespListener outboundResponseListener;
    private final SourceHandler sourceHandler;
    private final float httpVersion;

    Response100ContinueSent(ListenerReqRespStateManager listenerReqRespStateManager, SourceHandler sourceHandler, HttpOutboundRespListener outboundResponseListener) {
        super(listenerReqRespStateManager, outboundResponseListener);
        this.listenerReqRespStateManager = listenerReqRespStateManager;
        this.sourceHandler = sourceHandler;
        this.outboundResponseListener = outboundResponseListener;
        this.chunkConfig = outboundResponseListener.getChunkConfig();
        this.keepAlive = outboundResponseListener.isKeepAlive();
        this.httpVersion = Float.parseFloat(outboundResponseListener.getRequestDataHolder().getHttpVersion());
    }

    @Override
    public void readInboundRequestHeaders(HttpCarbonMessage inboundRequestMsg, HttpRequest inboundRequestHeaders) {
        LOG.warn("readInboundRequestHeaders {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void readInboundRequestBody(Object inboundRequestEntityBody) throws ServerConnectorException {
        this.listenerReqRespStateManager.state = new ReceivingEntityBody(this.listenerReqRespStateManager, this.outboundResponseListener.getInboundRequestMsg(), this.sourceHandler, this.httpVersion);
        this.listenerReqRespStateManager.readInboundRequestBody(inboundRequestEntityBody);
    }

    @Override
    public void writeOutboundResponseHeaders(HttpCarbonMessage outboundResponseMsg, HttpContent httpContent) {
        LOG.warn("writeOutboundResponseHeaders {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void writeOutboundResponseBody(HttpOutboundRespListener outboundRespListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent) {
        ChunkConfig responseChunkConfig;
        ChunkConfig chunkConfig = responseChunkConfig = outboundResponseMsg.getProperty("chunking_config") != null ? (ChunkConfig)((Object)outboundResponseMsg.getProperty("chunking_config")) : null;
        if (responseChunkConfig != null) {
            super.setChunkConfig(responseChunkConfig);
        }
        this.outboundRespStatusFuture = this.outboundResponseListener.getInboundRequestMsg().getHttpOutboundRespStatusFuture();
        if (this.chunkConfig == ChunkConfig.ALWAYS && StateUtil.checkChunkingCompatibility(String.valueOf(this.httpVersion), this.chunkConfig)) {
            Util.setupChunkedRequest(outboundResponseMsg);
            ChannelFuture outboundHeaderFuture = this.writeResponseHeaders(outboundResponseMsg, this.keepAlive);
            StateUtil.notifyIfHeaderWriteFailure(this.outboundRespStatusFuture, outboundHeaderFuture, "Remote client closed the connection before initiating outbound response");
        } else {
            CompositeByteBuf allContent = Unpooled.compositeBuffer();
            allContent.addComponent(true, httpContent.content());
            HttpResponse fullOutboundResponse = Util.createFullHttpResponse(outboundResponseMsg, outboundRespListener.getRequestDataHolder().getHttpVersion(), outboundRespListener.getServerName(), outboundRespListener.isKeepAlive(), (ByteBuf)allContent);
            ChannelFuture outboundHeaderFuture = outboundRespListener.getSourceContext().writeAndFlush((Object)fullOutboundResponse);
            this.checkForResponseWriteStatus(outboundRespListener.getInboundRequestMsg(), this.outboundRespStatusFuture, outboundHeaderFuture);
        }
    }

    @Override
    public void handleAbruptChannelClosure(ServerConnectorFuture serverConnectorFuture) {
        LOG.error("Remote client closed the connection while writing 100 continue response");
    }

    @Override
    public ChannelFuture handleIdleTimeoutConnectionClosure(ServerConnectorFuture serverConnectorFuture, ChannelHandlerContext ctx) {
        LOG.error("Idle timeout triggered while writing 100 continue response");
        return null;
    }

    private void checkForResponseWriteStatus(HttpCarbonMessage inboundRequestMsg, HttpResponseFuture outboundRespStatusFuture, ChannelFuture channelFuture) {
        channelFuture.addListener(writeOperationPromise -> {
            Throwable throwable = writeOperationPromise.cause();
            if (throwable != null) {
                if (throwable instanceof ClosedChannelException) {
                    throwable = new IOException("Connection between remote client and host is closed");
                }
                outboundRespStatusFuture.notifyHttpListener(throwable);
            } else {
                outboundRespStatusFuture.notifyHttpListener(inboundRequestMsg);
            }
        });
    }
}

