/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.listener.states;

import io.ballerina.stdlib.http.transport.contract.ServerConnectorFuture;
import io.ballerina.stdlib.http.transport.contract.exceptions.ServerConnectorException;
import io.ballerina.stdlib.http.transport.contractimpl.HttpOutboundRespListener;
import io.ballerina.stdlib.http.transport.contractimpl.listener.SourceHandler;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.ListenerReqRespStateManager;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.ListenerState;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.ReceivingHeaders;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseCompleted
implements ListenerState {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseCompleted.class);
    private final SourceHandler sourceHandler;
    private final ListenerReqRespStateManager listenerReqRespStateManager;

    ResponseCompleted(ListenerReqRespStateManager listenerReqRespStateManager, SourceHandler sourceHandler, HttpCarbonMessage inboundRequestMsg) {
        this.listenerReqRespStateManager = listenerReqRespStateManager;
        this.sourceHandler = sourceHandler;
        this.cleanupSourceHandler(inboundRequestMsg);
    }

    @Override
    public void readInboundRequestHeaders(HttpCarbonMessage inboundRequestMsg, HttpRequest inboundRequestHeaders) {
        this.listenerReqRespStateManager.state = new ReceivingHeaders(this.listenerReqRespStateManager, this.sourceHandler);
        this.listenerReqRespStateManager.readInboundRequestHeaders(inboundRequestMsg, inboundRequestHeaders);
    }

    @Override
    public void readInboundRequestBody(Object inboundRequestEntityBody) throws ServerConnectorException {
        LOG.warn("readInboundRequestBody {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void writeOutboundResponseHeaders(HttpCarbonMessage outboundResponseMsg, HttpContent httpContent) {
        LOG.warn("writeOutboundResponseHeaders {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void writeOutboundResponseBody(HttpOutboundRespListener outboundRespListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent) {
        LOG.warn("writeOutboundResponseBody {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void handleAbruptChannelClosure(ServerConnectorFuture serverConnectorFuture) {
        LOG.warn("handleAbruptChannelClosure {}", (Object)"is not a valid action of this state");
    }

    @Override
    public ChannelFuture handleIdleTimeoutConnectionClosure(ServerConnectorFuture serverConnectorFuture, ChannelHandlerContext ctx) {
        LOG.warn("handleIdleTimeoutConnectionClosure {}", (Object)"is not a valid action of this state");
        return null;
    }

    private void cleanupSourceHandler(HttpCarbonMessage inboundRequestMsg) {
        this.sourceHandler.removeRequestEntry(inboundRequestMsg);
        inboundRequestMsg.waitAndReleaseAllEntities();
    }
}

