/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.sender;

import io.ballerina.stdlib.http.transport.contract.config.InboundMsgSizeValidationConfig;
import io.ballerina.stdlib.http.transport.contract.config.KeepAliveConfig;
import io.ballerina.stdlib.http.transport.contract.config.ProxyServerConfiguration;
import io.ballerina.stdlib.http.transport.contract.config.SenderConfiguration;
import io.ballerina.stdlib.http.transport.contractimpl.DefaultHttpClientUpgradeHandler;
import io.ballerina.stdlib.http.transport.contractimpl.common.BackPressureHandler;
import io.ballerina.stdlib.http.transport.contractimpl.common.FrameLogger;
import io.ballerina.stdlib.http.transport.contractimpl.common.HttpRoute;
import io.ballerina.stdlib.http.transport.contractimpl.common.Util;
import io.ballerina.stdlib.http.transport.contractimpl.common.http2.Http2ExceptionHandler;
import io.ballerina.stdlib.http.transport.contractimpl.common.ssl.SSLConfig;
import io.ballerina.stdlib.http.transport.contractimpl.common.ssl.SSLHandlerFactory;
import io.ballerina.stdlib.http.transport.contractimpl.listener.HttpExceptionHandler;
import io.ballerina.stdlib.http.transport.contractimpl.listener.HttpTraceLoggingHandler;
import io.ballerina.stdlib.http.transport.contractimpl.sender.CertificateValidationHandler;
import io.ballerina.stdlib.http.transport.contractimpl.sender.ConnectionAvailabilityFuture;
import io.ballerina.stdlib.http.transport.contractimpl.sender.OCSPStaplingHandler;
import io.ballerina.stdlib.http.transport.contractimpl.sender.ResponseEntityBodySizeValidator;
import io.ballerina.stdlib.http.transport.contractimpl.sender.SslHandshakeCompletionHandlerForClient;
import io.ballerina.stdlib.http.transport.contractimpl.sender.StatusLineAndHeaderLengthValidator;
import io.ballerina.stdlib.http.transport.contractimpl.sender.TargetHandler;
import io.ballerina.stdlib.http.transport.contractimpl.sender.channel.pool.ConnectionManager;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.ClientFrameListener;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.Http2ClientChannel;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.Http2ConnectionManager;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.Http2TargetHandler;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private TargetHandler targetHandler;
    private boolean httpTraceLogEnabled;
    private boolean httpAccessLogEnabled;
    private KeepAliveConfig keepAliveConfig;
    private ProxyServerConfiguration proxyServerConfiguration;
    private Http2ConnectionManager http2ConnectionManager;
    private boolean http2 = false;
    private Http2ConnectionHandler http2ConnectionHandler;
    private ClientFrameListener clientFrameListener;
    private Http2TargetHandler http2TargetHandler;
    private Http2Connection connection;
    private SSLConfig sslConfig;
    private HttpRoute httpRoute;
    private SenderConfiguration senderConfiguration;
    private ConnectionAvailabilityFuture connectionAvailabilityFuture;
    private final InboundMsgSizeValidationConfig responseSizeValidationConfig;
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientChannelInitializer.class);

    public HttpClientChannelInitializer(SenderConfiguration senderConfiguration, HttpRoute httpRoute, ConnectionManager connectionManager, ConnectionAvailabilityFuture connectionAvailabilityFuture) {
        this.httpTraceLogEnabled = senderConfiguration.isHttpTraceLogEnabled();
        this.httpAccessLogEnabled = senderConfiguration.isHttpAccessLogEnabled();
        this.keepAliveConfig = senderConfiguration.getKeepAliveConfig();
        this.proxyServerConfiguration = senderConfiguration.getProxyServerConfiguration();
        this.http2ConnectionManager = connectionManager.getHttp2ConnectionManager();
        this.senderConfiguration = senderConfiguration;
        this.httpRoute = httpRoute;
        this.sslConfig = senderConfiguration.getClientSSLConfig();
        this.connectionAvailabilityFuture = connectionAvailabilityFuture;
        this.responseSizeValidationConfig = senderConfiguration.getMsgSizeValidationConfig();
        String httpVersion = senderConfiguration.getHttpVersion();
        if ("2.0".equals(httpVersion)) {
            this.http2 = true;
        }
        this.connection = new DefaultHttp2Connection(false);
        this.clientFrameListener = new ClientFrameListener();
        DelegatingDecompressorFrameListener frameListener = new DelegatingDecompressorFrameListener(this.connection, (Http2FrameListener)this.clientFrameListener);
        Http2ConnectionHandlerBuilder connectionHandlerBuilder = new Http2ConnectionHandlerBuilder();
        if (this.httpTraceLogEnabled) {
            connectionHandlerBuilder.frameLogger((Http2FrameLogger)new FrameLogger(LogLevel.TRACE, "http.tracelog.upstream"));
        }
        connectionHandlerBuilder.initialSettings().initialWindowSize(senderConfiguration.getHttp2InitialWindowSize());
        this.http2ConnectionHandler = connectionHandlerBuilder.connection(this.connection).frameListener((Http2FrameListener)frameListener).build();
        this.http2TargetHandler = new Http2TargetHandler(this.connection, this.http2ConnectionHandler.encoder());
    }

    protected void initChannel(SocketChannel socketChannel) throws Exception {
        ChannelPipeline clientPipeline = socketChannel.pipeline();
        this.configureProxyServer(clientPipeline);
        this.targetHandler = new TargetHandler();
        this.targetHandler.setHttp2TargetHandler(this.http2TargetHandler);
        this.targetHandler.setKeepAliveConfig(this.getKeepAliveConfig());
        this.targetHandler.setHttpClientChannelInitializer(this);
        this.http2TargetHandler.setHttpClientChannelInitializer(this);
        if (this.http2) {
            if (this.sslConfig != null) {
                if (!this.sslConfig.hasSslCtxInitialized()) {
                    this.sslConfig.initializeSSLContext(this.http2);
                }
                this.configureSslForHttp2(socketChannel, clientPipeline, this.sslConfig);
            } else if (this.senderConfiguration.isForceHttp2()) {
                this.configureHttp2Pipeline(clientPipeline);
            } else {
                this.configureHttp2UpgradePipeline(clientPipeline, this.targetHandler);
            }
        } else {
            if (this.sslConfig != null) {
                if (!this.sslConfig.hasSslCtxInitialized()) {
                    this.sslConfig.initializeSSLContext(this.http2);
                }
                this.connectionAvailabilityFuture.setSSLEnabled(true);
                SSLEngine sslEngine = Util.configureHttpPipelineForSSL(socketChannel, this.httpRoute.getHost(), this.httpRoute.getPort(), this.sslConfig);
                Util.setAlpnProtocols(sslEngine);
                clientPipeline.addLast("sslHandshakeCompletionHandler", (ChannelHandler)new SslHandshakeCompletionHandlerForClient(this.connectionAvailabilityFuture, this, this.targetHandler, sslEngine));
            } else {
                this.configureHttpPipeline(clientPipeline, this.targetHandler);
            }
            clientPipeline.addLast("HttpExceptionHandler", (ChannelHandler)new HttpExceptionHandler());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (LOG.isWarnEnabled()) {
            LOG.warn("Failed to initialize a channel. Closing: " + String.valueOf(ctx.channel()), cause);
        }
        this.connectionAvailabilityFuture.notifyFailure(cause);
        ctx.close();
    }

    private void configureProxyServer(ChannelPipeline clientPipeline) {
        if (this.proxyServerConfiguration != null && this.sslConfig != null) {
            if (this.proxyServerConfiguration.getProxyUsername() != null && this.proxyServerConfiguration.getProxyPassword() != null) {
                clientPipeline.addLast("proxyServerHandler", (ChannelHandler)new HttpProxyHandler((SocketAddress)this.proxyServerConfiguration.getInetSocketAddress(), this.proxyServerConfiguration.getProxyUsername(), this.proxyServerConfiguration.getProxyPassword()));
            } else {
                clientPipeline.addLast("proxyServerHandler", (ChannelHandler)new HttpProxyHandler((SocketAddress)this.proxyServerConfiguration.getInetSocketAddress()));
            }
        }
    }

    private void configureSslForHttp2(SocketChannel ch, ChannelPipeline clientPipeline, SSLConfig sslConfig) {
        this.connectionAvailabilityFuture.setSSLEnabled(true);
        if (sslConfig.isOcspStaplingEnabled()) {
            ReferenceCountedOpenSslContext referenceCountedOpenSslContext = sslConfig.getReferenceCountedOpenSslContext();
            if (referenceCountedOpenSslContext != null) {
                SslHandler sslHandler = referenceCountedOpenSslContext.newHandler(ch.alloc());
                ReferenceCountedOpenSslEngine engine = (ReferenceCountedOpenSslEngine)sslHandler.engine();
                Util.setSslHandshakeTimeOut(sslConfig, sslHandler);
                ch.pipeline().addLast(new ChannelHandler[]{sslHandler});
                ch.pipeline().addLast(new ChannelHandler[]{new OCSPStaplingHandler(engine)});
            }
        } else if (sslConfig.isDisableSsl()) {
            SslContext sslCtx = sslConfig.getSslContext();
            SslHandler sslHandler = sslCtx.newHandler(ch.alloc(), this.httpRoute.getHost(), this.httpRoute.getPort());
            clientPipeline.addLast(new ChannelHandler[]{sslHandler});
        } else {
            SslContext sslCtx = sslConfig.getSslContext();
            SslHandler sslHandler = sslCtx.newHandler(ch.alloc(), this.httpRoute.getHost(), this.httpRoute.getPort());
            SSLEngine sslEngine = sslHandler.engine();
            SSLHandlerFactory sslHandlerFactory = new SSLHandlerFactory(sslConfig);
            sslHandlerFactory.setSNIServerNames(sslEngine, sslConfig.getSniHostName() != null ? sslConfig.getSniHostName() : this.httpRoute.getHost());
            if (sslConfig.isHostNameVerificationEnabled()) {
                Util.setHostNameVerfication(sslEngine);
            }
            Util.setSslHandshakeTimeOut(sslConfig, sslHandler);
            clientPipeline.addLast(new ChannelHandler[]{sslHandler});
            if (sslConfig.isValidateCertEnabled()) {
                clientPipeline.addLast("certificateValidation", (ChannelHandler)new CertificateValidationHandler(sslEngine, sslConfig.getCacheValidityPeriod(), sslConfig.getCacheSize()));
            }
        }
        clientPipeline.addLast(new ChannelHandler[]{new ALPNClientHandler(this.targetHandler, this.connectionAvailabilityFuture)});
        clientPipeline.addLast("Http2ExceptionHandler", (ChannelHandler)new Http2ExceptionHandler(this.http2ConnectionHandler));
    }

    public boolean isHttpAccessLogEnabled() {
        return this.httpAccessLogEnabled;
    }

    public TargetHandler getTargetHandler() {
        return this.targetHandler;
    }

    public Http2ConnectionManager getHttp2ConnectionManager() {
        return this.http2ConnectionManager;
    }

    public SSLConfig getSslConfig() {
        return this.sslConfig;
    }

    private void configureHttp2UpgradePipeline(ChannelPipeline pipeline, TargetHandler targetHandler) {
        HttpClientCodec sourceCodec = new HttpClientCodec(this.responseSizeValidationConfig.getMaxInitialLineLength(), this.responseSizeValidationConfig.getMaxHeaderSize(), this.responseSizeValidationConfig.getMaxChunkSize());
        pipeline.addLast("codec", (ChannelHandler)sourceCodec);
        this.addCommonHandlers(pipeline);
        Http2ClientUpgradeCodec upgradeCodec = new Http2ClientUpgradeCodec(this.http2ConnectionHandler);
        DefaultHttpClientUpgradeHandler upgradeHandler = new DefaultHttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)sourceCodec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, Integer.MAX_VALUE);
        pipeline.addLast("Http2UpgradeHandler", (ChannelHandler)upgradeHandler);
        this.addResponseLimitValidationHandlers(pipeline);
        pipeline.addLast("targetHandler", (ChannelHandler)targetHandler);
    }

    private void configureHttp2Pipeline(ChannelPipeline pipeline) {
        Util.safelyRemoveHandlers(pipeline, "Http2ExceptionHandler");
        pipeline.addLast("connectionHandler", (ChannelHandler)this.http2ConnectionHandler);
        pipeline.addLast("http2TargetHandler", (ChannelHandler)this.http2TargetHandler);
        pipeline.addLast("deCompressor", (ChannelHandler)new HttpContentDecompressor());
        pipeline.addLast("Http2ExceptionHandler", (ChannelHandler)new Http2ExceptionHandler(this.http2ConnectionHandler));
    }

    public void configureHttpPipeline(ChannelPipeline pipeline, TargetHandler targetHandler) {
        HttpClientCodec clientCodec = new HttpClientCodec(this.responseSizeValidationConfig.getMaxInitialLineLength(), this.responseSizeValidationConfig.getMaxHeaderSize(), this.responseSizeValidationConfig.getMaxChunkSize());
        pipeline.addLast("codec", (ChannelHandler)clientCodec);
        this.addCommonHandlers(pipeline);
        this.addResponseLimitValidationHandlers(pipeline);
        pipeline.addLast("BackPressureHandler", (ChannelHandler)new BackPressureHandler());
        pipeline.addLast("targetHandler", (ChannelHandler)targetHandler);
    }

    private void addResponseLimitValidationHandlers(ChannelPipeline pipeline) {
        pipeline.addLast("statusLineAndHeaderLengthValidator", (ChannelHandler)new StatusLineAndHeaderLengthValidator());
        if (this.responseSizeValidationConfig.getMaxEntityBodySize() > -1L) {
            pipeline.addLast("maxEntityBodyValidator", (ChannelHandler)new ResponseEntityBodySizeValidator(this.responseSizeValidationConfig.getMaxEntityBodySize()));
        }
    }

    private void addCommonHandlers(ChannelPipeline pipeline) {
        pipeline.addLast("deCompressor", (ChannelHandler)new HttpContentDecompressor());
        if (this.httpTraceLogEnabled) {
            pipeline.addLast("http-trace-logger", (ChannelHandler)new HttpTraceLoggingHandler("http.tracelog.upstream"));
        }
    }

    public Http2Connection getConnection() {
        return this.connection;
    }

    public KeepAliveConfig getKeepAliveConfig() {
        return this.keepAliveConfig;
    }

    public void setHttp2ClientChannel(Http2ClientChannel http2ClientChannel) {
        this.http2TargetHandler.setHttp2ClientChannel(http2ClientChannel);
        this.clientFrameListener.setHttp2ClientChannel(http2ClientChannel);
    }

    class ALPNClientHandler
    extends ApplicationProtocolNegotiationHandler {
        private TargetHandler targetHandler;
        private ConnectionAvailabilityFuture connectionAvailabilityFuture;

        public ALPNClientHandler(TargetHandler targetHandler, ConnectionAvailabilityFuture connectionAvailabilityFuture) {
            super("http/1.1");
            this.targetHandler = targetHandler;
            this.connectionAvailabilityFuture = connectionAvailabilityFuture;
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            this.connectionAvailabilityFuture.notifyFailure(new ClosedChannelException());
            ctx.close();
        }

        protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
            if ("h2".equals(protocol)) {
                HttpClientChannelInitializer.this.configureHttp2Pipeline(ctx.pipeline());
                this.connectionAvailabilityFuture.notifySuccess("h2");
            } else if ("http/1.1".equals(protocol)) {
                HttpClientChannelInitializer.this.configureHttpPipeline(ctx.pipeline(), this.targetHandler);
                this.connectionAvailabilityFuture.notifySuccess("h1");
            } else {
                throw new IllegalStateException("Unknown protocol: " + protocol);
            }
        }

        protected void handshakeFailure(ChannelHandlerContext ctx, Throwable cause) {
            if (cause.toString().contains("ssl") || cause.toString().contains("security")) {
                while (cause.getCause() != null && cause.getCause() != cause) {
                    cause = cause.getCause();
                }
            }
            this.connectionAvailabilityFuture.notifyFailure(cause);
            ctx.close();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            if (ctx != null) {
                if (ctx.channel().isActive()) {
                    ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                } else {
                    this.connectionAvailabilityFuture.notifyFailure(cause);
                    ctx.close();
                }
            }
        }
    }
}

