/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.sender;

import io.ballerina.stdlib.http.transport.contract.HttpResponseFuture;
import io.ballerina.stdlib.http.transport.contract.config.KeepAliveConfig;
import io.ballerina.stdlib.http.transport.contractimpl.common.Util;
import io.ballerina.stdlib.http.transport.contractimpl.common.states.Http2StateUtil;
import io.ballerina.stdlib.http.transport.contractimpl.common.states.SenderReqRespStateManager;
import io.ballerina.stdlib.http.transport.contractimpl.sender.HttpClientChannelInitializer;
import io.ballerina.stdlib.http.transport.contractimpl.sender.channel.TargetChannel;
import io.ballerina.stdlib.http.transport.contractimpl.sender.channel.pool.ConnectionManager;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.Http2ClientChannel;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.Http2ClientTimeoutHandler;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.Http2TargetHandler;
import io.ballerina.stdlib.http.transport.internal.HandlerExecutor;
import io.ballerina.stdlib.http.transport.internal.HttpTransportContextHolder;
import io.ballerina.stdlib.http.transport.message.ClientRemoteFlowControlListener;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http2.Http2ConnectionPrefaceAndSettingsFrameWrittenEvent;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.handler.ssl.SslCloseCompletionEvent;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.ReferenceCountUtil;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(TargetHandler.class);
    private HttpResponseFuture httpResponseFuture;
    private HttpCarbonMessage inboundResponseMsg;
    private ConnectionManager connectionManager;
    private TargetChannel targetChannel;
    private Http2TargetHandler http2TargetHandler;
    private HttpCarbonMessage outboundRequestMsg;
    private HandlerExecutor handlerExecutor;
    private KeepAliveConfig keepAliveConfig;
    private boolean idleTimeoutTriggered;
    private ChannelHandlerContext context;
    private Throwable cause;
    private HttpClientChannelInitializer httpClientChannelInitializer;

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.context = ctx;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        SenderReqRespStateManager senderReqRespStateManager = this.targetChannel.senderReqRespStateManager;
        if (this.handlerExecutor != null) {
            this.handlerExecutor.executeAtTargetResponseReceiving(this.inboundResponseMsg);
        }
        if (this.targetChannel.isRequestHeaderWritten()) {
            if (msg instanceof HttpResponse) {
                if (this.isAbnormal100Response((HttpResponse)msg)) {
                    LOG.warn("Received an unexpected 100-continue response");
                } else {
                    this.inboundResponseMsg = Util.createInboundRespCarbonMsg(ctx, (HttpResponse)msg, this.outboundRequestMsg);
                    senderReqRespStateManager.readInboundResponseHeaders(this, (HttpResponse)msg);
                }
            } else if (this.inboundResponseMsg != null) {
                senderReqRespStateManager.readInboundResponseEntityBody(ctx, (HttpContent)msg, this.getInboundResponseMsg());
            }
        } else {
            if (msg instanceof HttpResponse) {
                LOG.warn("Received a response for an obsolete request {}", msg);
            }
            ReferenceCountUtil.release((Object)msg);
        }
    }

    private boolean isAbnormal100Response(HttpResponse msg) {
        return msg.status().code() == 100 && !this.outboundRequestMsg.is100ContinueExpected();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.handlerExecutor = HttpTransportContextHolder.getInstance().getHandlerExecutor();
        if (this.handlerExecutor != null) {
            this.handlerExecutor.executeAtTargetConnectionInitiation(Integer.toString(ctx.hashCode()));
        }
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (!this.idleTimeoutTriggered) {
            this.targetChannel.senderReqRespStateManager.handleAbruptChannelClosure(this, this.httpResponseFuture);
        }
        this.releasePerRoutePoolLatchOnFailure();
        this.connectionManager.invalidateTargetChannel(this.targetChannel);
        if (this.handlerExecutor != null) {
            this.handlerExecutor.executeAtTargetConnectionTermination(Integer.toString(ctx.hashCode()));
            this.handlerExecutor = null;
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.cause = cause;
        this.closeChannel(ctx);
        LOG.warn("Exception occurred in TargetHandler : {}", (Object)cause.getMessage());
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            this.idleTimeoutTriggered = true;
            this.targetChannel.senderReqRespStateManager.handleIdleTimeoutConnectionClosure(this, this.httpResponseFuture, ctx.channel().id().asLongText());
        } else if (evt instanceof HttpClientUpgradeHandler.UpgradeEvent) {
            HttpClientUpgradeHandler.UpgradeEvent upgradeEvent = (HttpClientUpgradeHandler.UpgradeEvent)evt;
            if (HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_SUCCESSFUL.name().equals(upgradeEvent.name())) {
                this.executePostUpgradeActions(ctx);
            } else if (HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_REJECTED.name().equals(upgradeEvent.name())) {
                this.releasePerRoutePoolLatchOnFailure();
            }
            ctx.fireUserEventTriggered(evt);
        } else {
            this.logTheErrorMsg(evt);
        }
    }

    private void logTheErrorMsg(Object evt) {
        if (evt instanceof Http2ConnectionPrefaceAndSettingsFrameWrittenEvent) {
            LOG.debug("Connection Preface and Settings frame written");
        } else if (evt instanceof SslCloseCompletionEvent) {
            LOG.debug("SSL close completion event received");
        } else if (evt instanceof SslHandshakeCompletionEvent) {
            LOG.debug("SSL handshake completion event received");
        } else if (evt instanceof ChannelInputShutdownReadComplete) {
            LOG.debug("Input side of the connection is already shutdown");
        } else {
            this.releasePerRoutePoolLatchOnFailure();
            LOG.warn("Unexpected user event {} triggered", evt);
        }
    }

    private void executePostUpgradeActions(ChannelHandlerContext ctx) {
        ctx.pipeline().remove((ChannelHandler)this);
        ctx.pipeline().addLast("http2TargetHandler", (ChannelHandler)this.http2TargetHandler);
        Http2ClientChannel http2ClientChannel = this.http2TargetHandler.getHttp2ClientChannel();
        Util.safelyRemoveHandlers(this.targetChannel.getChannel().pipeline(), "idleStateHandler", "http-trace-logger");
        Http2StateUtil.initHttp2MessageContext(this.outboundRequestMsg, this.http2TargetHandler);
        http2ClientChannel.addDataEventListener("idleStateHandler", new Http2ClientTimeoutHandler(http2ClientChannel.getSocketIdleTimeout(), http2ClientChannel));
        http2ClientChannel.getInFlightMessage(1).setRequestWritten(true);
        http2ClientChannel.getDataEventListeners().forEach(dataEventListener -> dataEventListener.onStreamInit(ctx, 1));
        this.handoverChannelToHttp2ConnectionManager();
    }

    private void handoverChannelToHttp2ConnectionManager() {
        Http2ClientChannel upgradedHttp2ClientChannel = this.targetChannel.getHttp2ClientChannel();
        this.connectionManager.getHttp2ConnectionManager().addHttp2ClientChannel(this.targetChannel.getHttpRoute(), upgradedHttp2ClientChannel);
        ((Http2RemoteFlowController)upgradedHttp2ClientChannel.getConnection().remote().flowController()).listener((Http2RemoteFlowController.Listener)new ClientRemoteFlowControlListener(upgradedHttp2ClientChannel));
    }

    public void closeChannel(ChannelHandlerContext ctx) {
        if (ctx != null && ctx.channel().isActive()) {
            ctx.close();
        }
    }

    private void releasePerRoutePoolLatchOnFailure() {
        if (Objects.nonNull(this.connectionManager)) {
            this.connectionManager.getHttp2ConnectionManager().releasePerRoutePoolLatch(this.targetChannel.getHttpRoute());
        }
    }

    public void setHttpResponseFuture(HttpResponseFuture httpResponseFuture) {
        this.httpResponseFuture = httpResponseFuture;
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void setOutboundRequestMsg(HttpCarbonMessage outboundRequestMsg) {
        this.outboundRequestMsg = outboundRequestMsg;
    }

    public void setTargetChannel(TargetChannel targetChannel) {
        this.targetChannel = targetChannel;
    }

    public void setKeepAliveConfig(KeepAliveConfig keepAliveConfig) {
        this.keepAliveConfig = keepAliveConfig;
    }

    public HttpResponseFuture getHttpResponseFuture() {
        return this.httpResponseFuture;
    }

    void setHttp2TargetHandler(Http2TargetHandler http2TargetHandler) {
        this.http2TargetHandler = http2TargetHandler;
    }

    public HttpCarbonMessage getInboundResponseMsg() {
        return this.inboundResponseMsg;
    }

    public Http2TargetHandler getHttp2TargetHandler() {
        return this.http2TargetHandler;
    }

    public void resetInboundMsg() {
        this.inboundResponseMsg = null;
    }

    public TargetChannel getTargetChannel() {
        return this.targetChannel;
    }

    public KeepAliveConfig getKeepAliveConfig() {
        return this.keepAliveConfig;
    }

    public HttpCarbonMessage getOutboundRequestMsg() {
        return this.outboundRequestMsg;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public ChannelHandlerContext getContext() {
        return this.context;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public HttpClientChannelInitializer getHttpClientChannelInitializer() {
        return this.httpClientChannelInitializer;
    }

    public void setHttpClientChannelInitializer(HttpClientChannelInitializer httpClientChannelInitializer) {
        this.httpClientChannelInitializer = httpClientChannelInitializer;
    }
}

