/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.sender.channel.pool;

import io.ballerina.stdlib.http.transport.contract.config.SenderConfiguration;
import io.ballerina.stdlib.http.transport.contractimpl.common.HttpRoute;
import io.ballerina.stdlib.http.transport.contractimpl.sender.ConnectionAvailabilityFuture;
import io.ballerina.stdlib.http.transport.contractimpl.sender.HttpClientChannelInitializer;
import io.ballerina.stdlib.http.transport.contractimpl.sender.channel.BootstrapConfiguration;
import io.ballerina.stdlib.http.transport.contractimpl.sender.channel.TargetChannel;
import io.ballerina.stdlib.http.transport.contractimpl.sender.channel.pool.ConnectionManager;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.Http2ClientChannel;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.commons.pool.PoolableObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolableTargetChannelFactory
implements PoolableObjectFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PoolableTargetChannelFactory.class);
    private EventLoopGroup eventLoopGroup;
    private Class eventLoopClass;
    private final HttpRoute httpRoute;
    private final SenderConfiguration senderConfiguration;
    private final BootstrapConfiguration bootstrapConfiguration;
    private final ConnectionManager connectionManager;
    private String remoteAddress;

    PoolableTargetChannelFactory(EventLoopGroup eventLoopGroup, Class eventLoopClass, HttpRoute httpRoute, SenderConfiguration senderConfiguration, BootstrapConfiguration bootstrapConfiguration, ConnectionManager connectionManager) {
        this.eventLoopGroup = eventLoopGroup;
        this.eventLoopClass = eventLoopClass;
        this.httpRoute = httpRoute;
        this.senderConfiguration = senderConfiguration;
        this.bootstrapConfiguration = bootstrapConfiguration;
        this.connectionManager = connectionManager;
    }

    public Object makeObject() throws Exception {
        Bootstrap clientBootstrap = this.instantiateAndConfigBootStrap(this.eventLoopGroup, this.eventLoopClass, this.bootstrapConfiguration);
        ConnectionAvailabilityFuture connectionAvailabilityFuture = new ConnectionAvailabilityFuture();
        HttpClientChannelInitializer httpClientChannelInitializer = this.instantiateAndConfigClientInitializer(this.senderConfiguration, clientBootstrap, this.httpRoute, this.connectionManager, connectionAvailabilityFuture);
        clientBootstrap.handler((ChannelHandler)httpClientChannelInitializer);
        TargetChannel targetChannel = this.createNewTargetChannel(clientBootstrap, connectionAvailabilityFuture, httpClientChannelInitializer);
        LOG.debug("Created channel: {}", (Object)this.httpRoute);
        return targetChannel;
    }

    private TargetChannel createNewTargetChannel(Bootstrap clientBootstrap, ConnectionAvailabilityFuture connectionAvailabilityFuture, HttpClientChannelInitializer httpClientChannelInitializer) {
        ChannelFuture channelFuture = this.connectToRemoteEndpoint(clientBootstrap);
        connectionAvailabilityFuture.setSocketAvailabilityFuture(channelFuture, this.remoteAddress);
        connectionAvailabilityFuture.setForceHttp2(this.senderConfiguration.isForceHttp2());
        TargetChannel targetChannel = new TargetChannel(httpClientChannelInitializer, channelFuture, this.httpRoute, connectionAvailabilityFuture);
        httpClientChannelInitializer.setHttp2ClientChannel(targetChannel.getHttp2ClientChannel());
        return targetChannel;
    }

    private ChannelFuture connectToRemoteEndpoint(Bootstrap clientBootstrap) {
        InetSocketAddress socketAddress = this.senderConfiguration.getProxyServerConfiguration() != null && this.senderConfiguration.getScheme().equals("http") ? new InetSocketAddress(this.senderConfiguration.getProxyServerConfiguration().getProxyHost(), this.senderConfiguration.getProxyServerConfiguration().getProxyPort()) : new InetSocketAddress(this.httpRoute.getHost(), this.httpRoute.getPort());
        this.remoteAddress = socketAddress.toString();
        ChannelFuture channelFuture = clientBootstrap.connect((SocketAddress)socketAddress);
        return channelFuture;
    }

    private Bootstrap instantiateAndConfigBootStrap(EventLoopGroup eventLoopGroup, Class eventLoopClass, BootstrapConfiguration bootstrapConfiguration) {
        Bootstrap clientBootstrap = new Bootstrap();
        clientBootstrap.channel(eventLoopClass);
        clientBootstrap.group(eventLoopGroup);
        clientBootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)bootstrapConfiguration.isKeepAlive());
        clientBootstrap.option(ChannelOption.TCP_NODELAY, (Object)bootstrapConfiguration.isTcpNoDelay());
        clientBootstrap.option(ChannelOption.SO_REUSEADDR, (Object)bootstrapConfiguration.isSocketReuse());
        clientBootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)bootstrapConfiguration.getConnectTimeOut());
        clientBootstrap.option(ChannelOption.SO_RCVBUF, (Object)bootstrapConfiguration.getReceiveBufferSize());
        clientBootstrap.option(ChannelOption.SO_SNDBUF, (Object)bootstrapConfiguration.getSendBufferSize());
        return clientBootstrap;
    }

    private HttpClientChannelInitializer instantiateAndConfigClientInitializer(SenderConfiguration senderConfiguration, Bootstrap clientBootstrap, HttpRoute httpRoute, ConnectionManager connectionManager, ConnectionAvailabilityFuture connectionAvailabilityFuture) {
        HttpClientChannelInitializer httpClientChannelInitializer = new HttpClientChannelInitializer(senderConfiguration, httpRoute, connectionManager, connectionAvailabilityFuture);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created new TCP client bootstrap connecting to {}:{} with options: {}", new Object[]{httpRoute.getHost(), httpRoute.getPort(), clientBootstrap});
        }
        return httpClientChannelInitializer;
    }

    public void destroyObject(Object o) throws Exception {
        TargetChannel targetChannel = (TargetChannel)o;
        Channel http1Channel = targetChannel.getChannel();
        if (http1Channel != null) {
            if (http1Channel.isOpen()) {
                http1Channel.close();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Destroying channel: {}", (Object)http1Channel.id());
            }
        } else {
            Http2ClientChannel http2ClientChannel = targetChannel.getHttp2ClientChannel();
            if (http2ClientChannel != null && http2ClientChannel.getChannel() != null) {
                Channel channel = http2ClientChannel.getChannel();
                if (channel.isOpen()) {
                    channel.close();
                }
            } else {
                LOG.warn("TargetChannel does not have a valid channel to destroy.");
            }
        }
    }

    public boolean validateObject(Object o) {
        TargetChannel targetChannel = (TargetChannel)o;
        if (targetChannel.getChannel() != null) {
            boolean answer = targetChannel.getChannel().isActive();
            LOG.debug("Validating channel: {} -> {}", (Object)targetChannel.getChannel().id(), (Object)answer);
            return answer;
        }
        return true;
    }

    public void activateObject(Object o) throws Exception {
    }

    public void passivateObject(Object o) throws Exception {
    }

    public void setEventLoopGroup(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
    }

    public void setEventLoopClass(Class eventLoopClass) {
        this.eventLoopClass = eventLoopClass;
    }
}

