/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.websocket;

import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketBinaryMessage;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketCloseMessage;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketConnection;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketConnectorException;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketConnectorFuture;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketConnectorListener;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketControlMessage;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketHandshaker;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketTextMessage;

public class DefaultWebSocketConnectorFuture
implements WebSocketConnectorFuture {
    private WebSocketConnectorListener wsConnectorListener;

    @Override
    public void setWebSocketConnectorListener(WebSocketConnectorListener wsConnectorListener) {
        this.wsConnectorListener = wsConnectorListener;
    }

    @Override
    public void notifyWebSocketListener(WebSocketHandshaker webSocketHandshaker) throws Exception {
        this.checkConnectorState();
        this.wsConnectorListener.onHandshake(webSocketHandshaker);
    }

    @Override
    public void notifyWebSocketListener(WebSocketTextMessage textMessage) throws WebSocketConnectorException {
        this.checkConnectorState();
        this.wsConnectorListener.onMessage(textMessage);
    }

    @Override
    public void notifyWebSocketListener(WebSocketBinaryMessage binaryMessage) throws WebSocketConnectorException {
        this.checkConnectorState();
        this.wsConnectorListener.onMessage(binaryMessage);
    }

    @Override
    public void notifyWebSocketListener(WebSocketControlMessage controlMessage) throws WebSocketConnectorException {
        this.checkConnectorState();
        this.wsConnectorListener.onMessage(controlMessage);
    }

    @Override
    public void notifyWebSocketListener(WebSocketCloseMessage closeMessage) throws WebSocketConnectorException {
        this.checkConnectorState();
        this.wsConnectorListener.onMessage(closeMessage);
    }

    @Override
    public void notifyWebSocketListener(WebSocketConnection webSocketConnection, Throwable throwable) throws WebSocketConnectorException {
        this.checkConnectorState();
        this.wsConnectorListener.onError(webSocketConnection, throwable);
    }

    @Override
    public void notifyWebSocketIdleTimeout(WebSocketControlMessage controlMessage) throws WebSocketConnectorException {
        this.checkConnectorState();
        this.wsConnectorListener.onIdleTimeout(controlMessage);
    }

    @Override
    public void notifyWebSocketListener(WebSocketConnection webSocketConnection) throws WebSocketConnectorException {
        this.checkConnectorState();
        this.wsConnectorListener.onClose(webSocketConnection);
    }

    private void checkConnectorState() throws WebSocketConnectorException {
        if (this.wsConnectorListener == null) {
            throw new WebSocketConnectorException("WebSocket connector listener is not set");
        }
    }
}

