/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.message;

import io.ballerina.stdlib.http.transport.message.Listener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2Stream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http2InboundContentListener
implements Listener {
    private static final Logger LOG = LoggerFactory.getLogger(Http2InboundContentListener.class);
    private int streamId;
    private Http2Connection http2Connection;
    private boolean appConsumeRequired = true;
    private AtomicBoolean consumeInboundContent = new AtomicBoolean(true);
    private Http2LocalFlowController http2LocalFlowController;
    private ChannelHandlerContext channelHandlerContext;
    private String inboundType;

    public Http2InboundContentListener(int streamId, ChannelHandlerContext ctx, Http2Connection http2Connection, String inboundType) {
        this.streamId = streamId;
        this.http2Connection = http2Connection;
        this.http2LocalFlowController = (Http2LocalFlowController)http2Connection.local().flowController();
        this.channelHandlerContext = ctx;
        this.inboundType = inboundType;
    }

    @Override
    public void onAdd(HttpContent httpContent) {
        if (!this.appConsumeRequired && this.consumeInboundContent.get()) {
            EventLoop eventLoop;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stream {}. HTTP/2 {} onAdd consumeBytes {} ", new Object[]{this.streamId, this.inboundType, httpContent.content().readableBytes()});
            }
            if ((eventLoop = this.channelHandlerContext.channel().eventLoop()).inEventLoop()) {
                this.consumeBytes(httpContent.content().readableBytes());
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Call to onAdd() did not happen in eventloop thread");
                }
                this.updateLocalFlowController(httpContent.content().readableBytes());
            }
        }
    }

    @Override
    public void onRemove(HttpContent httpContent) {
        if (this.appConsumeRequired && this.consumeInboundContent.get()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stream {}. HTTP/2 {} onRemove updateLocalFlowController with bytes {} ", new Object[]{this.streamId, this.inboundType, httpContent.content().readableBytes()});
            }
            this.updateLocalFlowController(httpContent.content().readableBytes());
        }
    }

    @Override
    public void resumeReadInterest() {
        this.channelHandlerContext.channel().eventLoop().execute(() -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stream {}. In thread {}. {} resumeReadInterest. Unconsumed bytes: {}", new Object[]{this.streamId, Thread.currentThread().getName(), this.inboundType, this.getUnConsumedBytes()});
            }
            this.consumeOutstandingBytes();
            this.appConsumeRequired = false;
        });
    }

    void stopByteConsumption() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stream {}. In thread {}. {} stop byte consumption", new Object[]{this.streamId, Thread.currentThread().getName(), this.inboundType});
        }
        if (this.consumeInboundContent.get()) {
            this.consumeInboundContent.set(false);
        }
    }

    void resumeByteConsumption() {
        EventLoop eventLoop = this.channelHandlerContext.channel().eventLoop();
        if (eventLoop.inEventLoop()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stream {}. In thread {}. {} resume byte consumption. Unconsumed bytes: {}", new Object[]{this.streamId, Thread.currentThread().getName(), this.inboundType, this.getUnConsumedBytes()});
            }
            this.consumeOutstandingBytes();
            this.consumeInboundContent.set(true);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Call to resumeByteConsumption() did not happen in eventloop thread");
            }
            eventLoop.execute(() -> {
                this.consumeOutstandingBytes();
                this.consumeInboundContent.set(true);
            });
        }
    }

    private void consumeOutstandingBytes() {
        int unconsumedBytes = this.getUnConsumedBytes();
        if (unconsumedBytes > 0) {
            this.consumeBytes(unconsumedBytes);
        }
    }

    private void updateLocalFlowController(int consumedBytes) {
        this.channelHandlerContext.channel().eventLoop().execute(() -> this.consumeBytes(consumedBytes));
    }

    private void consumeBytes(int consumedBytes) {
        try {
            boolean windowUpdateSent;
            Http2Stream http2Stream = this.getHttp2Stream();
            if (http2Stream != null && consumedBytes <= this.getUnConsumedBytes() && (windowUpdateSent = this.http2LocalFlowController.consumeBytes(http2Stream, consumedBytes))) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Stream {}. {} windowUpdateSent and flushed {} bytes", new Object[]{this.streamId, this.inboundType, consumedBytes});
                }
                this.channelHandlerContext.flush();
            }
        }
        catch (Http2Exception e) {
            LOG.error("{} Error updating local flow controller. Stream {}. ConsumedBytes {}. Error code {} ", new Object[]{this.inboundType, this.streamId, consumedBytes, e.error().name()});
        }
    }

    private int getUnConsumedBytes() {
        Http2Stream http2Stream = this.getHttp2Stream();
        if (http2Stream != null) {
            return this.http2LocalFlowController.unconsumedBytes(http2Stream);
        }
        return 0;
    }

    private Http2Stream getHttp2Stream() {
        return this.http2Connection.stream(this.streamId);
    }
}

