/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.message;

import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.ballerina.stdlib.http.transport.message.MessageListener;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageFuture {
    private static final Logger LOG = LoggerFactory.getLogger(MessageFuture.class);
    private MessageListener messageListener;
    private final HttpCarbonMessage httpCarbonMessage;
    private final ReentrantLock futureLock = new ReentrantLock();

    public MessageFuture(HttpCarbonMessage httpCarbonMessage) {
        this.httpCarbonMessage = httpCarbonMessage;
    }

    public void setMessageListener(MessageListener messageListener) {
        this.futureLock.lock();
        try {
            this.messageListener = messageListener;
            while (!this.httpCarbonMessage.isEmpty()) {
                HttpContent httpContent = this.httpCarbonMessage.getHttpContent();
                this.notifyMessageListener(httpContent);
                if (!(httpContent instanceof LastHttpContent)) continue;
                this.httpCarbonMessage.removeMessageFuture();
                return;
            }
            if (this.httpCarbonMessage.isPassthrough()) {
                this.httpCarbonMessage.removeInboundContentListener();
            }
        }
        finally {
            this.futureLock.unlock();
        }
    }

    void notifyMessageListener(HttpContent httpContent) {
        if (this.messageListener != null) {
            this.messageListener.onMessage(httpContent);
        } else {
            LOG.error("The message chunk will be lost because the MessageListener is not set.");
        }
    }

    public boolean isMessageListenerSet() {
        return this.messageListener != null;
    }

    public HttpContent sync() {
        return this.httpCarbonMessage.getBlockingEntityCollector().getHttpContent();
    }
}

